/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.PackageMover;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.UploadTokenManager;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.arg.AssetDescriptions;
import com.apple.transporter.exception.ConcurrentTransportException;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.NetworkStatusReporter;
import com.apple.transporter.log.TransportLog;
import com.apple.transporter.log.UploadProgressReporter;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.model.PackageResult;
import com.apple.transporter.model.TransferTestITMSPackage;
import com.apple.transporter.operation.GenericApplicationOperationReturnValue;
import com.apple.transporter.operation.Verify;
import com.apple.transporter.operation.option.AssetReplacementVerificationOption;
import com.apple.transporter.operation.option.DeleteFastTransportLogOption;
import com.apple.transporter.operation.option.DeleteOption;
import com.apple.transporter.operation.option.FailureOption;
import com.apple.transporter.operation.option.LogHistoryOption;
import com.apple.transporter.operation.option.NumStreamsOption;
import com.apple.transporter.operation.option.SuccessOption;
import com.apple.transporter.operation.option.ThrottleOption;
import com.apple.transporter.operation.option.ThroughputOption;
import com.apple.transporter.operation.option.TransportOption;
import com.apple.transporter.transport.TransportByPodPolicy;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.transport.TransportSelectionPolicy;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.ThroughputUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class Upload
extends Verify {
    public static final String UPLOAD_MODE_VALUE = "upload";
    public static final String TransportLogFileNameUserInfoKey = "TransportLogFileName";
    public static final String TransferTimeUserInfoKey = "TransferTime";
    public static final String NewPackageNameUserInfoKey = "NewPackageName";
    public static final String RemoteFolderPathUserInfoKey = "RemoteFolderPath";
    public static final String AuthenticateReturnValueUserInfoKey = "AuthenticateReturnValue";
    public static final String IsDirectImportUserInfoKey = "IsDirectImport";
    public static final String ChecksumInfoUserInfoKey = "ChecksumInfo";
    public static final String TransportReturnValueUserInfoKey = "TransportReturnValue";
    public static final String FileSizeInfoUserInfoKey = "FileSizeInfo";

    public Upload(WebService service) {
        super(service);
        Application.setModeSupportsLogCompression(true);
        vpr.setPhase("Upload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performUploadRequest(String packagePath) {
        ArrayList<PackageResult> packageResults = new ArrayList<PackageResult>();
        packageResults.addAll(Upload.dealWithIgnorablePackagesInPackagePath(packagePath, true));
        List<File> files = ITMSPackage.validItmspFilesForDirectoryPath(packagePath);
        Iterator<File> filesEnum = null;
        if (files != null) {
            filesEnum = files.iterator();
        }
        Logger.startCachingLogMessages();
        while (filesEnum != null && filesEnum.hasNext()) {
            File aPkgFile = filesEnum.next();
            boolean success = false;
            Logger.startLogFileForPackage(aPkgFile);
            try {
                PackageResult result = this.performUploadRequest(aPkgFile);
                success = result.getStatus() == PackageResult.Status.Success;
                packageResults.add(result);
            }
            finally {
                Logger.cleanupLogFileForPackage(success);
                this.service.removeSession();
            }
            System.gc();
        }
        Logger.stopCachingLogMessages();
        Logger.clearLogCache();
        Application.displayWarningMessages();
        Application.displayInfoMessages();
        if (Application.shouldGenerateXML()) {
            Upload.showPackageOperationResultsXML(packageResults);
        } else {
            Upload.showPackageOperationResults(packageResults, "uploaded");
        }
        return !Upload.hasFailedOrIgnoredPackages(packageResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageResult performUploadRequest(File aPkgFile) {
        AssetDescriptions descriptions;
        ITMSPackage aPkg;
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification("PackageProcessingWillStart", aPkgFile, null);
        String cpuToken = null;
        List<TransportType> transports = TransportUtil.getTransportTypes(this.service);
        this.resetLogging();
        vpr.resetVerifyCount();
        Map<String, Object> userInfo = new HashMap<String, Object>();
        try {
            aPkg = Upload.itmsPackageForPackageFile(aPkgFile, "uploaded");
            if (aPkg == null) {
                return Upload.packageFailed(aPkgFile.getPath(), true, false);
            }
            vpr.logVerifyProgress("Analyzing metadata");
            vpr.incrementVerifyCountBy(2);
            boolean wasAuthenticateSuccessful = this.validateMetadata(aPkg, cpuToken, userInfo);
            if (!wasAuthenticateSuccessful) {
                vpr.logVerifyProgress("Operation failed");
                return Upload.packageFailed(aPkgFile.getPath(), true, false);
            }
            Map returnValue = (Map)userInfo.get(AuthenticateReturnValueUserInfoKey);
            Collection<Map<String, Object>> assetDescriptions = Upload.describeAssets(aPkg, returnValue);
            descriptions = new AssetDescriptions(assetDescriptions);
        }
        catch (Throwable t) {
            Logger.error("Error while processing package " + aPkgFile.getName(), t);
            vpr.logVerifyProgress("Operation failed");
            return Upload.packageFailed(aPkgFile.getPath(), true, false);
        }
        boolean shouldPerformDiagnostic = false;
        for (TransportType transport : transports) {
            if (!transport.canPerformDiagnostic()) continue;
            shouldPerformDiagnostic = true;
            break;
        }
        Map<String, Object> diagnosticResponse = null;
        boolean webServiceDiagnostic = false;
        if (shouldPerformDiagnostic) {
            try {
                this.service.shouldComputeNextRequestChecksum(true);
                final NetworkStatusReporter netstat = new NetworkStatusReporter("Retrieving transport diagnostic information.");
                diagnosticResponse = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                    @Override
                    public void setNetworkIsReachable(boolean isReachable) {
                        netstat.logReachability(isReachable);
                    }

                    @Override
                    public Map<String, Object> invoke() {
                        return Upload.this.service.lookupTransportDiagnostic();
                    }
                });
                this.service.shouldComputeNextRequestChecksum(false);
                if (diagnosticResponse == null) {
                    Application.logUnnecessaryError("Unable to get diagnostic info.");
                }
                if (Application.doesContainSOAPError(diagnosticResponse)) {
                    Application.logUnnecessaryError("An error occurred while getting diagnostic info.");
                    Application.displaySOAPErrorMessages(diagnosticResponse);
                }
                webServiceDiagnostic = true;
            }
            catch (Throwable t) {
                Logger.error("Error occurred while getting diagnostic info.", t);
            }
            finally {
                this.service.shouldComputeNextRequestChecksum(false);
            }
        }
        boolean allFailedDiagnostic = true;
        for (TransportType transport : transports) {
            Map authReturnValue;
            boolean diagnosticSuccess;
            if (transport.canPerformDiagnostic() && !(diagnosticSuccess = this.performDiagnosticForTransport(diagnosticResponse, webServiceDiagnostic, transport))) continue;
            allFailedDiagnostic = false;
            vpr.logVerifyProgress("Validating assets");
            GenericApplicationOperationReturnValue gaoReturnValue = this.validateAssets(aPkgFile, aPkg, cpuToken, transport, userInfo, descriptions);
            if (!gaoReturnValue.wasOperationSuccessful()) {
                if (this.shouldRetryWithNextTransport(gaoReturnValue)) {
                    vpr.decrementStepCountBy(1);
                    continue;
                }
                vpr.logVerifyProgress("Operation failed");
                return Upload.packageFailed(aPkgFile.getPath(), true, false);
            }
            Boolean isDirectImport = (Boolean)userInfo.get(IsDirectImportUserInfoKey);
            if (isDirectImport != null && isDirectImport.booleanValue()) {
                Logger.info("The package: " + aPkgFile.getPath() + " has been successfully uploaded.");
                vpr.logVerifyProgress("Operation completed");
                return Upload.packageSucceeded(aPkgFile.getPath(), 0L, 0L, true);
            }
            if (cpuToken == null) {
                cpuToken = gaoReturnValue.getToken();
            }
            if (!this.postAuthenticatePackageValidation(authReturnValue = (Map)userInfo.get(AuthenticateReturnValueUserInfoKey), aPkg)) {
                if (this.shouldRetryWithNextTransport(gaoReturnValue)) {
                    vpr.decrementStepCountBy(2);
                    continue;
                }
                return Upload.packageFailed(aPkgFile.getPath(), true, false);
            }
            String newPkgName = (String)userInfo.get(NewPackageNameUserInfoKey);
            String transportLogFileName = null;
            long transferTime = 0L;
            Collection checksumInfo = null;
            long totalSize = 0L;
            Map fileSizeInfo = aPkg.fileSizeInfo();
            if (fileSizeInfo != null) {
                for (Map.Entry<String, Long> fileInfo : fileSizeInfo.entrySet()) {
                    totalSize += fileInfo.getValue().longValue();
                }
            }
            TransportByPodPolicy policy = new TransportByPodPolicy(this.service, transport, authReturnValue);
            boolean shouldContinueTryingTransports = true;
            while (policy.hasMoreTransportPods() && shouldContinueTryingTransports) {
                gaoReturnValue = this.performUploadRequestForPackageFile(aPkgFile, aPkg, cpuToken, policy, userInfo, totalSize, policy.hasMoreTransportPods());
                if (cpuToken == null) {
                    cpuToken = gaoReturnValue.getToken();
                }
                boolean wasSuccessful = gaoReturnValue.wasOperationSuccessful();
                userInfo = gaoReturnValue.userInfo();
                String remoteFolderPath = null;
                Long bytesTransferred = null;
                if (userInfo != null) {
                    transportLogFileName = (String)userInfo.get(TransportLogFileNameUserInfoKey);
                    remoteFolderPath = (String)userInfo.get(RemoteFolderPathUserInfoKey);
                    if (userInfo.get(TransferTimeUserInfoKey) != null) {
                        transferTime = (Long)userInfo.get(TransferTimeUserInfoKey);
                    }
                    checksumInfo = (Collection)userInfo.get(ChecksumInfoUserInfoKey);
                    fileSizeInfo = (Map)userInfo.get(FileSizeInfoUserInfoKey);
                }
                if ((bytesTransferred = UploadProgressReporter.totalLastLoggedBytesTransferedForAllFiles()) == null) {
                    bytesTransferred = 0L;
                }
                try {
                    if (wasSuccessful) {
                        Logger.extreme("Throughput information for " + aPkgFile.getName() + ": " + ThroughputUtil.getDurationMillisAsString(transferTime) + ", " + ThroughputUtil.getBytesAsString(bytesTransferred) + ", " + ThroughputUtil.getThroughputPerSecondString(transferTime, bytesTransferred) + "\n");
                    }
                }
                catch (RuntimeException re) {
                    Logger.error("An error occurred while calculating the throughput of the package " + aPkgFile.getName(), re);
                }
                try {
                    if (wasSuccessful) {
                        if (aPkg.metadataFileHasChanged()) {
                            Logger.error("The metadata for package " + aPkgFile.getName() + " has changed. Please retry the upload.");
                            wasSuccessful = false;
                        } else if (!this.performUploadDoneOperation(aPkgFile.getName(), newPkgName, remoteFolderPath, transferTime, bytesTransferred, transportLogFileName, checksumInfo, fileSizeInfo, cpuToken, transport)) {
                            wasSuccessful = false;
                        }
                    }
                }
                catch (RuntimeException re) {
                    Logger.error("An error occurred while calling uploadDone the package named " + aPkgFile.getName(), re);
                    wasSuccessful = false;
                }
                if (wasSuccessful) {
                    this.resetLogging();
                    Logger.info("The package: " + aPkgFile.getPath() + " has been successfully uploaded.");
                    vpr.logVerifyProgress("Operation completed");
                    return Upload.packageSucceeded(aPkgFile.getPath(), transferTime, bytesTransferred, true);
                }
                shouldContinueTryingTransports = this.shouldFailoverToNextPod(totalSize, gaoReturnValue.getTotalUploadedBytes());
                if (policy.hasMoreTransportPods() && shouldContinueTryingTransports) {
                    Upload.packageFailed(aPkgFile.getPath(), true, true);
                }
                policy.next();
            }
            this.performUploadFailedOperationForUpload(newPkgName, transportLogFileName, transferTime, checksumInfo, cpuToken, transport);
            this.resetLogging();
            if (shouldContinueTryingTransports && this.shouldRetryWithNextTransport(gaoReturnValue)) continue;
            break;
        }
        if (allFailedDiagnostic) {
            Logger.error("Could not start delivery: all transports failed diagnostics");
        }
        return Upload.packageFailed(aPkgFile.getPath(), true, false);
    }

    private boolean performDiagnosticForTransport(Map<String, Object> diagnosticResponse, boolean webServiceDiagnostic, TransportType transport) {
        boolean diagnosticSuccess = false;
        boolean atLeastOneDiagnosticAttempted = false;
        if (webServiceDiagnostic) {
            TransportByPodPolicy diagnosticPolicy = new TransportByPodPolicy(this.service, transport, diagnosticResponse);
            while (diagnosticPolicy.hasMoreTransportPods()) {
                if (diagnosticPolicy.canPerformDiagnostic()) {
                    atLeastOneDiagnosticAttempted = true;
                    if (diagnosticPolicy.performDiagnostic(false)) {
                        diagnosticSuccess = true;
                        break;
                    }
                }
                diagnosticPolicy.next();
            }
        }
        if (!atLeastOneDiagnosticAttempted) {
            diagnosticSuccess = TransportUtil.performUnauthenticatedDiagnostic(transport, false);
        }
        return diagnosticSuccess;
    }

    private boolean shouldFailoverToNextPod(long totalSize, long totalUploaded) {
        long percentUploaded = totalUploaded * 100L / totalSize;
        return totalUploaded < this.sizeFailoverThreshold() && percentUploaded < this.percentFailoverThreshold();
    }

    private long percentFailoverThreshold() {
        return Long.getLong("percentFailoverThreshold", 50L);
    }

    private long sizeFailoverThreshold() {
        String sizeSpec = System.getProperty("sizeFailoverThreshold", "100m");
        return TransportUtil.sizeSpecToLong(sizeSpec);
    }

    private void resetLogging() {
        Logger.clearLogCache();
        try {
            Logger.appendToLogCache("Transporter's command line arguments are: " + Application.commandLineArgsAsString());
        }
        catch (RuntimeException re) {
            Logger.appendToLogCache("An error occurred while logging the transporter's command line arguments.");
        }
    }

    private boolean shouldRetryWithNextTransport(GenericApplicationOperationReturnValue gaoReturnValue) {
        Boolean explicitTransportFailoverRequested;
        if (gaoReturnValue != null && gaoReturnValue.userInfo() != null && gaoReturnValue.userInfo().get(AuthenticateReturnValueUserInfoKey) != null && (explicitTransportFailoverRequested = (Boolean)((Map)gaoReturnValue.userInfo().get(AuthenticateReturnValueUserInfoKey)).get("FailoverRequested")) != null && explicitTransportFailoverRequested.booleanValue()) {
            return true;
        }
        TransportReturnValue trv = null;
        if (gaoReturnValue != null && gaoReturnValue.userInfo() != null) {
            trv = (TransportReturnValue)gaoReturnValue.userInfo().get(TransportReturnValueUserInfoKey);
        }
        return trv != null && !trv.wasTransferSuccessful();
    }

    private GenericApplicationOperationReturnValue validateAssets(File aPkgFile, ITMSPackage aPkg, String cpuToken, TransportType transportType, Map<String, Object> userInfo, AssetDescriptions descriptions) {
        try {
            GenericApplicationOperationReturnValue authGAOReturnValue = this.performAuthenticateOperationForUpload(aPkg, cpuToken, transportType, userInfo, descriptions);
            Map authReturnValue = new HashMap();
            if (authGAOReturnValue != null && authGAOReturnValue.userInfo() != null) {
                authReturnValue = (Map)authGAOReturnValue.userInfo().get(AuthenticateReturnValueUserInfoKey);
            }
            if (authReturnValue == null) {
                return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken);
            }
            if (!authGAOReturnValue.wasOperationSuccessful()) {
                return authGAOReturnValue;
            }
            if (cpuToken == null) {
                cpuToken = authGAOReturnValue.getToken();
            }
            String newPkgName = TransportUtil.newPackageNameFromAuthenticateReturnValue(authReturnValue);
            userInfo.put(NewPackageNameUserInfoKey, newPkgName);
            boolean wasAuthSuccessful = authGAOReturnValue.wasOperationSuccessful();
            Boolean wasDirectImport = (Boolean)authReturnValue.get(System.getProperty("DirectImportKey"));
            if (wasDirectImport == null) {
                wasDirectImport = Boolean.FALSE;
            }
            userInfo.put(IsDirectImportUserInfoKey, wasDirectImport);
            if (wasDirectImport.booleanValue()) {
                if (wasAuthSuccessful) {
                    Logger.info("A direct import of the package " + aPkgFile.getName() + " was performed.  Transporter is done processing the package.");
                    return new GenericApplicationOperationReturnValue(true, userInfo, cpuToken);
                }
                Logger.info("An error occurred during the direct import of the package " + aPkgFile.getName() + ".");
                return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken);
            }
            if (!wasAuthSuccessful) {
                return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken);
            }
            return authGAOReturnValue;
        }
        catch (Throwable t) {
            Logger.error("Error while processing package " + aPkgFile.getName(), t);
            return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericApplicationOperationReturnValue performUploadRequestForPackageFile(File aPkgFile, ITMSPackage aPkg, String cpuToken, TransportSelectionPolicy policy, Map<String, Object> userInfo, long totalSize, boolean willRetry) {
        long totalUploaded = 0L;
        try {
            Integer maxNumOfUploadRetries = new Integer(System.getProperty("numberOfRetries"));
            int numOfUploadAttempts = 0;
            Map authReturnValue = (Map)userInfo.get(AuthenticateReturnValueUserInfoKey);
            boolean retry = false;
            boolean wasUploadSuccessful = false;
            Long totalTransferTime = null;
            String transportLogFileName = null;
            do {
                block25: {
                    wasUploadSuccessful = false;
                    if (numOfUploadAttempts > 0) {
                        TransportUtil.needToSleep(Application.sleepDuration(), "Trying connection to server again - try #" + (numOfUploadAttempts + 1));
                    }
                    ++numOfUploadAttempts;
                    userInfo.put(ChecksumInfoUserInfoKey, aPkg.checksumInfo());
                    userInfo.put(FileSizeInfoUserInfoKey, aPkg.fileSizeInfo());
                    String folderPath = TransportUtil.folderPathFromAuthenticateReturnValue(authReturnValue, policy.getTransportType());
                    userInfo.put(RemoteFolderPathUserInfoKey, folderPath);
                    TransportReturnValue transportReturnValue = null;
                    try {
                        Long loggedBytes;
                        transportReturnValue = this.performUploadOperation(authReturnValue, aPkg, retry, cpuToken, policy, willRetry && numOfUploadAttempts < maxNumOfUploadRetries);
                        boolean didPerformUploadOperation = false;
                        if (transportReturnValue != null) {
                            didPerformUploadOperation = transportReturnValue.wasTransferSuccessful();
                        }
                        if ((loggedBytes = UploadProgressReporter.totalBytesOnServerForAllFiles()) != null) {
                            totalUploaded = loggedBytes;
                        }
                        wasUploadSuccessful = didPerformUploadOperation;
                        retry = false;
                        if (!wasUploadSuccessful && !this.shouldFailoverToNextPod(totalSize, totalUploaded)) {
                            if (numOfUploadAttempts < maxNumOfUploadRetries) {
                                Logger.extreme("Triggering a retry because the amount uploaded is above the failover threshold.");
                                retry = true;
                            } else {
                                Logger.error("The max number of retries was performed. The package will not be uploaded.");
                            }
                        }
                        if (transportReturnValue == null) break block25;
                        userInfo.put(TransportReturnValueUserInfoKey, transportReturnValue);
                    }
                    catch (ServerConnectionException t) {
                        block26: {
                            try {
                                if (t.transportObject() != null) {
                                    transportReturnValue = new TransportReturnValue(false, false, t.transportObject());
                                }
                                if (numOfUploadAttempts < maxNumOfUploadRetries) {
                                    Logger.extreme("Triggering a retry for the following reason: " + t);
                                    retry = true;
                                } else {
                                    Logger.error("The max number of retries was performed. The package will not be uploaded.");
                                    wasUploadSuccessful = false;
                                    retry = false;
                                }
                                if (transportReturnValue == null) break block26;
                                userInfo.put(TransportReturnValueUserInfoKey, transportReturnValue);
                            }
                            catch (Throwable throwable) {
                                if (transportReturnValue != null) {
                                    userInfo.put(TransportReturnValueUserInfoKey, transportReturnValue);
                                    if (transportReturnValue.transportObject() != null) {
                                        transportLogFileName = transportReturnValue.transportObject().transportLogFileName();
                                        Long milliseconds = transportReturnValue.transportObject().transferTimeInMilliseconds();
                                        totalTransferTime = TransportUtil.addLongValues(milliseconds, totalTransferTime);
                                    }
                                }
                                if (transportLogFileName != null) {
                                    userInfo.put(TransportLogFileNameUserInfoKey, transportLogFileName);
                                }
                                userInfo.put(TransferTimeUserInfoKey, totalTransferTime);
                                if (totalTransferTime != null) {
                                    Logger.extreme("The transfer time for the package " + aPkgFile.getName() + " was " + totalTransferTime + " milliseconds.");
                                }
                                throw throwable;
                            }
                            if (transportReturnValue.transportObject() != null) {
                                transportLogFileName = transportReturnValue.transportObject().transportLogFileName();
                                Long milliseconds = transportReturnValue.transportObject().transferTimeInMilliseconds();
                                totalTransferTime = TransportUtil.addLongValues(milliseconds, totalTransferTime);
                            }
                        }
                        if (transportLogFileName != null) {
                            userInfo.put(TransportLogFileNameUserInfoKey, transportLogFileName);
                        }
                        userInfo.put(TransferTimeUserInfoKey, totalTransferTime);
                        if (totalTransferTime == null) continue;
                        Logger.extreme("The transfer time for the package " + aPkgFile.getName() + " was " + totalTransferTime + " milliseconds.");
                    }
                    if (transportReturnValue.transportObject() != null) {
                        transportLogFileName = transportReturnValue.transportObject().transportLogFileName();
                        Long milliseconds = transportReturnValue.transportObject().transferTimeInMilliseconds();
                        totalTransferTime = TransportUtil.addLongValues(milliseconds, totalTransferTime);
                    }
                }
                if (transportLogFileName != null) {
                    userInfo.put(TransportLogFileNameUserInfoKey, transportLogFileName);
                }
                userInfo.put(TransferTimeUserInfoKey, totalTransferTime);
                if (totalTransferTime == null) continue;
                Logger.extreme("The transfer time for the package " + aPkgFile.getName() + " was " + totalTransferTime + " milliseconds.");
            } while (retry);
            if (!wasUploadSuccessful) {
                return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken, totalUploaded);
            }
        }
        catch (Throwable t) {
            Logger.error("Error while processing package " + aPkgFile.getName(), t);
            return new GenericApplicationOperationReturnValue(false, userInfo, cpuToken, totalUploaded);
        }
        return new GenericApplicationOperationReturnValue(true, userInfo, cpuToken, totalUploaded);
    }

    private boolean validateMetadata(final ITMSPackage aPkg, String cpuToken, Map<String, Object> userInfo) throws ConcurrentTransportException {
        Logger.info("Performing authentication of package " + aPkg.packageName() + " ...");
        System.setProperty("providerNameFromApple", "");
        final NetworkStatusReporter netstat = new NetworkStatusReporter("Analyzing metadata", vpr);
        Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
                netstat.logReachability(isReachable);
            }

            @Override
            public Map invoke() {
                return Upload.this.service.authenticateOperation(aPkg, Application.shouldHidePassword(), null);
            }
        });
        boolean wasAuthenticateSuccessful = Upload.validateAuthenticateOperationResponse(aPkg, userInfo, returnValue);
        if (wasAuthenticateSuccessful && returnValue != null) {
            wasAuthenticateSuccessful = Upload.setFilesRequestedByApple(aPkg, returnValue, wasAuthenticateSuccessful);
        }
        return wasAuthenticateSuccessful;
    }

    private GenericApplicationOperationReturnValue performAuthenticateOperationForUpload(final ITMSPackage aPkg, String cpuToken, final TransportType transportType, Map<String, Object> userInfo, final AssetDescriptions descriptions) {
        boolean wasAuthenticateSuccessful = true;
        Map returnValue = null;
        try {
            returnValue = (Map)userInfo.get(AuthenticateReturnValueUserInfoKey);
            final String token = Upload.getCPUToken(aPkg, returnValue, cpuToken);
            final NetworkStatusReporter netstat = new NetworkStatusReporter("Validating assets", vpr);
            returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                    netstat.logReachability(isReachable);
                }

                @Override
                public Map invoke() {
                    return Upload.this.service.authenticateOperation(aPkg, Application.shouldHidePassword(), descriptions, token, transportType);
                }
            });
            wasAuthenticateSuccessful = Upload.validateAuthenticateOperationResponse(aPkg, userInfo, returnValue);
            if (wasAuthenticateSuccessful) {
                Upload.setCPUToken(aPkg, returnValue);
            }
            if (returnValue != null) {
                cpuToken = (String)returnValue.get("CPUToken");
            }
            if (cpuToken == null) {
                cpuToken = token;
            }
        }
        catch (ConcurrentTransportException e) {
            Logger.error("Cannot proceed with delivery: an existing transporter instance is currently uploading this package");
            wasAuthenticateSuccessful = false;
        }
        Boolean wasDirectImportBool = false;
        if (returnValue != null) {
            wasDirectImportBool = (Boolean)returnValue.get(System.getProperty("DirectImportKey"));
        }
        boolean wasDirectImport = false;
        if (wasDirectImportBool != null) {
            wasDirectImport = wasDirectImportBool;
        }
        if (returnValue != null && wasAuthenticateSuccessful && !wasDirectImport) {
            wasAuthenticateSuccessful = Upload.setFilesRequestedByApple(aPkg, returnValue, wasAuthenticateSuccessful);
        }
        if (wasAuthenticateSuccessful) {
            Upload.setNewPackageName(aPkg, returnValue);
        }
        Logger.info("Done performing authentication.");
        return new GenericApplicationOperationReturnValue(wasAuthenticateSuccessful, userInfo, cpuToken);
    }

    private static boolean setFilesRequestedByApple(ITMSPackage aPkg, Map returnValue, boolean wasAuthenticateSuccessful) {
        boolean successfullySetRequestedFiles;
        Object[] filesToUploadArray = (Object[])returnValue.get(System.getProperty("filesToUploadKey"));
        ArrayList<String> filesToUpload = null;
        if (filesToUploadArray != null) {
            filesToUpload = new ArrayList<String>();
            for (Object file : filesToUploadArray) {
                filesToUpload.add((String)file);
            }
        }
        if (!(successfullySetRequestedFiles = aPkg.setFilesRequestedByApple(filesToUpload))) {
            wasAuthenticateSuccessful = false;
        }
        return wasAuthenticateSuccessful;
    }

    private static void setNewPackageName(ITMSPackage aPkg, Map returnValue) {
        String newPackageName = (String)returnValue.get(System.getProperty("newPackageNameKey"));
        if (newPackageName != null && newPackageName.length() > 0) {
            aPkg.setNewPackageName(newPackageName);
        }
    }

    private static String getCPUToken(ITMSPackage aPkg, Map returnValue, String reuseToken) throws ConcurrentTransportException {
        String providerName = Upload.getTokenProviderName(returnValue);
        String newToken = Upload.getTokenFromResponse(returnValue);
        if (newToken == null) {
            newToken = reuseToken;
        }
        String token = null;
        if (providerName != null && providerName.trim().length() > 0) {
            token = UploadTokenManager.instance().testAndSetToken(providerName, aPkg.packageName(), newToken);
        }
        return token;
    }

    private static String getTokenProviderName(Map returnValue) {
        String providerName = System.getProperty("s");
        if (providerName == null || providerName.trim().length() == 0) {
            providerName = System.getProperty("providerNameFromApple");
        }
        if ((providerName == null || providerName.trim().length() == 0) && (providerName = (String)returnValue.get(System.getProperty("providerNameForTokenKey"))) != null) {
            System.setProperty("providerNameFromApple", providerName);
        }
        return providerName;
    }

    private static void setCPUToken(ITMSPackage aPkg, Map returnValue) {
        String newToken = Upload.getTokenFromResponse(returnValue);
        String providerName = Upload.getTokenProviderName(returnValue);
        if (newToken != null) {
            UploadTokenManager.instance().setToken(providerName, aPkg.packageName(), newToken);
        } else {
            UploadTokenManager.instance().deleteToken(providerName, aPkg.packageName());
        }
    }

    private static String getTokenFromResponse(Map returnValue) {
        return (String)returnValue.get(System.getProperty("cpuTokenKey"));
    }

    private static boolean validateAuthenticateOperationResponse(ITMSPackage aPkg, Map<String, Object> userInfo, Map returnValue) {
        boolean wasAuthenticateSuccessful = true;
        if (returnValue == null || returnValue.isEmpty()) {
            Application.logUnnecessaryError("Unable to authenticate the package: " + aPkg.packageName());
            wasAuthenticateSuccessful = false;
        } else {
            userInfo.put(AuthenticateReturnValueUserInfoKey, returnValue);
        }
        if (returnValue != null && Application.doesContainSOAPError(returnValue)) {
            Application.logUnnecessaryError("Unable to authenticate the package: " + aPkg.packageName());
            Application.displaySOAPErrorMessages(returnValue);
            wasAuthenticateSuccessful = false;
        }
        if (returnValue != null && wasAuthenticateSuccessful) {
            Boolean disableMetadataCaseCheck = (Boolean)returnValue.get(System.getProperty("DisableMetadataCaseCheckKey"));
            if (disableMetadataCaseCheck != null && disableMetadataCaseCheck.booleanValue()) {
                Logger.debug("Disabling metadata.xml case sensitivity check.");
                System.setProperty("DisableMetadataCaseCheck", "true");
            } else {
                System.setProperty("DisableMetadataCaseCheck", "false");
            }
        }
        return wasAuthenticateSuccessful;
    }

    private TransportReturnValue performUploadOperation(Map<String, ?> authenticateReturnValue, ITMSPackage aPkg, boolean isRetry, String cpuToken, TransportSelectionPolicy policy, boolean willRetry) throws ServerConnectionException {
        Logger.info("Preparing to upload package " + aPkg.packageName() + " ...");
        TransportReturnValue transportReturnValue = null;
        TransportInterface aTransport = null;
        try {
            Application.getStatisticCollector().startOperationReturningPreviousStatistic("createTransportPod");
            aTransport = policy.createTransportPod(aPkg, cpuToken, isRetry);
            if (aTransport == null) {
                Logger.error("Could NOT upload the package " + aPkg.packageName());
                TransportReturnValue transportReturnValue2 = null;
                return transportReturnValue2;
            }
            String uploadTransport = "upload-" + aTransport.getClass().getSimpleName();
            Application.getStatisticCollector().startOperationReturningPreviousStatistic(uploadTransport);
            transportReturnValue = aTransport.uploadPackage(this.service, willRetry);
            if (transportReturnValue == null) {
                Logger.error("The transport's return value is unknown.  It will be treated like a failed upload.");
                transportReturnValue = new TransportReturnValue(false, false, aTransport);
            }
        }
        catch (ServerConnectionException asce) {
            if (asce.transportObject() == null) {
                asce.setTransportObject(aTransport);
            }
            throw asce;
        }
        finally {
            if (aTransport != null) {
                aTransport.releaseResourcesPriorToFinalization();
            }
        }
        if (transportReturnValue.wasTransferSuccessful()) {
            Logger.info("Done performing upload.");
        } else {
            aPkg.reset();
        }
        return transportReturnValue;
    }

    private boolean performUploadDoneOperation(final String packageName, final String newPkgName, final String folderPath, final Long transferTime, Long bytesTransferred, String transportLogFileName, Collection checksumInfo, Map fileSizeInfo, String cpuToken, TransportType transportType) {
        TransportLog extraTransportLog;
        TransportLog transportLog;
        if (packageName == null || packageName.length() == 0) {
            Logger.error("Cannot call uploadDone because the package name input value is missing.");
            return false;
        }
        if (newPkgName == null || newPkgName.length() == 0) {
            Logger.error("Cannot call uploadDone because the new package name input value is missing.");
            return false;
        }
        if (folderPath == null || folderPath.length() == 0) {
            Logger.error("Cannot call uploadDone because the folder path input value is missing.");
            return false;
        }
        String message = "Performing uploadDone notification to Apple for package " + packageName + " ...";
        final NetworkStatusReporter netstat = new NetworkStatusReporter(message);
        Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(transportLog = Logger.logCache(), extraTransportLog = TransportLog.extraTransportLog(FileUtil.fileContentsForWebService(transportLogFileName)), bytesTransferred, checksumInfo, fileSizeInfo, cpuToken, transportType){
            final /* synthetic */ TransportLog val$transportLog;
            final /* synthetic */ TransportLog val$extraTransportLog;
            final /* synthetic */ Long val$bytesTransferred;
            final /* synthetic */ Collection val$checksumInfo;
            final /* synthetic */ Map val$fileSizeInfo;
            final /* synthetic */ String val$cpuToken;
            final /* synthetic */ TransportType val$transportType;
            {
                this.val$transportLog = transportLog;
                this.val$extraTransportLog = transportLog2;
                this.val$bytesTransferred = l2;
                this.val$checksumInfo = collection;
                this.val$fileSizeInfo = map;
                this.val$cpuToken = string4;
                this.val$transportType = transportType;
            }

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
                netstat.logReachability(isReachable);
            }

            @Override
            public Map invoke() {
                return Upload.this.service.uploadDoneOperation(packageName, newPkgName, folderPath, Application.shouldHidePassword(), transferTime, this.val$transportLog, this.val$extraTransportLog, this.val$bytesTransferred, this.val$checksumInfo, this.val$fileSizeInfo, this.val$cpuToken, this.val$transportType);
            }
        });
        if (returnValue == null) {
            Application.logUnnecessaryError("The upload process was NOT completed for the package " + packageName);
            return false;
        }
        if (returnValue != null && Application.doesContainSOAPError(returnValue)) {
            Application.displaySOAPErrorMessages(returnValue);
            Application.logUnnecessaryError("The upload process CANNOT be completed for the package " + packageName);
            return false;
        }
        UploadTokenManager.instance().deleteToken(Upload.getTokenProviderName(returnValue), packageName);
        Logger.info("Done performing uploadDone notification to Apple.");
        return true;
    }

    private boolean performUploadFailedOperationForUpload(final String newPkgName, String transportLogFileName, final Long transferTime, final Collection checksumInfo, final String cpuToken, final TransportType transportType) {
        if (newPkgName == null || newPkgName.length() == 0) {
            return false;
        }
        try {
            final TransportLog transportLog = Logger.logCache();
            final TransportLog extraTransportLog = TransportLog.extraTransportLog(FileUtil.fileContentsForWebService(transportLogFileName));
            final NetworkStatusReporter netstat = new NetworkStatusReporter("Sending the upload failure information to Apple ...");
            Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                    netstat.logReachability(isReachable);
                }

                @Override
                public Map invoke() {
                    return Upload.this.service.uploadFailed(Application.shouldHidePassword(), newPkgName, transportLog, extraTransportLog, transferTime, UploadProgressReporter.totalLastLoggedBytesTransferedForAllFiles(), checksumInfo, cpuToken, transportType);
                }
            });
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while while sending the upload failure information to Apple.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            if (returnValue == null) {
                Application.logUnnecessaryError("An error occurred while while sending the upload failure information to Apple.");
                return false;
            }
        }
        catch (Throwable t) {
            Logger.error("Error occurred while sending the upload failure information to Apple.", t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performTransferTestRequest() {
        ArrayList<PackageResult> packageResults = new ArrayList<PackageResult>();
        Logger.startCachingLogMessages();
        File packagePath = new File(TransferTestITMSPackage.generatePackagePath());
        boolean success = false;
        Logger.startLogFileForPackage(packagePath);
        try {
            PackageResult result = this.performUploadRequest(packagePath);
            packageResults.add(result);
            success = result.getStatus() == PackageResult.Status.Success;
        }
        finally {
            Logger.cleanupLogFileForPackage(success);
        }
        Logger.stopCachingLogMessages();
        Logger.clearLogCache();
        Application.displayWarningMessages();
        Application.displayInfoMessages();
        if (Application.shouldGenerateXML()) {
            Upload.showPackageOperationResultsXML(packageResults);
        } else {
            Upload.showPackageOperationResults(packageResults, "uploaded");
        }
        return success && !Upload.hasFailedOrIgnoredPackages(packageResults);
    }

    @Override
    protected boolean performRequest(String packagePath) {
        Logger.info("Upload mode selected.");
        String aDir = System.getProperty("success");
        if (aDir != null) {
            PackageMover.setupToMovePackagesThatSucceeded(aDir);
        }
        if ((aDir = System.getProperty("failure")) != null) {
            PackageMover.setupToMovePackagesThatFailed(aDir);
        }
        if (Application.shouldDeleteSuccessfulPackages()) {
            PackageMover.setupToDeletePackagesThatSucceeded();
        }
        return this.performUploadRequest(packagePath);
    }

    @Override
    protected void addModeSpecificOptions(Options options) {
        options.addOption((Option)new TransportOption(TransportOption.Variant.Upload));
        options.addOption((Option)new ThrottleOption());
        options.addOption((Option)new ThroughputOption());
        options.addOption((Option)new AssetReplacementVerificationOption());
        options.addOption((Option)new DeleteFastTransportLogOption());
        options.addOption((Option)new FailureOption());
        options.addOption((Option)new LogHistoryOption());
        options.addOption((Option)new NumStreamsOption());
        OptionGroup successOrDeleteGroup = new OptionGroup();
        successOrDeleteGroup.addOption((Option)new SuccessOption());
        successOrDeleteGroup.addOption((Option)new DeleteOption());
        options.addOptionGroup(successOrDeleteGroup);
    }
}

