/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.UploadProgressReporter;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.Upload;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.ErrorLogDestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.SizeOption;
import com.apple.transporter.operation.option.ThrottleOption;
import com.apple.transporter.operation.option.TransportOption;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.TransportUtil;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class TransferTest
extends Operation {
    public static final String NAME = "transferTest";

    public TransferTest(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Application.setShouldDisplayThroughput(true);
        UploadProgressReporter.sharedInstance().setupToLogUploadProgress();
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForPackages();
        List<TransportType> transports = TransportUtil.getTransportTypes(this.service);
        if (transports.contains((Object)TransportType.Aspera)) {
            Logger.error("transferTest mode is not supported for Aspera transport.");
            return false;
        }
        if (TransportUtil.isOSWindows() && transports.contains((Object)TransportType.Signiant)) {
            Logger.error("transferTest mode is not supported for Signiant under Windows.");
            return false;
        }
        System.setProperty("signiantRetries", "0");
        System.setProperty("signiantRestarts", "0");
        Upload operation = new Upload(this.service);
        return operation.performTransferTestRequest();
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new TransportOption(TransportOption.Variant.Generic));
        options.addOption((Option)new ThrottleOption());
        options.addOption((Option)new SizeOption());
        options.addOption((Option)new OutputFormatOption());
        options.addOption((Option)new ErrorLogDestinationOption());
        if (includeHidden) {
            options.addOption((Option)new BaseOption("relay", true));
        }
        return options;
    }
}

