/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.operation.status.StatusFetcher;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class Status
extends Operation {
    private boolean _statusAll;

    public Status(WebService service) {
        this(service, false);
    }

    public Status(WebService service, boolean statusAll) {
        super(service);
        this._statusAll = statusAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean wasSuccessful;
        block7: {
            boolean isStatusAllRequest = this._statusAll;
            if (isStatusAllRequest) {
                Logger.info("StatusAll mode selected.");
            } else {
                Logger.info("Status mode selected.");
            }
            ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
            wasSuccessful = true;
            StatusFetcher fetcher = null;
            try {
                fetcher = StatusFetcher.createFetcher(isStatusAllRequest, this.service);
                wasSuccessful = fetcher.fetchStatus();
                if (fetcher == null) break block7;
                boolean bl = wasSuccessful = wasSuccessful && fetcher.complete();
            }
            catch (Throwable throwable) {
                if (fetcher != null) {
                    boolean bl = wasSuccessful = wasSuccessful && fetcher.complete();
                }
                if (!wasSuccessful) {
                    Application.showNonPackageBasedErrorSummary();
                }
                throw throwable;
            }
        }
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
        }
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new OutputFormatOption());
        OptionGroup appleIdOrVendorIdPluralGroup = OptionHelper.appleIdOrVendorIdOptionGroup(AppleIdOption.Variant.Status, VendorIdOption.Variant.Status);
        if (includeHidden) {
            VendorIdOption legacyVendorIdOption = new VendorIdOption(VendorIdOption.Variant.VendorIdentifier);
            legacyVendorIdOption.setHidden(true);
            appleIdOrVendorIdPluralGroup.addOption((Option)legacyVendorIdOption);
        }
        options.addOptionGroup(appleIdOrVendorIdPluralGroup);
        return options;
    }
}

