/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.NumericOption;
import com.apple.transporter.operation.option.OptionHelper;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Sleep
extends Operation {
    public Sleep(WebService service) {
        super(service);
    }

    private boolean executeSleep() {
        Logger.info("Performing sleep request ...");
        try {
            Logger.info("Asking Apple's web service to sleep ...");
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return Sleep.this.service.sleepOperation(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to perform the sleep request.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("Unable to perform the sleep request.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            Logger.essential("\n\nSuccessfully performed the sleep operation.");
        }
        catch (Throwable t) {
            Logger.error("Error occurred while performing the sleep operation.", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean wasSuccessful = false;
        Logger.info("Sleep mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        wasSuccessful = this.executeSleep();
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
        }
        return wasSuccessful;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, true, includeHidden);
        options.addOption((Option)new NumericOption("seconds"){});
        return options;
    }
}

