/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.VendorIdOption;
import java.util.Map;
import org.apache.commons.cli.Options;

public class ResetSoftwareApplication
extends Operation {
    public ResetSoftwareApplication(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        boolean wasSuccessful = false;
        Logger.info("ResetSoftwareApplication mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        wasSuccessful = this.performResetSoftwareApplicationRequest();
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
        }
        return wasSuccessful;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOptionGroup(OptionHelper.appleIdOrVendorIdOptionGroup(true, AppleIdOption.Variant.Generic, VendorIdOption.Variant.Generic));
        return options;
    }

    private boolean performResetSoftwareApplicationRequest() {
        Logger.info("Performing resetSoftwareApplication request ...");
        String vendorId = System.getProperty("vendor_id");
        String appleId = System.getProperty("apple_id");
        String searchId = null;
        String searchType = null;
        if (vendorId != null && vendorId.trim().length() > 0) {
            searchId = vendorId;
            searchType = "vendor_id";
        } else {
            searchId = appleId;
            searchType = "apple_id";
        }
        try {
            Logger.info("Resetting the software application with the " + searchType + " '" + searchId + "' ...");
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return ResetSoftwareApplication.this.service.resetSoftwareApplicationOperation(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to reset the software application.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while resetting the software application.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            Logger.essential("\n\nSuccessfully performed the reset software application operation.");
        }
        catch (Throwable t) {
            Logger.error("Error occurred while resetting the software application with " + searchType + " '" + searchId + "'.", t);
            return false;
        }
        return true;
    }
}

