/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class RequestiTunesConnectArtistBinding
extends Operation {
    public static final String MODE_VALUE = "pingArtistRequest";
    protected static final String RETURN_DICT__ARTIST_ACTIVATION_STATUS = "ActivationStatus";
    protected static final String RETURN_DICT__ARTIST_ACTIVATION_REQUESTED_BY = "RequestedBy";
    protected static final String RETURN_DICT__ARTIST_ACTIVATION_EMAIL_TO = "EmailTo";

    public RequestiTunesConnectArtistBinding(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map invoke() {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(FileUtil.absolutePathForPath(System.getProperty("requestXML")));
                    Map map = RequestiTunesConnectArtistBinding.this.service.requestiTunesConnectArtistBinding(IOUtils.toString((InputStream)in));
                    return map;
                }
                catch (IOException e) {
                    Logger.error("Failed to open XML file", e);
                    Map map = null;
                    return map;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        } else {
            String requestTo;
            Logger.essential("\n\nRequest Summary\n");
            Logger.essential("Request status: " + results.get(RETURN_DICT__ARTIST_ACTIVATION_STATUS));
            String requestedBy = (String)results.get(RETURN_DICT__ARTIST_ACTIVATION_REQUESTED_BY);
            if (requestedBy != null) {
                Logger.essential("Requested by  : " + requestedBy);
            }
            if ((requestTo = (String)results.get(RETURN_DICT__ARTIST_ACTIVATION_EMAIL_TO)) != null) {
                Logger.essential("Request email : " + requestTo);
            }
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new ArtistActivationRequestXMLOption());
        return options;
    }

    public static class ArtistActivationRequestXMLOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = -8092491658590421827L;
        public static final String NAME = "requestXML";

        public ArtistActivationRequestXMLOption() throws IllegalArgumentException {
            super(NAME, true, "Specifies a path to the XML file describing the artist activation request. The file must be encoded in UTF-8.");
            this.setRequired(true);
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            try {
                String absolutePath = FileUtil.absolutePathForPath(commandLine.getOptionValue(this.getOpt()));
                File file = new File(absolutePath);
                if (!file.exists() || !file.isFile()) {
                    throw new OptionValidationException(this.getOpt() + " parameter must specify an existing XML file.");
                }
            }
            catch (IOException e) {
                throw new OptionValidationException(e.getMessage());
            }
        }
    }
}

