/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.ReportDateOption;
import com.apple.transporter.operation.option.ReportTypeOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import com.apple.transporter.util.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class RequestReport
extends Operation {
    public static final String MODE_VALUE = "requestReport";

    public RequestReport(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        final String type = System.getProperty("type");
        String localReportDate = System.getProperty("reportDate");
        Date parsedReportDate = null;
        SimpleDateFormat requestDateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
        if (localReportDate != null && !"all".equalsIgnoreCase(localReportDate)) {
            requestDateFormat.setTimeZone(TimeZone.getDefault());
            try {
                parsedReportDate = requestDateFormat.parse(localReportDate);
            }
            catch (ParseException e) {
                Logger.error("Unable to parse request date.", e);
                return false;
            }
        }
        final Object reportDate = parsedReportDate != null ? new Long(parsedReportDate.getTime()) : localReportDate;
        Map<String, Object> results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return RequestReport.this.service.requestReport(type, reportDate);
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            } else {
                Map reportsByType = (Map)results.get(System.getProperty("reportsByTypeKey"));
                String destDirPath = null;
                try {
                    destDirPath = TransportUtil.destinationPathFromProperty();
                }
                catch (Throwable t) {
                    Logger.error("The specified destination path is not valid.", t);
                    return false;
                }
                if (Application.shouldGenerateXML()) {
                    XMLUtil.XMLTag reportsTag = new XMLUtil.XMLTag("reports", 1);
                    if (reportsByType == null || reportsByType.isEmpty()) {
                        Logger.info("There are no available reports from the remote Apple server.");
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm z", Locale.US);
                        dateFormat.setTimeZone(TimeZone.getDefault());
                        for (String reportType : reportsByType.keySet()) {
                            Object[] reportsForType;
                            XMLUtil.XMLTag reportTypeTag = reportsTag.addChildTag("type");
                            reportTypeTag.addAttribute("name", reportType);
                            for (Object reportInfoObj : reportsForType = (Object[])reportsByType.get(reportType)) {
                                String filePath;
                                Map reportInfo = (Map)reportInfoObj;
                                Number gmtDateRequested = (Number)reportInfo.get(System.getProperty("dateRequestedKey"));
                                String requestedBy = (String)reportInfo.get(System.getProperty("requestedByKey"));
                                String status = (String)reportInfo.get(System.getProperty("reportStatusKey"));
                                String downloadUrl = (String)reportInfo.get(System.getProperty("downloadUrlKey"));
                                Map reportFile = (Map)reportInfo.get(System.getProperty("reportFileKey"));
                                String responseMessage = (String)reportInfo.get(System.getProperty("responseMessageKey"));
                                String localDateRequested = dateFormat.format(new Date(gmtDateRequested.longValue()));
                                XMLUtil.XMLTag reportTag = reportTypeTag.addChildTag("report");
                                reportTag.addAttribute("dateRequested", localDateRequested);
                                reportTag.addAttribute("requestedBy", requestedBy);
                                reportTag.addAttribute("status", status);
                                if (reportFile != null) {
                                    filePath = this.extractReportToFile(destDirPath, reportFile);
                                    if (filePath == null) continue;
                                    reportTag.addAttribute("downloadedFile", filePath);
                                    continue;
                                }
                                if (downloadUrl != null) {
                                    filePath = this.downloadReportToFile(destDirPath, downloadUrl);
                                    if (filePath == null) continue;
                                    reportTag.addAttribute("downloadedFile", filePath);
                                    continue;
                                }
                                reportTag.addAttribute("message", responseMessage);
                            }
                        }
                    }
                    Application.XMLStream.print(reportsTag.marshall());
                } else {
                    Logger.essential(" ");
                    if (reportsByType == null || reportsByType.isEmpty()) {
                        Logger.essential("There are no available reports from the remote Apple server.");
                        return true;
                    }
                    for (String reportType : reportsByType.keySet()) {
                        Object[] reportsForType;
                        for (Object reportInfoObj : reportsForType = (Object[])reportsByType.get(reportType)) {
                            String filePath;
                            Map reportInfo = (Map)reportInfoObj;
                            String downloadUrl = (String)reportInfo.get(System.getProperty("downloadUrlKey"));
                            Map reportFile = (Map)reportInfo.get(System.getProperty("reportFileKey"));
                            String responseMessage = (String)reportInfo.get(System.getProperty("responseMessageKey"));
                            if (reportFile != null) {
                                filePath = this.extractReportToFile(destDirPath, reportFile);
                                if (filePath == null) continue;
                                Logger.essential("Report download success: " + filePath);
                                continue;
                            }
                            if (downloadUrl != null) {
                                filePath = this.downloadReportToFile(destDirPath, downloadUrl);
                                if (filePath == null) continue;
                                Logger.essential("Report download success: " + filePath);
                                continue;
                            }
                            Logger.essential(responseMessage);
                        }
                    }
                }
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractReportToFile(String destDirPath, Map<String, String> reportFile) {
        String reportName = reportFile.get(System.getProperty("fileNameKey"));
        String destDirPathPlusReportName = NSPathUtilities.stringByAppendingPathComponent(destDirPath, reportName);
        File reportDestination = new File(destDirPathPlusReportName);
        String expectedChecksum = reportFile.get(System.getProperty("checksummedBlobChecksumKey"));
        String gzipContent = reportFile.get(System.getProperty("checksummedBlobGzipContentKey"));
        if (reportDestination.exists()) {
            Logger.info("The report " + reportName + " already exists in " + destDirPath + ".  It will be deleted before downloading the new one.");
            if (!reportDestination.delete()) {
                Logger.error("An error occurred deleting the report " + reportDestination.getPath());
            }
        }
        try {
            try (FileOutputStream reportFileOut = new FileOutputStream(reportDestination);){
                if (!StreamUtil.base64GzipToStream(gzipContent, reportFileOut)) {
                    Logger.error("An error occurred while saving the report named " + reportName);
                    String string = null;
                    return string;
                }
            }
            byte[] hash = FileUtil.md5(reportDestination);
            String actualChecksum = StringUtil.byteArrayToHexString(hash);
            if (actualChecksum.equalsIgnoreCase(expectedChecksum)) return reportDestination.getAbsolutePath();
            Logger.error("Checksum of report returned by Apple's web service operation does not match expected checksum.");
            reportDestination.delete();
            return null;
        }
        catch (FileNotFoundException fnf) {
            Logger.error("An error occurred while saving the report named " + reportName, fnf);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("An error occurred while saving the report named " + reportName, e);
            return null;
        }
        catch (IOException e) {
            Logger.error("An error occurred while saving the report named " + reportName, e);
        }
        return null;
    }

    private String downloadReportToFile(String destDirPath, String downloadUrl) {
        String reportName;
        try {
            URL reportUrl = new URL(downloadUrl);
            String downloadPathFromURL = reportUrl.getPath();
            reportName = NSPathUtilities.lastPathComponent(downloadPathFromURL);
        }
        catch (MalformedURLException e) {
            Logger.error("The server returned an invalid report download URL: " + downloadUrl, e);
            return null;
        }
        try {
            boolean didSave;
            String destDirPathPlusReportName = NSPathUtilities.stringByAppendingPathComponent(destDirPath, reportName);
            File reportDestination = new File(destDirPathPlusReportName);
            if (reportDestination.exists() && !reportDestination.delete()) {
                Logger.error("An error occurred deleting the report " + reportDestination.getPath());
            }
            if (didSave = FileUtil.saveFileAtURLToDestination(downloadUrl, reportDestination, false)) {
                return reportDestination.getAbsolutePath();
            }
            Logger.error("An error occurred while downloading the report named " + reportName);
        }
        catch (FileNotFoundException e) {
            Logger.error("An error occurred.  The report named " + reportName + " could not be found.", e);
        }
        catch (IOException e) {
            Logger.error("An I/O error occurred while downloading the report named " + reportName, e);
        }
        return null;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        ItcProviderNameOption iTCProviderName = new ItcProviderNameOption();
        iTCProviderName.setRequired(false);
        options.addOption((Option)iTCProviderName);
        options.addOption((Option)new OutputFormatOption());
        options.addOption((Option)new ReportTypeOption());
        options.addOption((Option)new ReportDateOption());
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.Generic));
        return options;
    }
}

