/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.itunes.epubtoolkit.EPUBCleaner;
import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AssetFileOption;
import com.apple.transporter.operation.option.AssetFolderOption;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.RemoveUnmanifestedFilesOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class RepairEpubAssets
extends Operation {
    public static final String MODE_VALUE = "repairEpubAssets";
    private static final String epubFileExtension = "epub";

    public RepairEpubAssets(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("RepairEpubAssets mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Collection<File> assetFiles = null;
        boolean preValidationSucceeded = true;
        try {
            if (!this.validateAssetDirectory()) {
                preValidationSucceeded = false;
            }
            if ((assetFiles = this.assetFilesToBeRepaired()).size() == 0 && this.wasAssetFolderUsed()) {
                Logger.error("The asset folder '" + this.assetFolderFile().getPath() + "' does not contain any valid publication asset files.");
                preValidationSucceeded = false;
            } else if (assetFiles.size() == 0 && this.wasAssetFileUsed()) {
                Logger.error("The file '" + this.assetFile().getPath() + "' is not a valid publication asset file.");
                preValidationSucceeded = false;
            }
        }
        catch (Exception re) {
            Logger.error("An error occurred while preparing to repair the publication asset(s)", re);
            preValidationSucceeded = false;
        }
        boolean wasSuccessful = false;
        if (preValidationSucceeded) {
            wasSuccessful = this.performRepairEpubAssets(assetFiles);
        }
        Map<String, String> info = this.gatherRepairedAssetsInfo(assetFiles);
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
            this.showRepairedAssetsInfo(info, true);
        } else {
            this.showRepairedAssetsInfo(info, false);
        }
        return wasSuccessful;
    }

    private Map<String, String> gatherRepairedAssetsInfo(Collection<File> assetFiles) {
        if (assetFiles == null || assetFiles.size() == 0) {
            return null;
        }
        HashMap<String, String> repairedFileInfo = new HashMap<String, String>();
        try {
            for (File anAssetFile : assetFiles) {
                File repairedFile = this.repairedAssetFileForOriginalAssetFile(anAssetFile);
                if (!repairedFile.exists()) continue;
                String hash = null;
                try {
                    Logger.info("Calculating the md5 checksum for the repaired file '" + repairedFile.getPath() + "'.");
                    hash = FileUtil.md5Hex(repairedFile);
                    if (hash == null) {
                        hash = "Could not calculate checksum";
                    }
                }
                catch (IOException ioe) {
                    hash = "Could not calculate checksum";
                    Logger.error("An I/O error occurred while calculating the md5 of '" + repairedFile.getPath() + "'.", ioe);
                }
                catch (NoSuchAlgorithmException nsae) {
                    hash = "Could not calculate checksum";
                    Logger.error("An error occurred while calculating the md5 of '" + repairedFile.getPath() + "'.", nsae);
                }
                catch (Throwable t) {
                    hash = "Could not calculate checksum";
                    Logger.error("An error occurred while calculating the md5 of '" + repairedFile.getPath() + "'.", t);
                }
                repairedFileInfo.put(repairedFile.getPath(), hash);
            }
        }
        catch (IOException io) {
            Logger.error("An error occurred while reporting repaired publication asset(s) information.", io);
        }
        catch (RuntimeException re) {
            Logger.error("An error occurred while reporting repaired publication asset(s) information.", re);
        }
        return repairedFileInfo;
    }

    private void showRepairedAssetsInfo(Map<String, String> repairedFileInfo, boolean hadErrorDuringRepair) {
        if (hadErrorDuringRepair && (repairedFileInfo == null || repairedFileInfo.size() == 0)) {
            return;
        }
        if (hadErrorDuringRepair && repairedFileInfo != null && repairedFileInfo.size() > 0) {
            Logger.essential("\n\nRepaired publication asset(s) information, despite error:");
        } else {
            if (!(hadErrorDuringRepair || repairedFileInfo != null && repairedFileInfo.size() != 0)) {
                Logger.essential("\n\nRepaired publication asset(s) information:");
                Logger.essential("There are no repaired assets.");
                return;
            }
            Logger.essential("\n\nRepaired publication asset(s) information:");
        }
        try {
            int maxPathLength = 0;
            int maxChecksumLength = 0;
            for (String aPath : repairedFileInfo.keySet()) {
                String checksum = repairedFileInfo.get(aPath);
                if (aPath.length() > maxPathLength) {
                    maxPathLength = aPath.length();
                }
                if (checksum.length() <= maxChecksumLength) continue;
                maxChecksumLength = checksum.length();
            }
            String pathHeader = "- Repaired File Path -";
            String checksumHeader = "- Repaired File Checksum -";
            if (pathHeader.length() > maxPathLength) {
                maxPathLength = pathHeader.length();
            }
            if (checksumHeader.length() > maxChecksumLength) {
                maxChecksumLength = checksumHeader.length();
            }
            String header = null;
            header = this.wasAssetFileUsed() ? "" : TransportUtil.appendSpacesToStringToReachLength("", repairedFileInfo.size() + 2);
            header = header + TransportUtil.appendSpacesToStringToReachLength(pathHeader, maxPathLength + 2);
            header = header + checksumHeader;
            Logger.essential(header);
            int i = 1;
            for (String aPath : repairedFileInfo.keySet()) {
                String number = String.valueOf(i);
                String fileInfo = null;
                fileInfo = this.wasAssetFileUsed() ? "" : TransportUtil.appendSpacesToStringToReachLength(number, repairedFileInfo.size() + 2);
                fileInfo = fileInfo + TransportUtil.appendSpacesToStringToReachLength(aPath, maxPathLength + 2);
                fileInfo = fileInfo + repairedFileInfo.get(aPath);
                Logger.essential(fileInfo);
                ++i;
            }
        }
        catch (RuntimeException re) {
            Logger.error("An error occurred while reporting repaired publication asset(s) information.", re);
        }
    }

    private boolean performRepairEpubAssets(Collection<File> assetFiles) {
        if (assetFiles == null || assetFiles.size() == 0) {
            return false;
        }
        boolean wasSuccessful = true;
        try {
            for (File anAssetFile : assetFiles) {
                boolean tempFlag = this.repairEpubAsset(anAssetFile);
                if (tempFlag) continue;
                wasSuccessful = false;
            }
        }
        catch (RuntimeException re) {
            Logger.error("An error occurred while repairing the publication asset(s).", re);
            wasSuccessful = false;
        }
        return wasSuccessful;
    }

    private boolean repairEpubAsset(File anAssetFile) {
        if (anAssetFile == null) {
            Logger.error("An asset file is required.");
            return false;
        }
        if (!anAssetFile.exists()) {
            Logger.error("The asset file '" + anAssetFile.getName() + "' doesn't exist.");
            return false;
        }
        if (!anAssetFile.isFile()) {
            Logger.error("'" + anAssetFile.getName() + "' is not a file.");
            return false;
        }
        if (!anAssetFile.canRead()) {
            Logger.error("The asset file '" + anAssetFile.getName() + "' is not readable.");
            return false;
        }
        boolean wasSuccessful = false;
        try {
            Logger.info("Starting to repair publication asset '" + anAssetFile.getName() + "'.");
            File destinationDirWithFilename = this.repairedAssetFileForOriginalAssetFile(anAssetFile);
            EPUBCleaner epubCleaner = new EPUBCleaner(anAssetFile, destinationDirWithFilename);
            epubCleaner.clean(RemoveUnmanifestedFilesOption.shouldRemoveUnmanifestedFiles(), null);
            Logger.info("Finished repairing publication asset.  The repaired file is '" + destinationDirWithFilename.getPath() + "'.");
            wasSuccessful = true;
        }
        catch (IOException ioe) {
            Logger.error("An I/O error occurred while repairing the publication asset '" + anAssetFile.getName() + "'.", ioe);
        }
        catch (EPUBException ee) {
            Logger.error("An error occurred while repairing the publication asset '" + anAssetFile.getName() + "'.", ee);
        }
        catch (Throwable t) {
            Logger.error("An error occurred while repairing the publication asset '" + anAssetFile.getName() + "'.", t);
        }
        return wasSuccessful;
    }

    private File repairedAssetFileForOriginalAssetFile(File inputAssetFile) throws IOException {
        if (inputAssetFile == null) {
            return null;
        }
        String destinationDirWithFilename = NSPathUtilities.stringByAppendingPathComponent(this.destinationFile().getPath(), inputAssetFile.getName());
        return new File(destinationDirWithFilename);
    }

    private boolean validateAssetDirectory() throws IOException {
        File assetDirectory = null;
        if (this.wasAssetFileUsed()) {
            assetDirectory = this.assetFile().getParentFile();
        } else if (this.wasAssetFolderUsed()) {
            assetDirectory = this.assetFolderFile();
        }
        if (assetDirectory.getCanonicalPath().equals(this.destinationFile().getCanonicalPath())) {
            Logger.error("The destination directory cannot be the same as the asset directory.");
            return false;
        }
        return true;
    }

    private Collection<File> assetFilesToBeRepaired() throws IOException {
        File[] tempFiles;
        ArrayList<File> assetFiles = new ArrayList<File>();
        if (this.wasAssetFileUsed()) {
            if (this.isFileValidForRepair(this.assetFile())) {
                assetFiles.add(this.assetFile());
            }
        } else if (this.wasAssetFolderUsed() && (tempFiles = this.assetFolderFile().listFiles()) != null && tempFiles.length > 0) {
            for (int i = 0; i < tempFiles.length; ++i) {
                File aFile = tempFiles[i];
                if (!this.isFileValidForRepair(aFile)) continue;
                assetFiles.add(aFile);
            }
        }
        return assetFiles;
    }

    private boolean isFileValidForRepair(File anAssetFile) {
        if (anAssetFile == null) {
            return false;
        }
        String fileExtension = null;
        if (anAssetFile.getName() != null) {
            fileExtension = NSPathUtilities.pathExtension(anAssetFile.getName());
        }
        return fileExtension != null && fileExtension.length() > 0 && fileExtension.equalsIgnoreCase(epubFileExtension);
    }

    private boolean wasAssetFileUsed() {
        String path = System.getProperty("assetFile");
        return path != null && path.length() > 0;
    }

    private boolean wasAssetFolderUsed() {
        String path = System.getProperty("assetFolder");
        return path != null && path.length() > 0;
    }

    private File assetFile() throws IOException {
        String path = System.getProperty("assetFile");
        if (path != null) {
            File assetFile = new File(FileUtil.absolutePathForPath(path));
            return assetFile;
        }
        return null;
    }

    private File assetFolderFile() throws IOException {
        String path = System.getProperty("assetFolder");
        if (path != null) {
            File assetFolder = new File(FileUtil.absolutePathForPath(path));
            return assetFolder;
        }
        return null;
    }

    private File destinationFile() throws IOException {
        String path = System.getProperty("destination");
        if (path != null) {
            File aFile = new File(FileUtil.absolutePathForPath(path));
            return aFile;
        }
        return null;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.RepairEpubAssets));
        options.addOption((Option)new RemoveUnmanifestedFilesOption());
        OptionGroup assetGroup = new OptionGroup();
        assetGroup.setRequired(true);
        AssetFolderOption assetFolderOption = new AssetFolderOption(AssetFolderOption.Variant.RepairEpubAssets);
        assetGroup.addOption((Option)assetFolderOption);
        AssetFileOption assetFileOption = new AssetFileOption(AssetFileOption.Variant.RepairEpubAssets);
        assetGroup.addOption((Option)assetFileOption);
        options.addOptionGroup(assetGroup);
        return options;
    }
}

