/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.util.StreamUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.Options;

public class QueryTickets
extends Operation {
    public static final String MODE_VALUE = "queryTickets";

    public QueryTickets(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return QueryTickets.this.service.queryTickets();
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            } else {
                try {
                    String base64Tickets = (String)results.get(System.getProperty("contentTicketsKey"));
                    if (base64Tickets != null) {
                        String s = StreamUtil.base64GzipToString(base64Tickets);
                        Application.writeXML(s);
                    }
                }
                catch (IOException e) {
                    Logger.error("Failure extracting ticket query results", e);
                    success = false;
                }
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOptionGroup(OptionHelper.appleIdOrVendorIdOptionGroup(false, AppleIdOption.Variant.QueryTickets, VendorIdOption.Variant.QueryTickets));
        return options;
    }
}

