/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.util.XMLUtil;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class LookupVideo
extends Operation {
    public LookupVideo(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Performing lookupVideo request ...");
        String vendorId = VendorIdOption.vendorIdentifier();
        boolean generateXML = Application.shouldGenerateXML();
        try {
            Logger.info("Looking up a video with vendor id " + vendorId + " ...");
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return LookupVideo.this.service.lookupVideoOperation(Application.shouldHidePassword());
                }
            });
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while looking up the video info.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            if (returnValue == null) {
                String errorMessage = "Unable to retrieve video info.";
                if (generateXML) {
                    XMLUtil.XMLTag tag = XMLUtil.generateLogTag(1, Logger.Level.Error, errorMessage);
                    Application.XMLStream.print(tag.marshall());
                }
                Logger.error(errorMessage);
                return false;
            }
            String videoTitle = (String)returnValue.get(System.getProperty("VideoTitleKey"));
            String videoReleaseDate = (String)returnValue.get(System.getProperty("VideoReleaseDateKey"));
            String videoType = (String)returnValue.get(System.getProperty("VideoTypeKey"));
            String videoAirDate = (String)returnValue.get(System.getProperty("VideoAirDateKey"));
            if (videoTitle == null) {
                videoTitle = "";
            }
            if (videoReleaseDate == null) {
                videoReleaseDate = "";
            }
            if (videoType == null) {
                videoType = "";
            }
            if (videoAirDate == null) {
                videoAirDate = "";
            }
            Logger.essential("Video Info");
            Logger.essential("Title:\t" + videoTitle);
            Logger.essential("Release Date:\t" + videoReleaseDate);
            Logger.essential("Type:\t" + videoType);
            Logger.essential("Air Date:\t" + videoAirDate);
            if (generateXML) {
                XMLUtil.XMLTag videoInfo = new XMLUtil.XMLTag("video_info", 1);
                videoInfo.addChildTag("title").setText(videoTitle);
                videoInfo.addChildTag("release_date").setText(videoReleaseDate);
                videoInfo.addChildTag("type").setText(videoType);
                videoInfo.addChildTag("air_date").setText(videoAirDate);
                Application.XMLStream.print(videoInfo.marshall());
            }
        }
        catch (Throwable t) {
            Logger.error("Error occurred while looking up a video with vendor id " + vendorId + ".", t);
            if (generateXML) {
                String errorMessage = "Error occurred while looking up a video with vendor id " + String.valueOf(vendorId) + ".";
                XMLUtil.XMLTag tag = XMLUtil.generateLogTag(1, Logger.Level.Error, errorMessage);
                Application.XMLStream.print(tag.marshall());
            }
            return false;
        }
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, true, includeHidden);
        OptionGroup vendorIdGroup = new OptionGroup();
        vendorIdGroup.setRequired(true);
        vendorIdGroup.addOption((Option)new VendorIdOption(VendorIdOption.Variant.Generic));
        if (includeHidden) {
            VendorIdOption legacyVendorIdOption = new VendorIdOption(VendorIdOption.Variant.VendorIdentifier);
            legacyVendorIdOption.setHidden(true);
            vendorIdGroup.addOption((Option)legacyVendorIdOption);
            options.addOption((Option)new OutputFormatOption());
        }
        options.addOptionGroup(vendorIdGroup);
        return options;
    }
}

