/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.XMLUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class LookupPurpleSoftwareVersions
extends Operation {
    private static final String ARGUMENT_DICT__APPLICATIONS_KEY = "Applications";
    private static final String ARGUMENT_DICT__ATTRIBUTES_KEY = "Attributes";
    private static final String ARGUMENT_DICT__DISPLAY_KEYS_KEY = "DisplayKeys";
    private static final String ARGUMENT_DICT__METADATA_TEMPLATE_KEY = "MetadataTemplate";
    private static final String ARGUMENT_DICT__TRANSPORT_OVERRIDE_KEY = "TransportOverride";
    private static final String ARGUMENT_DICT__VERIFY_ZIP_ITEGRITY_KEY = "VerifyZipIntegrity";
    private static final String ARGUMENT_DICT__PERFORM_ICON_VERIFICATION_KEY = "PerformIconVerification";
    private static final String ARGUMENT_DICT__REQUIRE_PAYLOAD_DIRECTORY_KEY = "RequirePayloadDirectory";
    private static final String ARGUMENT_DICT__PERFORM_CODESIGN_VERIFICATION_KEY = "PerformCodesignVerification";
    private static final String ARGUMENT_DICT__PERFORM_SERVER_SIDE_VERIFICATION_KEY = "PerformServerVerification";
    private static final String ARGUMENT_DICT__PERFORM_ICON_SIZE_VERIFICATION_KEY = "PerformIconSizeVerification";
    private static final String ARGUMENT_DICT__PERFORM_BUNDLE_RESOURCE_VERIFICATION_KEY = "PerformBundleResourceVerification";
    private static final String ARGUMENT_DICT__PERFORM_ZIP_FILENAME_VERIFICATION_KEY = "PerformZipFilenameVerification";
    private static final String ARGUMENT_DICT__DISALLOWED_PATHS_KEY = "DisallowedPaths";
    private static final String ARGUMENT_DICT__VALID_ICON_SIZES_KEY = "ValidIconSizes";

    public LookupPurpleSoftwareVersions(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Performing lookup purple software versions request ...");
        try {
            Map<String, ? extends Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ? extends Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, ? extends Object> invoke() {
                    return LookupPurpleSoftwareVersions.this.service.lookupPurpleSoftwareVersions(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to retrieve purple software versions.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while retrieving the purple software versions.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            this.displayReturnValue(returnValue, Application.XMLStream);
        }
        catch (Throwable t) {
            Logger.error("Error occurred while retrieving the purple software versions.", t);
            return false;
        }
        return true;
    }

    private List<String> convertToStringCollection(Object[] rawKeys) {
        if (rawKeys == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object key : rawKeys) {
            results.add((String)key);
        }
        return results;
    }

    private List<Map<String, String>> convertToApplicationAttributes(Object[] rawKeys) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        for (Object key : rawKeys) {
            results.add((Map)key);
        }
        return results;
    }

    private boolean booleanValueForStringParameter(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            return false;
        }
        return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes");
    }

    private void displayReturnValue(Map<String, ? extends Object> returnValue, PrintStream printStream) {
        Map applications = (Map)returnValue.get(ARGUMENT_DICT__APPLICATIONS_KEY);
        Object[] rawAttributes = (Object[])returnValue.get(ARGUMENT_DICT__ATTRIBUTES_KEY);
        Object[] rawKeys = (Object[])returnValue.get(ARGUMENT_DICT__DISPLAY_KEYS_KEY);
        String metadataTemplate = (String)returnValue.get(ARGUMENT_DICT__METADATA_TEMPLATE_KEY);
        String transportOverride = (String)returnValue.get(ARGUMENT_DICT__TRANSPORT_OVERRIDE_KEY);
        String verifyZipIntegrityKey = (String)returnValue.get(ARGUMENT_DICT__VERIFY_ZIP_ITEGRITY_KEY);
        String performIconVerificationKey = (String)returnValue.get(ARGUMENT_DICT__PERFORM_ICON_VERIFICATION_KEY);
        String requirePayloadDirectoryKey = (String)returnValue.get(ARGUMENT_DICT__REQUIRE_PAYLOAD_DIRECTORY_KEY);
        String performCodesignCheck = (String)returnValue.get(ARGUMENT_DICT__PERFORM_CODESIGN_VERIFICATION_KEY);
        String performServerSideVerificationKey = (String)returnValue.get(ARGUMENT_DICT__PERFORM_SERVER_SIDE_VERIFICATION_KEY);
        String performIconSizeVerificationKey = (String)returnValue.get(ARGUMENT_DICT__PERFORM_ICON_SIZE_VERIFICATION_KEY);
        String performBundleResourceVerificationKey = (String)returnValue.get(ARGUMENT_DICT__PERFORM_BUNDLE_RESOURCE_VERIFICATION_KEY);
        String performZipFilenameVerificationKey = (String)returnValue.get(ARGUMENT_DICT__PERFORM_ZIP_FILENAME_VERIFICATION_KEY);
        Object[] rawDisallowedPaths = (Object[])returnValue.get(ARGUMENT_DICT__DISALLOWED_PATHS_KEY);
        Object[] rawValidIconSizes = (Object[])returnValue.get(ARGUMENT_DICT__VALID_ICON_SIZES_KEY);
        boolean verifyZipIntegrity = this.booleanValueForStringParameter(verifyZipIntegrityKey);
        boolean requirePayloadDirectory = this.booleanValueForStringParameter(requirePayloadDirectoryKey);
        boolean performIconVerification = this.booleanValueForStringParameter(performIconVerificationKey);
        boolean performServerSideVerification = this.booleanValueForStringParameter(performServerSideVerificationKey);
        boolean performIconSizeVerification = this.booleanValueForStringParameter(performIconSizeVerificationKey);
        boolean performBundleResourceVerification = this.booleanValueForStringParameter(performBundleResourceVerificationKey);
        boolean performZipFilenameVerification = this.booleanValueForStringParameter(performZipFilenameVerificationKey);
        if (applications == null) {
            Logger.error("No applications returned");
            return;
        }
        if (rawAttributes == null) {
            Logger.error("No application attributes returned");
            return;
        }
        if (rawKeys == null) {
            Logger.error("No display keys returned");
            return;
        }
        List<String> displayKeys = this.convertToStringCollection(rawKeys);
        List<Map<String, String>> applicationAttributes = this.convertToApplicationAttributes(rawAttributes);
        List<String> disallowedPaths = this.convertToStringCollection(rawDisallowedPaths);
        List<String> validIconSizes = this.convertToStringCollection(rawValidIconSizes);
        if (Application.shouldGenerateXML()) {
            this.generateXML(applications, applicationAttributes, displayKeys, metadataTemplate, transportOverride, performCodesignCheck, verifyZipIntegrity, requirePayloadDirectory, performIconVerification, performServerSideVerification, performIconSizeVerification, performBundleResourceVerification, performZipFilenameVerification, disallowedPaths, validIconSizes, printStream);
        } else {
            this.generateRegularOutput(applications, applicationAttributes, displayKeys, metadataTemplate, transportOverride, performCodesignCheck, verifyZipIntegrity, requirePayloadDirectory, performIconVerification, performServerSideVerification, performIconSizeVerification, performBundleResourceVerification, performZipFilenameVerification, disallowedPaths, validIconSizes, printStream);
        }
    }

    private void generateRegularOutput(Map<String, String> applications, List<Map<String, String>> applicationAttributes, List<String> displayKeys, String metadataTemplate, String transportOverride, String performCodesignCheck, boolean verifyZipIntegrity, boolean requirePayloadDirectory, boolean performIconVerification, boolean performServerSideVerification, boolean performIconSizeVerification, boolean performBundleResourceVerification, boolean performZipFilenameVerification, List<String> disallowedPaths, List<String> validIconSizes, PrintStream printStream) {
        printStream.println("Application\t\tAppleID");
        printStream.println("-----------\t\t-------");
        ArrayList<String> sortedKeys = new ArrayList<String>(applications.keySet());
        Collections.sort(sortedKeys);
        for (String string : sortedKeys) {
            String string2 = applications.get(string);
            printStream.println(string + "\t\t" + string2);
        }
        if (metadataTemplate != null && metadataTemplate.length() > 0) {
            printStream.println("Metadata Template");
            printStream.println("-----------------");
            printStream.println(metadataTemplate);
            printStream.println();
        }
        for (Map<String, String> map : applicationAttributes) {
            printStream.println("Attribute\t\tValue");
            printStream.println("---------\t\t-----");
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            Collections.sort(sortedKeys);
            for (String key : keys) {
                String value = map.get(key);
                printStream.println(key + "\t\t" + value);
            }
        }
        printStream.println();
        printStream.println("Display Keys");
        printStream.println("------------");
        for (String string : displayKeys) {
            printStream.println(string);
        }
        if (transportOverride != null) {
            printStream.println();
            printStream.println("Transport Override");
            printStream.println("------------------");
            printStream.println(transportOverride);
        }
        if (performCodesignCheck != null || verifyZipIntegrity || performIconVerification || requirePayloadDirectory) {
            printStream.println();
            printStream.println("Client Side Validation");
            printStream.println("----------------------");
            printStream.println("CodesignExpression = " + (performCodesignCheck == null ? "undefined" : performCodesignCheck));
            printStream.println("PerformIconVerification = " + (performIconVerification ? "true" : "false"));
            printStream.println("RequirePayloadDirectory = " + (requirePayloadDirectory ? "true" : "false"));
            printStream.println("VerifyZipIntegriy = " + (verifyZipIntegrity ? "true" : "false"));
            printStream.println("PerformServerSideVerification = " + (performServerSideVerification ? "true" : "false"));
            printStream.println("PerformIconSizeVerification = " + (performIconSizeVerification ? "true" : "false"));
            printStream.println("PerformBundleResourceVerification = " + (performBundleResourceVerification ? "true" : "false"));
            printStream.println("PerformZipFilenameVerification = " + (performZipFilenameVerification ? "true" : "false"));
            printStream.println("DisallowedPaths = " + (disallowedPaths == null ? "<none>" : disallowedPaths.toString()));
            printStream.println("ValidIconSizes = " + (validIconSizes == null ? "<none>" : validIconSizes.toString()));
        }
    }

    private void generateXML(Map<String, String> applications, List<Map<String, String>> applicationAttributes, List<String> displayKeys, String metadataTemplate, String transportOverride, String performCodesignCheck, boolean verifyZipIntegrity, boolean requirePayloadDirectory, boolean performIconVerification, boolean performServerSideVerification, boolean performIconSizeVerification, boolean performBundleResourceVerification, boolean performZipFilenameVerification, List<String> disallowedPaths, List<String> validIconSizes, PrintStream printStream) {
        XMLUtil.XMLTag root = new XMLUtil.XMLTag("purple_software_versions", 1);
        root.addChildTag("applications").addMap(applications);
        if (metadataTemplate != null && metadataTemplate.length() > 0) {
            root.addChildTag("metadata_template").setCDATA(metadataTemplate);
        }
        root.addChildTag("application_attributes").addList(applicationAttributes);
        root.addChildTag("display_keys").addList(displayKeys);
        if (transportOverride != null) {
            root.addChildTag("transport").setText(transportOverride);
        }
        if (performCodesignCheck != null || verifyZipIntegrity || performIconVerification || requirePayloadDirectory) {
            XMLUtil.XMLTag validation = root.addChildTag("validation");
            if (performCodesignCheck != null) {
                validation.addChildTag("codesign_expression").setText(performCodesignCheck);
            }
            if (performIconVerification) {
                validation.addChildTag("icon_verification");
            }
            if (requirePayloadDirectory) {
                validation.addChildTag("payload_directory");
            }
            if (verifyZipIntegrity) {
                validation.addChildTag("zip_integrity");
            }
            if (performServerSideVerification) {
                validation.addChildTag("server_side_verification");
            }
            if (performIconSizeVerification) {
                validation.addChildTag("icon_size_verification");
            }
            if (performBundleResourceVerification) {
                validation.addChildTag("bundle_resource_verification");
            }
            if (performZipFilenameVerification) {
                validation.addChildTag("zip_filename_verification");
            }
            if (disallowedPaths != null) {
                validation.addChildTag("disallowed_paths").addList(disallowedPaths);
            }
            if (validIconSizes != null) {
                validation.addChildTag("valid_icon_sizes").addList(validIconSizes);
            }
        }
        printStream.print(root.marshall());
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        if (includeHidden) {
            options.addOption((Option)new OutputFormatOption());
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        return options;
    }
}

