/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AccountTypeOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.util.TransportUtil;
import com.apple.transporter.util.XMLUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class LookupProvider
extends Operation {
    public static String NAME = "provider";

    public LookupProvider(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Provider mode selected.");
        Logger.info("Performing providers request ...");
        try {
            Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return LookupProvider.this.service.providersOperation(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to retrieve providers list.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while retrieving the providers list.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            String[] providerList = returnValue.keySet().toArray(new String[0]);
            List<String> providerListAsListObj = Arrays.asList(providerList);
            Collections.sort(providerListAsListObj);
            Object[] temp = providerListAsListObj.toArray();
            System.arraycopy(temp, 0, providerList, 0, temp.length);
            if (providerList == null) {
                Logger.error("No provider names were received from the remote Apple server.");
                return false;
            }
            if (Application.shouldGenerateXML()) {
                XMLUtil.XMLTag tag = new XMLUtil.XMLTag("provider_list", 1);
                for (int i = 0; i < providerList.length; ++i) {
                    String aProviderName = providerList[i];
                    String aProviderShortName = (String)returnValue.get(providerList[i]);
                    XMLUtil.XMLTag providerTag = tag.addChildTag("provider");
                    providerTag.addChildTag("number").setText(String.valueOf(i + 1));
                    providerTag.addChildTag("long_name").setText(aProviderName);
                    providerTag.addChildTag("short_name").setText(aProviderShortName);
                }
                Application.XMLStream.print(tag.marshall());
            } else {
                Logger.essential(" ");
                Logger.essential("Provider listing:");
                String longNameHeader = "- Long Name -";
                String shortNameHeader = "- Short Name -";
                int longestProviderNameLength = longNameHeader.length();
                for (int i = 0; i < providerList.length; ++i) {
                    int tempLength = providerList[i].length();
                    if (tempLength <= longestProviderNameLength) continue;
                    longestProviderNameLength = tempLength;
                }
                String numberAsString = String.valueOf(providerList.length);
                int numberLength = numberAsString.length();
                int numberLengthPlusTwoSpaces = numberLength + 2;
                int longestProviderNameLengthPlusTwoSpaces = longestProviderNameLength + 2;
                String blankNumberHeader = TransportUtil.appendSpacesToStringToReachLength(null, numberLengthPlusTwoSpaces);
                String longNameHeaderWithSpaces = TransportUtil.appendSpacesToStringToReachLength(longNameHeader, longestProviderNameLengthPlusTwoSpaces);
                String headerOutput = blankNumberHeader + longNameHeaderWithSpaces + shortNameHeader;
                Logger.essential(headerOutput);
                for (int i = 0; i < providerList.length; ++i) {
                    String indexAsString = String.valueOf(i + 1);
                    String indexWithSpaces = TransportUtil.appendSpacesToStringToReachLength(indexAsString, numberLengthPlusTwoSpaces);
                    String longNameWithSpaces = TransportUtil.appendSpacesToStringToReachLength(providerList[i], longestProviderNameLengthPlusTwoSpaces);
                    String shortName = (String)returnValue.get(providerList[i]);
                    String lineOutput = indexWithSpaces + longNameWithSpaces + shortName;
                    Logger.essential(lineOutput);
                }
            }
        }
        catch (Throwable t) {
            Logger.error("Error occurred while retrieving the provider shortnames.", t);
            return false;
        }
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addUsernameAndPasswordAuthenticationOptions(options, true, includeHidden);
        options.addOption((Option)new AccountTypeOption(false));
        if (includeHidden) {
            options.addOption((Option)new OutputFormatOption());
        }
        return options;
    }
}

