/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.lookupmetadata.MetadataFetcher;
import com.apple.transporter.operation.option.AppPlatformOption;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputTypeOption;
import com.apple.transporter.operation.option.SubitemIDsOption;
import com.apple.transporter.operation.option.SubitemTypeOption;
import com.apple.transporter.operation.option.VendorIdOption;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class LookupMetadata
extends Operation {
    public static final String MODE_VALUE = "lookupMetadata";

    public LookupMetadata(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("LookupMetadata mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        boolean wasSuccessful = true;
        try {
            wasSuccessful = this.performLookupMetadataRequest();
        }
        finally {
            if (!wasSuccessful) {
                Application.showNonPackageBasedErrorSummary();
            }
        }
        return wasSuccessful;
    }

    private boolean performLookupMetadataRequest() {
        Logger.info("Performing lookupMetadata request ...");
        MetadataFetcher fetcher = MetadataFetcher.createFetcher(this.service);
        return fetcher.fetchMetadata();
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.LookupMetadata));
        options.addOptionGroup(OptionHelper.appleIdOrVendorIdOptionGroup(AppleIdOption.Variant.LookupMetadata, VendorIdOption.Variant.LookupMetadata));
        options.addOption((Option)new SubitemTypeOption());
        options.addOption((Option)new SubitemIDsOption());
        options.addOption((Option)new OutputTypeOption());
        options.addOption((Option)new AppPlatformOption().setRequiredFluently(false));
        return options;
    }
}

