/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.ColumnarOutputFormatter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.ArtistNameOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.SearchLocaleOption;
import com.apple.transporter.util.XMLUtil;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class LookupArtist
extends Operation {
    public static final String MODE_VALUE = "lookupArtist";
    private static final String RESULTS__ARTIST_NAME_KEY = "artistName";
    private static final String RESULTS__APPLE_ID_KEY = "appleId";
    private static final String RESULTS__GENRE_KEY = "genre";
    private static final String RESULTS__LOCALE_KEY = "locale";
    private static final String RESULTS__IS_CURATED_KEY = "isCurated";
    private static final String RESULTS__WHEN_CREATED_KEY = "whenCreated";
    private static final String RESULTS__TITLES_KEY = "titles";
    private static final String RESULTS__TITLES_NAME_KEY = "name";
    private static final String RESULTS__TITLES_ADAM_ID_KEY = "adamId";
    private static final String RESULTS__TITLES_PROVIDER_KEY = "contentProvider";

    public LookupArtist(WebService service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Logger.info("LookupArtist mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return LookupArtist.this.service.artistSearchOperation(Application.shouldHidePassword());
            }
        });
        boolean wasSuccessful = false;
        try {
            List<Object> resultsList;
            if (null == returnValue) {
                Application.logUnnecessaryError("Unable to process the search artist request.");
                boolean bl = wasSuccessful;
                return bl;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while searching for the artist.");
                Application.displaySOAPErrorMessages(returnValue);
                boolean bl = wasSuccessful;
                return bl;
            }
            Object[] results = (Object[])returnValue.get("SearchResults");
            if (null == results) {
                results = new Object[]{};
            }
            Logger.essential(" ");
            List<Object> artists = resultsList = Arrays.asList(results);
            artists.sort((Comparator<Object>)new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    String n1 = (String)o1.get(LookupArtist.RESULTS__ARTIST_NAME_KEY);
                    String n2 = (String)o2.get(LookupArtist.RESULTS__ARTIST_NAME_KEY);
                    int nameResult = 0;
                    if (null == n1 && null == n2) {
                        nameResult = 0;
                    } else if (null == n1) {
                        nameResult = 1;
                    } else if (null == n2) {
                        nameResult = -1;
                    }
                    if (nameResult != 0) {
                        return nameResult;
                    }
                    Object a1 = o1.get(LookupArtist.RESULTS__APPLE_ID_KEY);
                    Object a2 = o2.get(LookupArtist.RESULTS__APPLE_ID_KEY);
                    if (null == a1 && null == a2) {
                        return 0;
                    }
                    if (null == a1) {
                        return 1;
                    }
                    if (null == a2) {
                        return -1;
                    }
                    try {
                        Long a_1 = Long.parseLong(a1.toString());
                        Long a_2 = Long.parseLong(a2.toString());
                        return a_1.compareTo(a_2);
                    }
                    catch (NumberFormatException nfx) {
                        return a1.toString().compareTo(a2.toString());
                    }
                }
            });
            if (artists.isEmpty()) {
                Logger.error("Artist not found.", true);
            } else if (Application.shouldGenerateXML()) {
                wasSuccessful = ArtistXMLOutputFormatter.processArtists(artists);
            } else {
                Logger.essential("Artist listing:");
                ColumnarOutputFormatter formatter = new ColumnarOutputFormatter(LookupArtist.getColumns(), 5);
                wasSuccessful = formatter.processRows(artists);
            }
            Logger.essential(" ");
        }
        finally {
            if (!wasSuccessful) {
                Application.showNonPackageBasedErrorSummary();
            }
        }
        return wasSuccessful;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addUsernameAndPasswordAuthenticationOptions(options, true, includeHidden);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setRequired(true);
        optionGroup.addOption((Option)new ArtistNameOption());
        optionGroup.addOption((Option)new AppleIdOption(AppleIdOption.Variant.Generic));
        options.addOptionGroup(optionGroup);
        options.addOption((Option)new SearchLocaleOption());
        ItcProviderNameOption iTCProviderName = new ItcProviderNameOption();
        iTCProviderName.setRequired(false);
        options.addOption((Option)iTCProviderName);
        if (includeHidden) {
            options.addOption((Option)new OutputFormatOption());
        }
        return options;
    }

    public static List<ColumnarOutputFormatter.OutputColumn<?>> getColumns() {
        final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd hh:mm a z").toFormatter();
        ArrayList columns = new ArrayList();
        columns.add(new ColumnarOutputFormatter.OutputColumn<String>("Name", RESULTS__ARTIST_NAME_KEY, ""));
        columns.add(new ColumnarOutputFormatter.OutputColumn<String>("Apple ID", RESULTS__APPLE_ID_KEY, "").setAlignment(ColumnarOutputFormatter.Alignment.RIGHT));
        columns.add(new ColumnarOutputFormatter.OutputColumn<String>("Genre", RESULTS__GENRE_KEY, ""));
        columns.add(new ColumnarOutputFormatter.OutputColumn<String>("Locale", RESULTS__LOCALE_KEY, ""));
        columns.add(new ColumnarOutputFormatter.OutputColumn<String>("Created", RESULTS__WHEN_CREATED_KEY, "").setOutputFormatter(new ColumnarOutputFormatter.OutputFormatter<String>(){

            @Override
            public List<String> format(String input) {
                if (null == input) {
                    return null;
                }
                ArrayList<String> results = new ArrayList<String>(1);
                try {
                    ZonedDateTime zdt = ZonedDateTime.parse(input);
                    if (null == zdt) {
                        return null;
                    }
                    results.add(formatter.format(zdt));
                }
                catch (DateTimeParseException px) {
                    results.add(input);
                }
                return results;
            }
        }));
        columns.add(new ColumnarOutputFormatter.OutputColumn<Object[]>("Title", RESULTS__TITLES_KEY, new Object[0]).setOutputFormatter(new ColumnarOutputFormatter.OutputFormatter<Object[]>(){

            @Override
            public List<String> format(Object[] input) {
                ArrayList<String> results = new ArrayList<String>();
                if (null == input || input.length == 0) {
                    return results;
                }
                for (Object obj : input) {
                    Map row = (Map)obj;
                    results.add((String)row.get(LookupArtist.RESULTS__TITLES_NAME_KEY));
                }
                return results;
            }
        }));
        columns.add(new ColumnarOutputFormatter.OutputColumn<Object[]>("Title's Apple ID", RESULTS__TITLES_KEY, new Object[0]).setAlignment(ColumnarOutputFormatter.Alignment.RIGHT).setOutputFormatter(new ColumnarOutputFormatter.OutputFormatter<Object[]>(){

            @Override
            public List<String> format(Object[] input) {
                ArrayList<String> results = new ArrayList<String>();
                if (null == input || input.length == 0) {
                    return results;
                }
                for (Object obj : input) {
                    Map row = (Map)obj;
                    results.add(String.format("%s", row.get(LookupArtist.RESULTS__TITLES_ADAM_ID_KEY)));
                }
                return results;
            }
        }));
        columns.add(new ColumnarOutputFormatter.OutputColumn<Object[]>("Title's content provider", RESULTS__TITLES_KEY, new Object[0]).setOutputFormatter(new ColumnarOutputFormatter.OutputFormatter<Object[]>(){

            @Override
            public List<String> format(Object[] input) {
                ArrayList<String> results = new ArrayList<String>();
                if (null == input || input.length == 0) {
                    return results;
                }
                for (Object obj : input) {
                    Map row = (Map)obj;
                    results.add((String)row.get(LookupArtist.RESULTS__TITLES_PROVIDER_KEY));
                }
                return results;
            }
        }));
        return columns;
    }

    public static class ArtistXMLOutputFormatter {
        public static boolean processArtists(@Nonnull List<Map<String, Object>> artists) {
            XMLUtil.XMLTag tag = new XMLUtil.XMLTag("artist_list", 1);
            for (Map<String, Object> artistRow : artists) {
                ArtistXMLOutputFormatter.generateArtistRowAsXML(tag, artistRow);
            }
            Application.XMLStream.print(tag.marshall());
            return true;
        }

        private static void generateArtistRowAsXML(XMLUtil.XMLTag tag, Map<String, Object> artistRow) {
            XMLUtil.XMLTag artistTag = null != tag ? tag.addChildTag("artist") : new XMLUtil.XMLTag("artist", 1);
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, LookupArtist.RESULTS__ARTIST_NAME_KEY, LookupArtist.RESULTS__TITLES_NAME_KEY);
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, LookupArtist.RESULTS__APPLE_ID_KEY, LookupArtist.RESULTS__APPLE_ID_KEY);
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, LookupArtist.RESULTS__GENRE_KEY, LookupArtist.RESULTS__GENRE_KEY);
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, LookupArtist.RESULTS__LOCALE_KEY, LookupArtist.RESULTS__LOCALE_KEY);
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, LookupArtist.RESULTS__WHEN_CREATED_KEY, "created");
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, "isPrimary", "isPrimary");
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, "isFeaturing", "isFeaturing");
            ArtistXMLOutputFormatter.generateSubtag(artistTag, artistRow, "isWith", "isWith");
        }

        private static void generateSubtag(XMLUtil.XMLTag tag, Map<String, Object> artistRow, String key, String elementName) {
            Object value = artistRow.get(key);
            if (value != null) {
                tag.addChildTag(elementName).setText(value.toString());
            }
        }
    }
}

