/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.TransportUtil;
import com.apple.transporter.util.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListReports
extends Operation {
    public static final String MODE_VALUE = "listReports";

    public ListReports(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map<String, Object> results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return ListReports.this.service.listReports();
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            } else {
                Map reportsByType = (Map)results.get(System.getProperty("reportsByTypeKey"));
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm z", Locale.US);
                dateFormat.setTimeZone(TimeZone.getDefault());
                if (Application.shouldGenerateXML()) {
                    XMLUtil.XMLTag reportsTag = new XMLUtil.XMLTag("reports", 1);
                    if (reportsByType == null || reportsByType.isEmpty()) {
                        Logger.info("There are no available reports from the remote Apple server.");
                    } else {
                        for (String reportType : reportsByType.keySet()) {
                            Object[] reportsForType;
                            XMLUtil.XMLTag reportTypeTag = reportsTag.addChildTag("type");
                            reportTypeTag.addAttribute("name", reportType);
                            for (Object reportInfoObj : reportsForType = (Object[])reportsByType.get(reportType)) {
                                Map reportInfo = (Map)reportInfoObj;
                                Number number = (Number)reportInfo.get(System.getProperty("dateRequestedKey"));
                                String requestedBy = (String)reportInfo.get(System.getProperty("requestedByKey"));
                                String status = (String)reportInfo.get(System.getProperty("reportStatusKey"));
                                String localDateRequested = dateFormat.format(new Date(number.longValue()));
                                XMLUtil.XMLTag reportTag = reportTypeTag.addChildTag("report");
                                reportTag.addAttribute("dateRequested", localDateRequested);
                                reportTag.addAttribute("requestedBy", requestedBy);
                                reportTag.addAttribute("status", status);
                            }
                        }
                    }
                    Application.XMLStream.print(reportsTag.marshall());
                } else {
                    Logger.essential(" ");
                    if (reportsByType == null || reportsByType.isEmpty()) {
                        Logger.essential("There are no available reports from the remote Apple server.");
                        return true;
                    }
                    Logger.essential("Report Listing:");
                    String dateRequestedHeader = "Date Requested";
                    String requestedByHeader = "Requested By";
                    String reportTypeHeader = "Report Type";
                    String statusHeader = "Status";
                    int longestDateRequestedLength = dateRequestedHeader.length();
                    int longestRequestedByLength = requestedByHeader.length();
                    int longestReportTypeLength = reportTypeHeader.length();
                    int longestStatusLength = statusHeader.length();
                    ArrayList reportRows = new ArrayList();
                    for (String string : reportsByType.keySet()) {
                        Object[] reportsForType;
                        for (Object reportInfoObj : reportsForType = (Object[])reportsByType.get(string)) {
                            Map reportInfo = (Map)reportInfoObj;
                            Number gmtDateRequested = (Number)reportInfo.get(System.getProperty("dateRequestedKey"));
                            String requestedBy = (String)reportInfo.get(System.getProperty("requestedByKey"));
                            String status = (String)reportInfo.get(System.getProperty("reportStatusKey"));
                            String localDateRequested = dateFormat.format(new Date(gmtDateRequested.longValue()));
                            ArrayList<String> row = new ArrayList<String>(4);
                            row.add(localDateRequested);
                            row.add(requestedBy);
                            row.add(string);
                            row.add(status);
                            longestDateRequestedLength = Math.max(longestDateRequestedLength, localDateRequested.length());
                            longestRequestedByLength = Math.max(longestRequestedByLength, requestedBy.length());
                            longestReportTypeLength = Math.max(longestReportTypeLength, string.length());
                            longestStatusLength = Math.max(longestStatusLength, status.length());
                            reportRows.add(row);
                        }
                    }
                    Logger.essential(TransportUtil.appendSpacesToStringToReachLength(dateRequestedHeader, longestDateRequestedLength) + " | " + TransportUtil.appendSpacesToStringToReachLength(requestedByHeader, longestRequestedByLength) + " | " + TransportUtil.appendSpacesToStringToReachLength(reportTypeHeader, longestReportTypeLength) + " | " + TransportUtil.appendSpacesToStringToReachLength(statusHeader, longestStatusLength));
                    for (List list : reportRows) {
                        Logger.essential(TransportUtil.appendSpacesToStringToReachLength((String)list.get(0), longestDateRequestedLength) + " | " + TransportUtil.appendSpacesToStringToReachLength((String)list.get(1), longestRequestedByLength) + " | " + TransportUtil.appendSpacesToStringToReachLength((String)list.get(2), longestReportTypeLength) + " | " + TransportUtil.appendSpacesToStringToReachLength((String)list.get(3), longestStatusLength));
                    }
                }
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        ItcProviderNameOption iTCProviderName = new ItcProviderNameOption();
        iTCProviderName.setRequired(false);
        options.addOption((Option)iTCProviderName);
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        options.addOption((Option)new OutputFormatOption());
        return options;
    }
}

