/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListReportTypes
extends Operation {
    public static final String MODE_VALUE = "listReportTypes";

    public ListReportTypes(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        Map<String, Object> results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return ListReportTypes.this.service.listReportTypes();
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            } else {
                Object[] reportTypes = (Object[])results.get(System.getProperty("reportTypesKey"));
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm z", Locale.US);
                dateFormat.setTimeZone(TimeZone.getDefault());
                if (Application.shouldGenerateXML()) {
                    XMLUtil.XMLTag reportsTag = new XMLUtil.XMLTag("report_types", 1);
                    if (reportTypes == null || reportTypes.length == 0) {
                        Logger.info("There are no available report types from the remote Apple server.");
                    } else {
                        for (Object reportType : reportTypes) {
                            XMLUtil.XMLTag reportTypeTag = reportsTag.addChildTag("type");
                            reportTypeTag.addAttribute("name", (String)reportType);
                        }
                    }
                    Application.XMLStream.print(reportsTag.marshall());
                } else {
                    Logger.essential(" ");
                    if (reportTypes == null || reportTypes.length == 0) {
                        Logger.essential("There are no available report types from the remote Apple server.");
                        return true;
                    }
                    Logger.essential("Available Report Types:");
                    for (Object reportType : reportTypes) {
                        Logger.essential((String)reportType);
                    }
                }
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        options.addOption((Option)new UsernameOption());
        options.addOption((Option)new PasswordOption());
        if (includeHidden) {
            options.addOption((Option)new DSTokenOption());
            options.addOption((Option)new Hsa2HeadersOption());
        }
        ItcProviderNameOption iTCProviderName = new ItcProviderNameOption();
        iTCProviderName.setRequired(false);
        options.addOption((Option)iTCProviderName);
        options.addOption((Option)new OutputFormatOption());
        return options;
    }
}

