/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.QualityOption;
import com.apple.transporter.operation.option.StateOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ITunesQCDownload
extends Operation {
    public static final String EXTRA_QC_MODE_VALUE = "iTunesExtraQCDownload";
    public static final String LP_QC_MODE_VALUE = "iTunesLPQCDownload";
    public static final String QC_URL_KEY = "QCUrl";
    public static final String MESSAGES_KEY = "Messages";
    private QCDownloadType type;

    public ITunesQCDownload(WebService service, QCDownloadType value) {
        super(service);
        this.type = value;
    }

    @Override
    public boolean execute() {
        Logger.info(this.modeName() + " mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        boolean wasSuccessful = this.performITunesQCDownloadRequest();
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
        }
        return wasSuccessful;
    }

    private boolean performITunesQCDownloadRequest() {
        block17: {
            try {
                Logger.info("Performing " + this.modeName() + " request ...");
                Logger.info("The request for the QC package was made by " + UsernameOption.username());
                Map returnValue = this.invokeCorrectSoapOperation();
                if (returnValue == null) {
                    Application.logUnnecessaryError("Unable to process the QC package request.");
                    return false;
                }
                if (Application.doesContainSOAPError(returnValue)) {
                    Application.logUnnecessaryError("An error occurred while processing the QC package request.");
                    Application.displaySOAPErrorMessages(returnValue);
                    return false;
                }
                Object[] messages = (Object[])returnValue.get(MESSAGES_KEY);
                if (messages != null && messages.length > 0) {
                    for (Object aMessage : messages) {
                        Logger.info(aMessage.toString());
                    }
                }
                String qcURL = (String)returnValue.get(QC_URL_KEY);
                if (returnValue.containsKey(QC_URL_KEY) && (qcURL == null || qcURL.length() == 0)) {
                    Logger.error("The QC package could not be download because a URL was not specified by the web service.");
                    return false;
                }
                if (qcURL == null || qcURL.length() == 0) {
                    return true;
                }
                String destDirPath = null;
                try {
                    destDirPath = TransportUtil.destinationPathFromProperty();
                }
                catch (Throwable t) {
                    Logger.error("The specified destination path is not valid.", t);
                    return false;
                }
                URL tempURL = new URL(qcURL);
                String pathFromURL = tempURL.getPath();
                String filename = NSPathUtilities.lastPathComponent(pathFromURL);
                try {
                    boolean didSave;
                    Logger.info("Downloading the QC package: " + filename);
                    String destDirPathPlusfilename = NSPathUtilities.stringByAppendingPathComponent(destDirPath, filename);
                    File destination = new File(destDirPathPlusfilename);
                    if (destination.exists()) {
                        Logger.info("A QC package named " + filename + " already exists in " + destDirPath + ".  It will be deleted before downloading the new one.");
                        if (!destination.delete()) {
                            Logger.error("An error occurred deleting the QC package " + destination.getPath());
                        }
                    }
                    if (!(didSave = FileUtil.saveFileAtURLToDestination(qcURL, destination, true))) {
                        Logger.error("An error occurred while downloading the QC package named " + filename);
                        break block17;
                    }
                    Logger.essential("\n\nDownloading the QC package has completed.");
                }
                catch (FileNotFoundException fnfe) {
                    Logger.error("An error occurred.  The QC package named " + filename + " could not be found.", fnfe);
                }
                catch (IOException ioe) {
                    Logger.error("An I/O error occurred while downloading the QC package named " + filename, ioe);
                }
                catch (RuntimeException re) {
                    Logger.error("An error occurred while downloading the QC package named " + filename, re);
                }
            }
            catch (Throwable t) {
                Logger.error("Error occurred while processing the QC package request.", t);
                return false;
            }
        }
        return true;
    }

    private boolean isExtraQCDownloadType() {
        return this.type.equals((Object)QCDownloadType.Extra);
    }

    private boolean isLpQcDownloadType() {
        return this.type.equals((Object)QCDownloadType.LP);
    }

    private String modeName() {
        if (this.isExtraQCDownloadType()) {
            return EXTRA_QC_MODE_VALUE;
        }
        if (this.isLpQcDownloadType()) {
            return LP_QC_MODE_VALUE;
        }
        throw new RuntimeException("QC download type is unknown.");
    }

    private Map invokeCorrectSoapOperation() {
        if (this.isExtraQCDownloadType()) {
            return WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map invoke() {
                    return ITunesQCDownload.this.service.iTunesExtraQCForDownloadOperation(Application.shouldHidePassword());
                }
            });
        }
        if (this.isLpQcDownloadType()) {
            return WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map invoke() {
                    return ITunesQCDownload.this.service.iTunesLpQcForDownloadOperation(Application.shouldHidePassword());
                }
            });
        }
        throw new RuntimeException("QC download type is unknown.");
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.Generic));
        options.addOption((Option)new StateOption());
        options.addOption((Option)new QualityOption());
        options.addOptionGroup(OptionHelper.appleIdOrVendorIdOptionGroup(true, AppleIdOption.Variant.QCDownload, VendorIdOption.Variant.QCDownload));
        return options;
    }

    public static enum QCDownloadType {
        Extra,
        LP;

    }
}

