/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.SchemaOption;
import com.apple.transporter.operation.option.SchemaTypeOption;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GenerateSchema
extends Operation {
    public GenerateSchema(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        boolean success;
        block26: {
            ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
            Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map invoke() {
                    return GenerateSchema.this.service.generateSchema();
                }
            });
            success = true;
            if (results != null) {
                if (Application.doesContainSOAPError(results)) {
                    Application.displaySOAPErrorMessages(results);
                    success = false;
                } else {
                    try {
                        String base64Schema = (String)results.get(System.getProperty("schemaKey"));
                        if (base64Schema == null) break block26;
                        String schema = StreamUtil.base64GzipToString(base64Schema);
                        boolean writtenToFile = false;
                        String destinationProperty = System.getProperty("destination");
                        if (destinationProperty != null) {
                            String destPath = null;
                            try {
                                destPath = TransportUtil.destinationPathFromProperty();
                            }
                            catch (Exception e) {
                                Logger.error("Could not determine destination path: " + destinationProperty);
                            }
                            if (destPath != null) {
                                File path = new File(destPath);
                                File outFile = null;
                                outFile = SchemaOption.isStaticSchema() ? new File(path, SchemaOption.getSchemaValue() + SchemaOption.getStaticSchemaExtension()) : new File(path, System.getProperty("schema") + "-" + System.getProperty("schemaType") + ".rng");
                                try (FileWriter out = new FileWriter(outFile);){
                                    Logger.info("Writing schema to file: " + outFile.getAbsolutePath());
                                    out.write(schema);
                                    writtenToFile = true;
                                }
                                catch (IOException e) {
                                    Logger.error("Could not write to destination path: " + outFile.getAbsolutePath());
                                }
                            }
                        }
                        if (!writtenToFile) {
                            Application.writeXML(schema);
                        }
                    }
                    catch (IOException e) {
                        Logger.error("Failure extracting schema", e);
                        success = false;
                    }
                }
            } else {
                success = false;
            }
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new SchemaOption());
        options.addOption((Option)new SchemaTypeOption());
        DestinationOption destinationOption = new DestinationOption(DestinationOption.Variant.Generic);
        destinationOption.setRequired(false);
        options.addOption((Option)destinationOption);
        return options;
    }
}

