/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DownloadMetadataGuides
extends Operation {
    public static final String MODE_VALUE = "downloadMetadataGuides";
    protected static final String RETURN_DICT__METADATA_GUIDE_URLS_KEY = "MetadataGuideURLs";

    public DownloadMetadataGuides(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("DownloadMetadataGuides mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        boolean wasSuccessful = this.performDownloadMetadataGuidesRequest();
        if (!wasSuccessful) {
            Application.showNonPackageBasedErrorSummary();
        }
        return wasSuccessful;
    }

    private boolean performDownloadMetadataGuidesRequest() {
        Logger.info("Performing downloadMetadataGuides request ...");
        Logger.info("The request for the documents was made by " + UsernameOption.username());
        try {
            Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map invoke() {
                    return DownloadMetadataGuides.this.service.metadataGuidesForDownloadWithArgumentsOperation(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to download the metadata guides.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while downloading the metadata guides.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            Object[] guideURLs = (Object[])returnValue.get(RETURN_DICT__METADATA_GUIDE_URLS_KEY);
            if (guideURLs == null || guideURLs.length == 0) {
                Logger.error("Apple did not return any metadata guides to download.");
                return true;
            }
            String destDirPath = null;
            try {
                destDirPath = TransportUtil.destinationPathFromProperty();
            }
            catch (Throwable t) {
                Logger.error("The specified destination path is not valid.", t);
                return false;
            }
            ArrayList<String> guidesWithDownloadErrors = new ArrayList<String>();
            for (int i = 0; i < guideURLs.length; ++i) {
                String aGuideURL = (String)guideURLs[i];
                URL tempURL = new URL(aGuideURL);
                String aGuidePathFromURL = tempURL.getPath();
                String aGuideName = NSPathUtilities.lastPathComponent(aGuidePathFromURL);
                try {
                    boolean didSave;
                    Logger.info("Downloading the metadata guide: " + aGuideName);
                    String destDirPathPlusGuideName = NSPathUtilities.stringByAppendingPathComponent(destDirPath, aGuideName);
                    File guideDestination = new File(destDirPathPlusGuideName);
                    if (guideDestination.exists()) {
                        Logger.info("The metadata guide " + aGuideName + " already exists in " + destDirPath + ".  It will be deleted before downloading the new one.");
                        if (!guideDestination.delete()) {
                            Logger.error("An error occurred deleting the metadata guide " + guideDestination.getPath());
                        }
                    }
                    if (didSave = FileUtil.saveFileAtURLToDestination(aGuideURL, guideDestination, false)) continue;
                    Logger.error("An error occurred while downloading the metadata guide named " + aGuideName);
                    guidesWithDownloadErrors.add(aGuideName);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    Logger.error("An error occurred.  The metadata guide named " + aGuideName + " could not be found.", fnfe);
                    guidesWithDownloadErrors.add(aGuideName);
                    continue;
                }
                catch (IOException ioe) {
                    Logger.error("An I/O error occurred while downloading the metadata guide named " + aGuideName, ioe);
                    guidesWithDownloadErrors.add(aGuideName);
                    continue;
                }
                catch (RuntimeException re) {
                    Logger.error("An error occurred while downloading the metadata guide named " + aGuideName, re);
                    guidesWithDownloadErrors.add(aGuideName);
                }
            }
            if (guidesWithDownloadErrors != null && guidesWithDownloadErrors.size() > 0) {
                String lastGuideName = (String)guidesWithDownloadErrors.get(guidesWithDownloadErrors.size() - 1);
                String guideNamesForLogMessage = "";
                for (String aGuideName : guidesWithDownloadErrors) {
                    guideNamesForLogMessage = guideNamesForLogMessage + aGuideName;
                    if (aGuideName.equals(lastGuideName)) continue;
                    guideNamesForLogMessage = guideNamesForLogMessage + ", ";
                }
                Logger.error("These metadata guides had errors during download: " + guideNamesForLogMessage);
                return false;
            }
            Logger.essential("\n\nDownloading the metadata guides has completed.");
        }
        catch (Throwable t) {
            Logger.error("Error occurred while downloading the metadata guides.", t);
            return false;
        }
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.DownloadMetadataGuides));
        return options;
    }
}

