/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.NumericOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.TransportOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.transport.TransportByPodPolicy;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.UnknownTransportException;
import com.apple.transporter.util.TransportUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Diagnostic
extends Operation {
    public static final String MODE_VALUE = "diagnostic";

    public Diagnostic(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Diagnostic mode selected.");
        if (UsernameOption.usernameWasGiven()) {
            return this.authenticatedDiagnostic();
        }
        return this.unauthenticatedDiagnostic(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticatedDiagnostic() {
        Map<String, Object> webServiceResponse;
        boolean webServiceSuccess = false;
        try {
            this.service.shouldComputeNextRequestChecksum(true);
            webServiceResponse = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return Diagnostic.this.service.lookupTransportDiagnostic();
                }
            });
            this.service.shouldComputeNextRequestChecksum(false);
            if (webServiceResponse == null) {
                Application.logUnnecessaryError("Unable to perform diagnostic.");
                boolean bl = false;
                return bl;
            }
            if (Application.doesContainSOAPError(webServiceResponse)) {
                Application.logUnnecessaryError("An error occurred while performing diagnostic.");
                Application.displaySOAPErrorMessages(webServiceResponse);
                boolean bl = false;
                return bl;
            }
            webServiceSuccess = true;
        }
        catch (Throwable t) {
            Logger.error("Error occurred while performing diagnostic.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            this.service.shouldComputeNextRequestChecksum(false);
            if (!webServiceSuccess) {
                Logger.essential("\t\t\t\t\t\tTEST RESULT: The web service test failed.");
            }
        }
        Logger.essential("\t\t\t\t\t\tTEST RESULT: The web service test succeeded. Able to connect to web service.");
        if (!TransportByPodPolicy.webServiceResponseHasPods(webServiceResponse)) {
            Logger.warn("Unable to obtain diagnostic mode configuration from the web service.");
            return this.unauthenticatedDiagnostic(false);
        }
        Logger.essential("\t\t\t\t\t\tTEST RESULT: The authentication test succeeded. Able to connect to service.");
        boolean allSuccess = true;
        String signiantRetries = System.getProperty("signiantRetries");
        String signiantRestarts = System.getProperty("signiantRestarts");
        try {
            List<TransportType> transportNames;
            System.setProperty("signiantRetries", "0");
            System.setProperty("signiantRestarts", "0");
            try {
                transportNames = TransportUtil.getTransports();
            }
            catch (UnknownTransportException e) {
                Logger.error("Please specify a valid transport value.");
                boolean bl = false;
                if (signiantRetries == null) {
                    System.getProperties().remove("signiantRetries");
                } else {
                    System.setProperty("signiantRetries", signiantRetries);
                }
                if (signiantRestarts == null) {
                    System.getProperties().remove("signiantRestarts");
                } else {
                    System.setProperty("signiantRestarts", signiantRestarts);
                }
                return bl;
            }
            for (TransportType transportName : transportNames) {
                Logger.info("Performing " + (Object)((Object)transportName) + " diagnostic test ...");
                TransportByPodPolicy policy = new TransportByPodPolicy(this.service, transportName, webServiceResponse);
                Logger.essential(" ");
                boolean success = true;
                boolean atLeastOne = false;
                while (policy.hasMoreTransportPods()) {
                    if (policy.canPerformDiagnostic()) {
                        atLeastOne = true;
                        if (!policy.performDiagnostic(true)) {
                            success = false;
                        }
                    }
                    policy.next();
                }
                if (!atLeastOne) {
                    Logger.error("Unable to obtain diagnostic mode configuration from local or remote sources.");
                }
                Logger.info("Done performing transport diagnostic test.");
                if (success) {
                    Logger.essential("\t\t\t\t\t\tTEST RESULT: The transport test succeeded.  Able to connect to the host(s).");
                    continue;
                }
                Logger.essential("\t\t\t\t\t\tTEST RESULT: Could not connect to at least one host.");
                allSuccess = false;
            }
        }
        finally {
            if (signiantRetries == null) {
                System.getProperties().remove("signiantRetries");
            } else {
                System.setProperty("signiantRetries", signiantRetries);
            }
            if (signiantRestarts == null) {
                System.getProperties().remove("signiantRestarts");
            } else {
                System.setProperty("signiantRestarts", signiantRestarts);
            }
        }
        return allSuccess;
    }

    private boolean unauthenticatedDiagnostic(boolean testWebService) {
        if (testWebService) {
            Logger.warn("Please use diagnostic mode with a username and password for the most accurate diagnostic.");
            if (this.service.performDiagnostic()) {
                Logger.essential("\t\t\t\t\t\tTEST RESULT: The web service test succeeded. Able to connect to web service.");
            } else {
                Logger.essential("\t\t\t\t\t\tTEST RESULT: The web service test failed.");
            }
        }
        boolean allSuccess = true;
        try {
            List<TransportType> transportNames = TransportUtil.getTransports();
            for (TransportType transportName : transportNames) {
                Logger.essential(" ");
                if (TransportUtil.performUnauthenticatedDiagnostic(transportName, true)) {
                    Logger.essential("\t\t\t\t\t\tTEST RESULT: The transport test succeeded.  Able to connect to the host(s).");
                    continue;
                }
                Logger.essential("\t\t\t\t\t\tTEST RESULT: Could not connect to at least one host.");
                allSuccess = false;
            }
        }
        catch (UnknownTransportException e) {
            Logger.error("Please specify a valid transport value.");
            return false;
        }
        return allSuccess;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, false, includeHidden);
        options.addOption((Option)new TransportOption(TransportOption.Variant.Diagnostic));
        if (includeHidden) {
            options.addOption((Option)new BaseOption("diagnosticHost", true));
            options.addOption((Option)new NumericOption("diagnosticPort"));
            options.addOption((Option)new BaseOption("relay", true));
        }
        return options;
    }
}

