/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.ExtendedOptions;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.operation.option.VendorIdOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CreateMetadataTicket
extends Operation {
    public static final String MODE_VALUE = "createMetadataTicket";
    private static List<String> trackTitles = new ArrayList<String>();
    private static List<String> trackTitleTranslations = new ArrayList<String>();
    private static List<String> trackTitleVersions = new ArrayList<String>();
    private static List<String> trackGenres = new ArrayList<String>();
    private static String titleVersion;
    private static String playlistGenre;
    private static final Set<String> validLang;

    public CreateMetadataTicket(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        if (System.getProperty("playlistTitle") == null && System.getProperty("playlistTitleTranslation") == null && titleVersion == null && trackTitles.isEmpty() && trackTitleTranslations.isEmpty() && trackTitleVersions.isEmpty() && playlistGenre == null) {
            Logger.error("Please supply at least one new metadata item.");
            Application.showNonPackageBasedErrorSummary();
            return false;
        }
        Map results = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map invoke() {
                return CreateMetadataTicket.this.service.createMetadataTicket(System.getProperty("playlistTitle"), System.getProperty("playlistTitleTranslation"), titleVersion, trackTitles, trackTitleTranslations, trackTitleVersions, playlistGenre, trackGenres, System.getProperty("note"));
            }
        });
        boolean success = true;
        if (results != null) {
            if (Application.doesContainSOAPError(results)) {
                Application.displaySOAPErrorMessages(results);
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            Application.showNonPackageBasedErrorSummary();
        } else {
            Logger.essential("\n\nRequest Summary\n");
            Logger.essential("Metadata ticket was successfully created.");
        }
        return success;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        ExtendedOptions options = new ExtendedOptions("", this.getHelpTextFooter());
        options.addOption(new UsernameOption());
        options.addOption(new PasswordOption());
        ItcProviderNameOption iTCProviderName = new ItcProviderNameOption();
        iTCProviderName.setRequired(false);
        options.addOption(iTCProviderName);
        options.addOptionGroup(OptionHelper.appleIdOrVendorIdOptionGroup(true, AppleIdOption.Variant.Generic, VendorIdOption.Variant.Generic));
        options.addOption(new BaseOption("playlistTitle", true, "New playlist title."));
        options.addOption(new TitleVersionOption("titleVersion"));
        if (includeHidden) {
            options.addOption(new TitleVersionOption("versionTitle"));
            options.addOption(new DSTokenOption());
            options.addOption(new Hsa2HeadersOption());
        }
        options.addOption(new PlaylistTitleTranslationOption());
        options.addOption(new TrackTitleOption());
        options.addOption(new TrackTitleTranslationOption());
        options.addOption(new TrackTitleVersionOption());
        options.addOption(new PlaylistGenreOption());
        BaseOption noteOption = new BaseOption("note", true, "A note to include with the newly opened ticket.");
        noteOption.setRequired(true);
        options.addOption(noteOption);
        return options;
    }

    public String getHelpTextFooter() {
        return System.getProperty("line.separator") + "At least one of the following parameters must be specified in this mode: playlistTitle, titleVersion, " + "playlistTitleTranslation" + ", " + "trackTitle" + ", " + "trackTitleTranslation" + ", " + "trackTitleVersion" + ", " + "playlistGenre";
    }

    static {
        validLang = new HashSet<String>();
        validLang.addAll(Arrays.asList("english", "japanese", "phonetic", "native"));
    }

    @Deprecated
    public static class TrackGenreOption
    extends BaseOption
    implements Validatable {
        private static String usage = "[<disc_number>:]<track_number>:<genre_code>. Examples: \"1:ROCK-00\" or \"1:ROCK-00,3:JAZZ-00\" or \"1:1:ROCK-00,2:3:JAZZ-00\"";
        public static final String NAME = "trackGenre";
        static boolean validated = false;
        private final Pattern VolumeTrackTitlePattern = Pattern.compile("^(\\d+):(\\d+):(.*)$");
        private final Pattern TrackTitlePattern = Pattern.compile("^(\\d+):(.*)$");

        public TrackGenreOption() throws IllegalArgumentException {
            super(NAME, true, "New track genre code.  This parameter may be specified multiple times (separated by a comma), once per disc and track number. If the disc number is not specified it will default to 1. Parameter must be in the form " + usage);
            this.setValueSeparator(',');
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (values != null) {
                if (values.length == 1) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (String v : values[0].split(",")) {
                        list.add(v.trim());
                    }
                    trackGenres.addAll(list);
                } else {
                    trackGenres.addAll(Arrays.asList(values));
                }
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            if (!validated) {
                validated = true;
                HashSet<String> trackNumbers = new HashSet<String>();
                Boolean hasTrackGenre = trackGenres.size() > 0;
                if (hasTrackGenre.booleanValue()) {
                    for (String trackGenre : trackGenres) {
                        boolean parameterBad = false;
                        Matcher matcher = this.VolumeTrackTitlePattern.matcher(trackGenre);
                        int discNumber = 1;
                        int trackNumber = 0;
                        int groupIndex = 1;
                        if (matcher.matches()) {
                            try {
                                discNumber = Integer.parseInt(matcher.group(groupIndex++));
                            }
                            catch (NumberFormatException badDisc) {
                                parameterBad = true;
                            }
                        } else {
                            matcher = this.TrackTitlePattern.matcher(trackGenre);
                        }
                        if (!matcher.matches()) {
                            parameterBad = true;
                        } else {
                            try {
                                String key;
                                trackNumber = Integer.parseInt(matcher.group(groupIndex));
                                if (discNumber < 1 || trackNumber < 1) {
                                    parameterBad = true;
                                }
                                if (trackNumbers.contains(key = discNumber + ":" + trackNumber)) {
                                    throw new OptionValidationException("Only one genre may be specified for each disc and track number combination.");
                                }
                                trackNumbers.add(key);
                            }
                            catch (NumberFormatException e) {
                                parameterBad = true;
                            }
                        }
                        if (!parameterBad) continue;
                        throw new OptionValidationException("trackGenre parameter must conform to pattern: " + usage);
                    }
                }
            }
        }
    }

    public static class PlaylistGenreOption
    extends BaseOption
    implements Validatable {
        public static final String NAME = "playlistGenre";
        static boolean validated = false;

        public PlaylistGenreOption() throws IllegalArgumentException {
            super(NAME, true, "New playlist or music video genre code. The argument may only be specified once.");
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String value = commandLine.getOptionValue(this.getOpt());
            if (value != null && value.trim().length() > 0) {
                playlistGenre = value;
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (null == values || values.length == 0) {
                return;
            }
            if (values.length > 1) {
                throw new OptionValidationException("Only one playlistGenre option may be specified.");
            }
            if (values[0].trim().length() == 0) {
                throw new OptionValidationException("The value for the playlistGenre option may not be blank.");
            }
        }
    }

    public static class TrackTitleVersionOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = 3990208953244282271L;
        static boolean validated = false;
        private static String usage = "[<disc_number>:]<track_number>:version. Example: \"4:Live\"";
        public static final String NAME = "trackTitleVersion";
        private final Pattern VolumeTrackVersionPattern = Pattern.compile("^(\\d+):(\\d+):(.*)$");
        private final Pattern TrackVersionPattern = Pattern.compile("^(\\d+):(.*)$");

        public TrackTitleVersionOption() throws IllegalArgumentException {
            super(NAME, true, "New track title version. This parameter may be specified multiple times, once per disc and track number. If the disc number is not specified it will default to 1. Parameter must be in the form " + usage);
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (values != null) {
                trackTitleVersions.addAll(Arrays.asList(values));
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            if (!validated) {
                validated = true;
                HashSet<String> trackNumbers = new HashSet<String>();
                for (String trackTitleVersion : trackTitleVersions) {
                    boolean parameterBad = false;
                    Matcher matcher = this.VolumeTrackVersionPattern.matcher(trackTitleVersion);
                    int discNumber = 1;
                    int groupIndex = 1;
                    if (matcher.matches()) {
                        try {
                            discNumber = Integer.parseInt(matcher.group(groupIndex++));
                        }
                        catch (NumberFormatException badDisc) {
                            parameterBad = true;
                        }
                    } else {
                        matcher = this.TrackVersionPattern.matcher(trackTitleVersion);
                    }
                    if (!matcher.matches()) {
                        parameterBad = true;
                    } else {
                        try {
                            String key;
                            int trackNumber = Integer.parseInt(matcher.group(groupIndex++));
                            if (discNumber < 1 || trackNumber < 1) {
                                parameterBad = true;
                            }
                            if (trackNumbers.contains(key = discNumber + ":" + trackNumber)) {
                                throw new OptionValidationException("Only one version may be specified for each disc and track number.");
                            }
                            trackNumbers.add(key);
                        }
                        catch (NumberFormatException e) {
                            parameterBad = true;
                        }
                    }
                    if (!parameterBad) continue;
                    throw new OptionValidationException("trackTitleVersion parameter must conform to pattern: " + usage);
                }
            }
        }
    }

    public static class TrackTitleTranslationOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = -4880272113503128733L;
        static boolean validated = false;
        private static String usage = "[<disc_number>:]<track_number>:<lang>:<translation> where <lang> is one of 'english', 'japanese', 'native', 'phonetic' or 'phonetic_<locale code>'. Example: \"4:english:LoremIpsum\", or \"4:phonetic_ja:LoremIpsum\"";
        public static final String NAME = "trackTitleTranslation";
        private final Pattern VolumeTrackLanguageTranslationPattern = Pattern.compile("^(\\d+):(\\d+):([^:]+):(.*)$");
        private final Pattern TrackLanguageTranslationPattern = Pattern.compile("^(\\d+):([^:]+):(.*)$");

        public TrackTitleTranslationOption() throws IllegalArgumentException {
            super(NAME, true, "New track title translation. This parameter may be specified multiple times, once per disc, track number, and language combination. If the disc number is not specified it will default to 1. Parameter must be in the form " + usage);
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (values != null) {
                trackTitleTranslations.addAll(Arrays.asList(values));
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            if (!validated) {
                validated = true;
                HashSet<String> trackNumbers = new HashSet<String>();
                for (String trackTitleTranslation : trackTitleTranslations) {
                    boolean parameterBad = false;
                    Matcher matcher = this.VolumeTrackLanguageTranslationPattern.matcher(trackTitleTranslation);
                    int discNumber = 1;
                    int groupIndex = 1;
                    if (matcher.matches()) {
                        try {
                            discNumber = Integer.parseInt(matcher.group(groupIndex++));
                        }
                        catch (NumberFormatException badDisc) {
                            parameterBad = true;
                        }
                    } else {
                        matcher = this.TrackLanguageTranslationPattern.matcher(trackTitleTranslation);
                    }
                    if (!matcher.matches()) {
                        parameterBad = true;
                    } else {
                        try {
                            String translation;
                            String key;
                            int trackNumber = Integer.parseInt(matcher.group(groupIndex++));
                            if (discNumber < 1 || trackNumber < 1) {
                                parameterBad = true;
                            }
                            String lang = matcher.group(groupIndex++);
                            if (!validLang.contains(lang) && !lang.toLowerCase().startsWith("phonetic_")) {
                                parameterBad = true;
                            }
                            if (trackNumbers.contains(key = discNumber + ":" + trackNumber + ":" + (lang.equalsIgnoreCase("phonetic") ? "phonetic_ja" : lang.trim().toLowerCase()))) {
                                String errorMessage = String.format("The track title translation for disc: %d, track: %d, language: %s is specified more than once.", discNumber, trackNumber, lang);
                                if (key.endsWith("phonetic_ja")) {
                                    throw new OptionValidationException(errorMessage + " Note: phonetic is equivalent to phonetic_ja.");
                                }
                                throw new OptionValidationException(errorMessage);
                            }
                            if (null == (translation = matcher.group(groupIndex++)) || translation.trim().isEmpty()) {
                                throw new OptionValidationException(String.format("The track title translation cannot be empty for disc: %d, track: %d, language: %s.", discNumber, trackNumber, lang));
                            }
                            trackNumbers.add(key);
                        }
                        catch (NumberFormatException e) {
                            parameterBad = true;
                        }
                    }
                    if (!parameterBad) continue;
                    throw new OptionValidationException("trackTitleTranslation parameter must conform to pattern: " + usage);
                }
            }
        }
    }

    public static class TrackTitleOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = 7695274805355988760L;
        static boolean validated = false;
        private static String usage = "[<disc_number>:]<track_number>:<title>. Example: \"1:LoremIpsum\"";
        public static final String NAME = "trackTitle";
        private final Pattern VolumeTrackTitlePattern = Pattern.compile("^(\\d+):(\\d+):(.*)$");
        private final Pattern TrackTitlePattern = Pattern.compile("^(\\d+):(.*)$");

        public TrackTitleOption() throws IllegalArgumentException {
            super(NAME, true, "New track title. This parameter may be specified multiple times, once per disc and track number. If the disc number is not specified it will default to 1. Parameter must be in the form " + usage);
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (values != null) {
                trackTitles.addAll(Arrays.asList(values));
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            if (!validated) {
                validated = true;
                HashSet<String> trackNumbers = new HashSet<String>();
                for (String trackTitle : trackTitles) {
                    boolean parameterBad = false;
                    Matcher matcher = this.VolumeTrackTitlePattern.matcher(trackTitle);
                    int discNumber = 1;
                    int groupIndex = 1;
                    if (matcher.matches()) {
                        try {
                            discNumber = Integer.parseInt(matcher.group(groupIndex++));
                        }
                        catch (NumberFormatException badDisc) {
                            parameterBad = true;
                        }
                    } else {
                        matcher = this.TrackTitlePattern.matcher(trackTitle);
                    }
                    if (!matcher.matches()) {
                        parameterBad = true;
                    } else {
                        try {
                            String key;
                            int trackNumber = Integer.parseInt(matcher.group(groupIndex++));
                            if (discNumber < 1 || trackNumber < 1) {
                                parameterBad = true;
                            }
                            if (trackNumbers.contains(key = discNumber + ":" + trackNumber)) {
                                throw new OptionValidationException("Only one title may be specified for each disc and track number.");
                            }
                            trackNumbers.add(key);
                        }
                        catch (NumberFormatException e) {
                            parameterBad = true;
                        }
                    }
                    if (!parameterBad) continue;
                    throw new OptionValidationException("trackTitle parameter must conform to pattern: " + usage);
                }
            }
        }
    }

    public static class TitleVersionOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = 47093622572079268L;
        static boolean validated = false;

        public TitleVersionOption(String opt) throws IllegalArgumentException {
            super(opt, true, "New title version.");
        }

        @Override
        public void process(CommandLine commandLine) {
            super.process(commandLine);
            String value = commandLine.getOptionValue(this.getOpt());
            if (value != null) {
                titleVersion = value;
            }
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            if (!validated) {
                validated = true;
                if (commandLine.getOptionValue("versionTitle") != null && commandLine.getOptionValue("titleVersion") != null) {
                    throw new OptionValidationException("Use either the -versionTitle or the -titleVersion option, but not both.");
                }
            }
        }
    }

    public static class PlaylistTitleTranslationOption
    extends BaseOption
    implements Validatable {
        private static final long serialVersionUID = -8157679789254108439L;
        private static String usage = "<lang>:<translation> where <lang> is one of 'english', 'japanese', 'native', 'phonetic', or 'phonetic_<locale code>'. Example: \"english:LoremIpsum\", or \"phonetic_ja:LoremIpsum\"";
        public static final String NAME = "playlistTitleTranslation";
        private final Pattern TitleTranslationPattern = Pattern.compile("^([^:]+):(.*)$");

        public PlaylistTitleTranslationOption() {
            super(NAME, true, "New playlist title translation. This argument may only be supplied once, and must be in the form " + usage);
        }

        @Override
        public void validate(CommandLine commandLine) throws OptionValidationException {
            String[] values = commandLine.getOptionValues(this.getOpt());
            if (null == values || values.length == 0) {
                return;
            }
            if (values.length > 1) {
                throw new OptionValidationException("Only one playlistTitleTranslation option may be specified.");
            }
            String value = values[0];
            if (value != null && value.length() > 0) {
                Matcher matcher = this.TitleTranslationPattern.matcher(value);
                if (matcher.matches()) {
                    String lang = matcher.group(1);
                    String translation = matcher.group(2);
                    if (null == translation || translation.trim().isEmpty()) {
                        throw new OptionValidationException(String.format("The playlist title translation cannot be empty for language: %s.", lang));
                    }
                    if (validLang.contains(lang)) {
                        return;
                    }
                    if (lang.toLowerCase().startsWith("phonetic_")) {
                        return;
                    }
                }
                throw new OptionValidationException("playlistTitleTranslation parameter must conform to pattern: " + usage);
            }
        }
    }
}

