/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.DestinationOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.util.TransportUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CreateAssetOnlyStubPackage
extends Operation {
    public static final String MODE_VALUE = "createAssetOnlyStubPackage";

    public CreateAssetOnlyStubPackage(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Performing createAssetOnlyStubPackage request ...");
        String vendorId = System.getProperty("vendor_identifier");
        try {
            Logger.info("Looking up the metadata for the video with vendor id " + vendorId + " ...");
            Map returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map invoke() {
                    return CreateAssetOnlyStubPackage.this.service.lookupVideoMetadataOperation(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to retrieve video's metadata.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while looking up the video's metadata.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            String xml = (String)returnValue.get(System.getProperty("generatedMetadataKey"));
            if (xml == null || xml.trim().length() == 0) {
                Logger.error("No metadata xml was returned by Apple's web service operation.");
                return false;
            }
            String destDirPath = null;
            try {
                destDirPath = TransportUtil.destinationPathFromProperty();
            }
            catch (Throwable t) {
                Logger.error("The specified destination path is not valid.", t);
                return false;
            }
            boolean didCreateStubPkg = false;
            try {
                didCreateStubPkg = TransportUtil.createStubPackageForMetadata(xml, vendorId, destDirPath);
            }
            catch (IOException ioe) {
                Logger.error("An error occurred while creating the stub package for the generated metadata.", ioe);
                didCreateStubPkg = false;
            }
            if (!didCreateStubPkg) {
                return false;
            }
            Logger.essential("\n\nThe stub package for video vendor id " + vendorId + " has been created.");
        }
        catch (Throwable t) {
            Logger.error("Error occurred while creating a stub package for a video with vendor id " + vendorId + ".", t);
            return false;
        }
        return true;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, true, includeHidden);
        VendorIdOption vendorIdOption = new VendorIdOption(VendorIdOption.Variant.VendorIdentifier);
        vendorIdOption.setRequired(true);
        options.addOption((Option)vendorIdOption);
        options.addOption((Option)new DestinationOption(DestinationOption.Variant.CreateAssetOnlyStubPackage));
        return options;
    }
}

