/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.ErrorMessageCollector;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.ColumnarOutputFormatter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.LookupArtist;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.ArtistNameOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.ExtendedOptions;
import com.apple.transporter.operation.option.ForceCreateTokenOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.LocaleOption;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.operation.option.ProviderNameOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Options;

public class CreateArtistOperation
extends Operation {
    public static final String MODE_VALUE = "createArtist";
    private static final String ARGUMENT__ARTIST_NAME_KEY = "ArtistName";
    private static final String ARGUMENT__ARTIST_TYPE_KEY = "ArtistType";
    private static final String ARGUMENT__NAME_FOR_SORTING_KEY = "NameForSorting";
    private static final String ARGUMENT__NATIVE_LOCALE_KEY = "NativeLocale";
    private static final String ARGUMENT__FORCE_OPERATION_TOKEN_KEY = "ForceOperationToken";
    private static final String RESULT__FORCE_OPERATION_TOKEN_KEY = "ForceOperationToken";

    public CreateArtistOperation(WebService service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String forceCreateToken;
        String nativeLocale;
        Logger.info("CreateArtist mode selected.");
        ErrorMessageCollector.sharedInstance().setupToCollectErrorMessagesForNonPackageBasedModes();
        final HashMap<String, String> args = new HashMap<String, String>();
        String artistName = ArtistNameOption.artistName();
        if (null != artistName && artistName.length() > 0) {
            args.put(ARGUMENT__ARTIST_NAME_KEY, artistName);
        }
        args.put(ARGUMENT__ARTIST_TYPE_KEY, ArtistType.ARTIST.artistTypeName);
        String nameForSorting = System.getProperty("nameForSorting");
        if (null != nameForSorting && nameForSorting.length() > 0) {
            args.put(ARGUMENT__NAME_FOR_SORTING_KEY, nameForSorting);
        }
        if (null != (nativeLocale = System.getProperty("nativeLocale")) && nativeLocale.length() > 0) {
            args.put(ARGUMENT__NATIVE_LOCALE_KEY, nativeLocale);
        }
        if (null != (forceCreateToken = ForceCreateTokenOption.getTokenValue()) && forceCreateToken.length() > 0) {
            args.put("ForceOperationToken", forceCreateToken);
        }
        Map<String, Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Map<String, Object> invoke() {
                return CreateArtistOperation.this.service.createArtistOperation(Application.shouldHidePassword(), args);
            }
        });
        boolean wasSuccessful = false;
        try {
            ArrayList<Map<String, Object>> artists;
            if (null == returnValue) {
                Application.logUnnecessaryError("Unable to create the artist.");
                boolean bl = wasSuccessful;
                return bl;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while creating the artist.");
                Application.displaySOAPErrorMessages(returnValue);
                boolean bl = wasSuccessful;
                return bl;
            }
            String forceOperationToken = (String)returnValue.get("ForceOperationToken");
            boolean artistCreated = false;
            Map artist = (Map)returnValue.get("ArtistCreationResult");
            if (null != artist) {
                artistCreated = true;
                artists = new ArrayList<Map>();
                artists.add(artist);
            } else {
                Object[] results = (Object[])returnValue.get("SearchResults");
                if (null == results) {
                    boolean bl = wasSuccessful;
                    return bl;
                }
                List<Object> resultsList = Arrays.asList(results);
                artists = resultsList;
            }
            Logger.essential(" ");
            if (artistCreated) {
                Logger.essential("Artist created:");
            }
            if (Application.shouldGenerateXML()) {
                wasSuccessful = LookupArtist.ArtistXMLOutputFormatter.processArtists(artists);
            } else {
                ColumnarOutputFormatter formatter = new ColumnarOutputFormatter(LookupArtist.getColumns(), 5);
                if (!artistCreated) {
                    if (null != forceOperationToken && forceOperationToken.length() > 0) {
                        Logger.essential(String.format("Artist not created, to force the artist to be created use the option -forceCreateToken \"%s\"", forceOperationToken));
                        Logger.essential("Listing existing artists: ");
                    } else {
                        Logger.essential("Artist not created listing existing artists:");
                    }
                }
                wasSuccessful = formatter.processRows(artists);
                if (artists.isEmpty()) {
                    Logger.essential("zero results found");
                }
                Logger.essential(" ");
            }
        }
        finally {
            if (!wasSuccessful) {
                Application.showNonPackageBasedErrorSummary();
            }
        }
        return wasSuccessful;
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        ExtendedOptions options = new ExtendedOptions("", this.getHelpTextFooter());
        OptionHelper.addUsernameAndPasswordAuthenticationOptions(options, true, includeHidden);
        options.addOption(new ItcProviderNameOption().setRequiredFluently(false));
        options.addOption(new ProviderNameOption(ProviderNameOption.Variant.Short).setRequiredFluently(false));
        options.addOption(new ArtistNameOption().setMaxArgumentValues(1));
        options.addOption(new LocaleOption("nativeLocale", "The artist's native locale.").setRequiredFluently(true).setMaxArgumentValues(1));
        options.addOption(new BaseOption("nameForSorting", true, "The artist's name for sorting purposes.").setRequiredFluently(false).setMaxArgumentValues(1));
        options.addOption(new ForceCreateTokenOption().setMaxArgumentValues(1));
        if (includeHidden) {
            options.addOption(new OutputFormatOption().setRequiredFluently(false));
        }
        return options;
    }

    private String getHelpTextFooter() {
        return System.getProperty("line.separator") + "The following parameters must be supplied in this mode: " + "n" + " and nativeLocale." + System.getProperty("line.separator") + "The following parameters are optional for this mode: forceCreateToken and nameForSorting.";
    }

    @Override
    public boolean shouldExitIfUnsupportedOptionFound() {
        return true;
    }

    @Override
    public boolean shouldExitIfLeftoverArgumentsExist() {
        return true;
    }

    public static enum ArtistType {
        ARTIST("Artist", 1),
        TV_SHOW("TV Show", 2),
        STUDIO("Studio", 3),
        PODCAST("Podcast", "Podcast Artist", 4),
        AUTHOR("Author", 5),
        MOVIE("Movie", "Movie Artist", 6),
        SOFTWARE("Software", "Software Artist", 7),
        ITUNES_U("iTunes U", "iTunes U Artist", 8);

        final String displayName;
        final String artistTypeName;
        final int typeId;

        private ArtistType(String displayName, String artistTypeName, int typeId) {
            this.displayName = displayName;
            this.artistTypeName = artistTypeName;
            this.typeId = typeId;
        }

        private ArtistType(String displayName, int typeId) {
            this(displayName, displayName, typeId);
        }

        public static ArtistType of(String value) {
            for (ArtistType at : ArtistType.values()) {
                if (at.displayName.equalsIgnoreCase(value)) {
                    return at;
                }
                if (at.artistTypeName.equalsIgnoreCase(value)) {
                    return at;
                }
                if (!at.name().equalsIgnoreCase(value)) continue;
                return at;
            }
            return null;
        }
    }
}

