/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.WebService;
import com.apple.transporter.operation.Operation;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public abstract class CompositeOperation
extends Operation {
    protected Operation[] operations;

    public CompositeOperation(WebService service, Operation ... operations) {
        super(service);
        if (operations == null || operations.length == 0) {
            throw new IllegalArgumentException("operations list cannot be null or empty");
        }
        this.operations = operations;
    }

    @Override
    public boolean execute() {
        boolean result = true;
        for (Operation operation : this.operations) {
            this.preExecuteHook(operation);
            result = operation.execute();
            this.postExecuteHook(operation);
            if (!result) break;
        }
        return result;
    }

    public void preExecuteHook(Operation operation) {
    }

    public void postExecuteHook(Operation operation) {
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        return this.getOptionsWithFilter(includeHidden, modeValue, null);
    }

    Options getOptionsWithFilter(boolean includeHidden, String modeValue, List<String> filterOut) {
        Options options = new Options();
        for (Operation operation : this.operations) {
            Options subOptions = operation.getOptions(includeHidden, modeValue);
            for (Object o : subOptions.getOptions()) {
                if (o instanceof Option) {
                    if (filterOut != null && filterOut.contains(((Option)o).getOpt())) continue;
                    options.addOption((Option)o);
                    continue;
                }
                if (o instanceof OptionGroup) {
                    options.addOptionGroup((OptionGroup)o);
                    continue;
                }
                throw new IllegalArgumentException("Unknown option class: " + o.getClass());
            }
        }
        return options;
    }
}

