/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.OptionHelper;
import com.apple.transporter.operation.option.OutputFormatOption;
import com.apple.transporter.util.XMLUtil;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class AuthenticatePurpleProvider
extends Operation {
    private static final String ARGUMENT_DICT__PROVIDER_NAME_KEY = "ProviderName";

    public AuthenticatePurpleProvider(WebService service) {
        super(service);
    }

    @Override
    public boolean execute() {
        Logger.info("Performing purple authentication ...");
        try {
            Map<String, ? extends Object> returnValue = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, ? extends Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, ? extends Object> invoke() {
                    return AuthenticatePurpleProvider.this.service.authenticatePurpleProvider(Application.shouldHidePassword());
                }
            });
            if (returnValue == null) {
                Application.logUnnecessaryError("Unable to authenticate purple provider.");
                return false;
            }
            if (Application.doesContainSOAPError(returnValue)) {
                Application.logUnnecessaryError("An error occurred while authenticating purple provider.");
                Application.displaySOAPErrorMessages(returnValue);
                return false;
            }
            this.displayReturnValue(returnValue, Application.XMLStream);
        }
        catch (Throwable t) {
            Logger.error("Error occurred while authenticating purple provider.", t);
            return false;
        }
        return true;
    }

    private void displayReturnValue(Map<String, ? extends Object> returnValue, PrintStream printStream) {
        String providerShortName = (String)returnValue.get(ARGUMENT_DICT__PROVIDER_NAME_KEY);
        if (Application.shouldGenerateXML()) {
            this.generateXML(providerShortName, printStream);
        } else {
            this.generateRegularOutput(providerShortName, printStream);
        }
    }

    private void generateRegularOutput(String providerShortName, PrintStream printStream) {
        printStream.println("Provider short name: " + providerShortName);
    }

    private void generateXML(String providerShortName, PrintStream printStream) {
        XMLUtil.XMLTag tag = new XMLUtil.XMLTag("authenticate_purple_provider", 1);
        tag.addChildTag("short_name").setText(providerShortName);
        printStream.print(tag.marshall());
    }

    @Override
    public Options getOptions(boolean includeHidden, String modeValue) {
        Options options = new Options();
        OptionHelper.addAuthenticationOptions(options, false, includeHidden);
        if (includeHidden) {
            options.addOption((Option)new OutputFormatOption());
        }
        return options;
    }
}

