/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.operation;

import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.PackageFolderExistsException;
import com.apple.transporter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public abstract class AbstractPackageGenerationOperation
extends Operation {
    protected AbstractPackageGenerationOperation(WebService service) {
        super(service);
    }

    protected String getProviderName() {
        String provider = System.getProperty("provider");
        if (provider == null || provider.length() == 0) {
            provider = System.getProperty("s");
        }
        return provider;
    }

    protected File getAssetFolder() throws IOException {
        String sourceFolder = System.getProperty("assetFolder");
        if (sourceFolder != null) {
            sourceFolder = FileUtil.absolutePathForPath(sourceFolder);
            File sourceFolderFile = new File(sourceFolder);
            return sourceFolderFile;
        }
        return null;
    }

    protected File getDestinationFolder() throws IOException {
        String dest = System.getProperty("destination");
        if (dest != null) {
            File destFile = new File(dest = FileUtil.absolutePathForPath(dest));
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            if (!destFile.exists()) {
                throw new RuntimeException("Could not create destination folder, please verify path.");
            }
            return destFile;
        }
        return null;
    }

    protected String extractExtension(String fileName) {
        int extensionStart = fileName.lastIndexOf(".");
        if (extensionStart != -1 && extensionStart < fileName.length() - 1) {
            String extension = fileName.substring(++extensionStart);
            extension = extension.toLowerCase();
            return extension;
        }
        return null;
    }

    protected void makePackage(String vendorId, String metadata, Collection<File> files) throws IOException, PackageFolderExistsException {
        File packageFolder = new File(this.getDestinationFolder(), vendorId + ".itmsp");
        Logger.debug("Using package folder path " + packageFolder.getPath());
        if (packageFolder.exists()) {
            Logger.error("Package folder path already exists!  Existing package will not be overwritten; aborting.");
            throw new PackageFolderExistsException();
        }
        packageFolder.mkdirs();
        if (metadata != null) {
            File metadataFile = new File(packageFolder, "metadata.xml");
            Logger.debug("Saving metadata to " + metadataFile.getPath());
            FileUtils.writeStringToFile((File)metadataFile, (String)metadata);
        }
        if (files != null) {
            for (File source : files) {
                FileUtils.copyFile((File)source, (File)new File(packageFolder, source.getName()), (boolean)false);
            }
        }
    }
}

