/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.model;

import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.webdav.ChunkedFileSource;
import com.apple.transporter.util.ConfigurationUtil;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.ProcUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.FileEntity;

public class TransferTestITMSPackage
extends ITMSPackage {
    private static final String DEFAULT_TEST_ASSET_NAME = "song01.m4a";
    private static final String DEFAULT_TEST_ASSET_SIZE = "10m";
    private static final String TEMPLATE_METADATA_XML = "transferTest-template.metadata.xml";
    private static final String REMOTE_TEMPLATE_METADATA_XML = "transferTest-template-v2.metadata.xml";
    private long assetSize = 0L;
    private Random rand = new Random();
    protected String vendorId;

    public static String generatePackagePath() {
        String provider = TransferTestITMSPackage.getProviderName();
        String packagePath = FileUtil.tempDir().getAbsolutePath() + File.separator + "itms_test_packages" + File.separator + (provider + UUID.randomUUID().toString().replaceAll("-", "")).toUpperCase() + ".itmsp";
        return packagePath;
    }

    private static String getProviderName() {
        String provider = System.getProperty("s");
        if (provider == null) {
            provider = System.getProperty("itc_provider");
        }
        if (provider == null) {
            provider = "iTunesProducer";
        }
        return provider;
    }

    public TransferTestITMSPackage(File packagePath) throws IOException {
        this.packageFile = packagePath;
        this.packageFile.deleteOnExit();
        String absolutePath = this.packageFile.getAbsolutePath();
        this.vendorId = absolutePath.substring(absolutePath.lastIndexOf(File.separator) + 1, absolutePath.lastIndexOf(".itmsp"));
        this.setupPackageFiles();
    }

    @Override
    public void reset() {
        List<TransportType> transports = TransportUtil.getTransportTypes(null);
        if (transports.contains((Object)TransportType.Aspera) || transports.contains((Object)TransportType.Signiant)) {
            File assetFile = new File(this.packageFile.getAbsolutePath() + File.separator + DEFAULT_TEST_ASSET_NAME);
            this.createAssetFifo(assetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPackageFiles() throws IOException {
        String metadata;
        this.packageFile.mkdirs();
        this.packageFiles = new ArrayList();
        File metadataFile = new File(this.packageFile.getAbsolutePath() + File.separator + "metadata.xml");
        metadataFile.deleteOnExit();
        this.packageFiles.add(metadataFile);
        File assetFile = new File(this.packageFile.getAbsolutePath() + File.separator + DEFAULT_TEST_ASSET_NAME);
        assetFile.deleteOnExit();
        this.packageFiles.add(assetFile);
        File coverImageFile = new File(this.packageFile.getAbsolutePath() + File.separator + "cover.png");
        coverImageFile.deleteOnExit();
        this.packageFiles.add(coverImageFile);
        try {
            this.assetSize = TransportUtil.sizeSpecToLong(System.getProperty("size"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.assetSize <= 0L) {
            this.assetSize = TransportUtil.sizeSpecToLong(DEFAULT_TEST_ASSET_SIZE);
        }
        try (InputStream templateStream = null;){
            templateStream = ConfigurationUtil.getConfigurationFileStream("https://contentdelivery.itunes.apple.com/transporter/transferTest-template-v2.metadata.xml", TEMPLATE_METADATA_XML);
            metadata = new String(IOUtils.toByteArray((InputStream)templateStream));
        }
        metadata = metadata.replaceAll("\\$PROVIDER\\$", TransferTestITMSPackage.getProviderName());
        metadata = metadata.replaceAll("\\$DATE\\$", String.format("%1$tY-%1$tm-%1$td", new Date()));
        metadata = metadata.replaceAll("\\$VENDOR_ID\\$", this.vendorId);
        metadata = metadata.replaceAll("\\$ASSET_NAME\\$", DEFAULT_TEST_ASSET_NAME);
        metadata = metadata.replaceAll("\\$UPC\\$", TransferTestITMSPackage.generateUPC12());
        metadata = metadata.replaceAll("\\$ISRC\\$", this.randomIsrc());
        metadata = metadata.replaceAll("\\$SIZE\\$", String.valueOf(this.assetSize));
        FileOutputStream fos = new FileOutputStream(metadataFile);
        fos.write(metadata.getBytes("UTF-8"));
        fos.close();
        InputStream coverStream = StreamUtil.getResourceAsStream("cover.png");
        fos = new FileOutputStream(coverImageFile);
        IOUtils.copy((InputStream)coverStream, (OutputStream)fos);
        fos.close();
        List<TransportType> transports = TransportUtil.getTransportTypes(null);
        if (transports.contains((Object)TransportType.Aspera) || transports.contains((Object)TransportType.Signiant)) {
            this.createAssetFifo(assetFile);
        } else {
            assetFile.createNewFile();
        }
    }

    private String randomIsrc() {
        String isrcChars = UUID.randomUUID().toString().replaceAll("-", "").substring(0, 5);
        String isrcDigits = String.format("%07d", Math.abs(new Random().nextInt())).substring(0, 7);
        return isrcChars + isrcDigits;
    }

    private void createAssetFifo(final File assetFile) {
        ProcUtil.executeProcess("mkfifo", assetFile.getAbsolutePath());
        final long finalSize = this.assetSize;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Random rand = new Random();
                FileOutputStream fos = null;
                try {
                    int bytesToWrite;
                    byte[] buf = new byte[4096];
                    fos = new FileOutputStream(assetFile);
                    for (long bytesWritten = 0L; bytesWritten < finalSize; bytesWritten += (long)bytesToWrite) {
                        rand.nextBytes(buf);
                        bytesToWrite = (int)Math.min(finalSize - bytesWritten, (long)buf.length);
                        try {
                            fos.write(buf, 0, bytesToWrite);
                            continue;
                        }
                        catch (IOException e) {
                            if ("Broken pipe".equalsIgnoreCase(e.getMessage())) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            throw e;
                        }
                    }
                }
                catch (IOException e) {
                    Logger.debug("Exception writing to named pipe", e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            Logger.debug("Exception closing named pipe", e);
                        }
                    }
                }
            }
        });
        thread.setName("transporter.TransferTestITMSPackageRandomByteWriter");
        thread.start();
    }

    private static String generateUPC12() {
        String upc12 = String.format("%1$012d", new Random().nextInt(Integer.MAX_VALUE));
        int checkDigit = TransferTestITMSPackage.checkDigitForUPC12(upc12);
        return upc12.substring(0, 11) + checkDigit;
    }

    private static int checkDigitForUPC12(String upc) {
        int step3;
        int i1 = TransferTestITMSPackage.intAtIndexOfUPC(0, upc);
        int i2 = TransferTestITMSPackage.intAtIndexOfUPC(1, upc);
        int i3 = TransferTestITMSPackage.intAtIndexOfUPC(2, upc);
        int i4 = TransferTestITMSPackage.intAtIndexOfUPC(3, upc);
        int i5 = TransferTestITMSPackage.intAtIndexOfUPC(4, upc);
        int i6 = TransferTestITMSPackage.intAtIndexOfUPC(5, upc);
        int i7 = TransferTestITMSPackage.intAtIndexOfUPC(6, upc);
        int i8 = TransferTestITMSPackage.intAtIndexOfUPC(7, upc);
        int i9 = TransferTestITMSPackage.intAtIndexOfUPC(8, upc);
        int i10 = TransferTestITMSPackage.intAtIndexOfUPC(9, upc);
        int i11 = TransferTestITMSPackage.intAtIndexOfUPC(10, upc);
        int step1 = i1 + i3 + i5 + i7 + i9 + i11;
        int step2 = step1 * 3;
        int step4 = step2 + (step3 = i2 + i4 + i6 + i8 + i10);
        int modulo10 = step4 % 10;
        int expectedResult = 10 - modulo10;
        if (expectedResult == 10) {
            expectedResult = 0;
        }
        return expectedResult;
    }

    private static int intAtIndexOfUPC(int index, String upc) {
        if (index >= upc.length()) {
            return -1;
        }
        char digit = upc.charAt(index);
        int digitInt = Integer.parseInt(String.valueOf(digit));
        return digitInt;
    }

    @Override
    public List<File> allPackageFiles() {
        return this.packageFiles;
    }

    @Override
    public boolean validateFileChecksums(Map remoteChecksums, Number minimumChecksumSize, boolean checksumCompletedBefore, Map fileLastModified, WebService service) {
        return true;
    }

    @Override
    public long getFileSize(File file) {
        if (file.getName().equals(DEFAULT_TEST_ASSET_NAME)) {
            return this.assetSize;
        }
        return super.getFileSize(file);
    }

    @Override
    public boolean supportsAssetDescription() {
        return false;
    }

    @Override
    public boolean supportsFileSizeCheck() {
        return false;
    }

    @Override
    public HttpEntity getDavHttpEntityForFile(File oneFileInPkg) {
        if (!oneFileInPkg.getName().equals(DEFAULT_TEST_ASSET_NAME)) {
            return new FileEntity(oneFileInPkg);
        }
        return new AbstractHttpEntity(){

            public InputStream getContent() {
                return new InputStream(){
                    Random rand = new Random();
                    long bytesWritten = 0L;

                    @Override
                    public int read() throws IOException {
                        if (this.bytesWritten < TransferTestITMSPackage.this.assetSize) {
                            byte[] resp = new byte[1];
                            this.rand.nextBytes(resp);
                            return resp[0] & 0xFF;
                        }
                        return -1;
                    }
                };
            }

            public long getContentLength() {
                return TransferTestITMSPackage.this.assetSize;
            }

            public boolean isRepeatable() {
                return true;
            }

            public boolean isStreaming() {
                return false;
            }

            public void writeTo(OutputStream out) throws IOException {
                int bytesToWrite;
                byte[] buf = new byte[4096];
                for (long bytesWritten = 0L; bytesWritten < TransferTestITMSPackage.this.assetSize; bytesWritten += (long)bytesToWrite) {
                    TransferTestITMSPackage.this.rand.nextBytes(buf);
                    bytesToWrite = (int)Math.min(TransferTestITMSPackage.this.assetSize - bytesWritten, (long)buf.length);
                    out.write(buf, 0, bytesToWrite);
                }
            }
        };
    }

    @Override
    public ChunkedFileSource chunkedFileSource(File oneFileInPkg) {
        return new ChunkedFileSource(){

            @Override
            public void seek(long location) throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public long length() throws IOException {
                return TransferTestITMSPackage.this.assetSize;
            }

            @Override
            public void readFully(byte[] data) throws IOException {
                TransferTestITMSPackage.this.rand.nextBytes(data);
            }
        };
    }
}

