/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.model;

import com.apple.transporter.CompareFilesBySizesAndPaths;
import com.apple.transporter.TimeCode;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.SilentErrorReporter;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.webdav.ChunkedFileSource;
import com.apple.transporter.transport.webdav.RandomAccessFileSource;
import com.apple.transporter.util.FileChunkUtil;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ITMSPackage {
    public static final String DEFAULT_METADATA_FILE_NAME = "metadata.xml";
    public static final String DEFAULT_CHAPTERS_FILE_NAME = "chapters.xml";
    private static final List<String> compressionExtensions = new ArrayList<String>();
    private static List<String> gzippedExtensions = new ArrayList<String>();
    private static List<String> ignoredFileNames = new ArrayList<String>();
    private static List<String> encryptedExtensions = new ArrayList<String>();
    private static List<String> infoExtensions = new ArrayList<String>();
    protected static final String FILENAME_KEY = "Filename";
    protected static final String FILE_SIZE_KEY = "FileSize";
    protected static final String CLIENT_CHECKSUM_CALCULATED_CHECKSUM_KEY = "CalculatedChecksum";
    protected static final String CLIENT_CHECKSUM_CALCULATION_TIME_KEY = "CalculationTime";
    protected static final String CLIENT_CHECKSUM_FILE_LAST_MODIFIED_KEY = "FileLastModified";
    protected File packageFile;
    private String metadataCaseSensitiveFileName;
    private String metadataFileContents;
    private String metadataFileChecksum;
    private List<String> metadataChapterImages;
    protected List<File> packageFiles;
    private boolean haveOutdatedFilesBeenDeleted;
    private List<File> filesRequestedByApple;
    private String chaptersCaseSensitiveFileName;
    private String chaptersFileContents;
    private XmlObject chaptersDomXmlObject;
    private String newPackageName;
    private Collection checksumInfo;

    protected ITMSPackage() {
    }

    public ITMSPackage(File pkg) throws IOException {
        if (pkg == null) {
            String msg = "A File for the package must be specified.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        if (!ITMSPackage.isValidITMSPackageName(pkg.getName())) {
            String msg = pkg.getName() + " is NOT a valid package name.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        if (!pkg.exists()) {
            String msg = pkg.getPath() + " does NOT exist.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        if (!pkg.canRead()) {
            String msg = pkg.getPath() + " is NOT readable.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        if (!pkg.isDirectory()) {
            String msg = pkg.getPath() + " must be a directory which contains files to be uploaded.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        if (pkg.listFiles() == null) {
            String msg = pkg.getPath() + " must contain files in it that need to be uploaded.";
            Logger.error(msg);
            throw new IOException(msg);
        }
        this.packageFile = pkg;
        this.haveOutdatedFilesBeenDeleted = false;
    }

    public static List<File> validItmspFilesForDirectoryPath(String aDirPath) {
        ArrayList<File> result = new ArrayList<File>();
        if (aDirPath == null || aDirPath.trim().length() == 0) {
            return null;
        }
        File aDir = new File(aDirPath);
        if (!aDir.exists()) {
            Logger.error(aDirPath + " does NOT exist.");
            return null;
        }
        if (!aDir.isDirectory()) {
            Logger.error(aDirPath + " is NOT a directory.");
            return null;
        }
        if (!aDir.canRead()) {
            Logger.error(aDirPath + " does NOT have read access.");
            return null;
        }
        if (ITMSPackage.isValidITMSPackageName(aDir.getName())) {
            result.add(aDir);
            return result;
        }
        File[] filesArray = aDir.listFiles();
        if (filesArray == null) {
            return null;
        }
        for (File aFile : filesArray) {
            if (ITMSPackage.isValidITMSPackageName(aFile.getName())) {
                result.add(aFile);
                continue;
            }
            Logger.debug("Ignoring file: " + aFile.getPath() + " because it is NOT an iTMS package.");
        }
        if (result.size() == 0) {
            Logger.error("The directory: " + aDir.getPath() + " does NOT have any valid iTMS packages.");
        }
        return result;
    }

    public static List<File> invalidItmspFilesForDirectoryPath(String aDirPath) {
        ArrayList<File> result = new ArrayList<File>();
        if (aDirPath == null || aDirPath.trim().length() == 0) {
            return null;
        }
        File aDir = new File(aDirPath);
        if (!aDir.exists()) {
            Logger.error(aDirPath + " does NOT exist. CANNOT check for invalid packages within it.");
            return null;
        }
        if (!aDir.isDirectory()) {
            Logger.error(aDirPath + " is NOT a directory. CANNOT check for invalid packages within it.");
            return null;
        }
        if (!aDir.canRead()) {
            Logger.error(aDirPath + " does NOT have read access. CANNOT check for invalid packages within it.");
            return null;
        }
        if (ITMSPackage.isValidITMSPackageName(aDir.getName())) {
            return null;
        }
        File[] itmspFilesArray = aDir.listFiles();
        if (itmspFilesArray == null) {
            return null;
        }
        List<File> validItmspFilesList = ITMSPackage.validItmspFilesForDirectoryPath(aDirPath);
        for (File aItmspFile : itmspFilesArray) {
            if (validItmspFilesList.contains(aItmspFile) || aItmspFile.getName().indexOf(46) == 0) continue;
            result.add(aItmspFile);
        }
        return result;
    }

    public static boolean isValidITMSPackageName(String aName) {
        if (aName == null || aName.trim().length() == 0) {
            return false;
        }
        String extension = NSPathUtilities.pathExtension(aName);
        return extension != null && extension.equals("itmsp");
    }

    public String metadataFileNameLowerCased() {
        String fileName = this.metadataFileName();
        if (fileName == null) {
            return null;
        }
        return fileName.toLowerCase();
    }

    public String metadataFileName() {
        if (this.metadataCaseSensitiveFileName != null) {
            return this.metadataCaseSensitiveFileName;
        }
        Logger.debug("Getting case-sensitive metadata xml filename...");
        if (this.metadataCaseSensitiveFileName == null || this.metadataCaseSensitiveFileName.length() == 0) {
            this.metadataCaseSensitiveFileName = this.caseSensitiveFileNameForFileName(DEFAULT_METADATA_FILE_NAME);
        }
        Logger.debug("  Case-sensitive metadata filename is: " + this.metadataCaseSensitiveFileName);
        return this.metadataCaseSensitiveFileName;
    }

    public String metadataFileContents() {
        if (this.metadataFileContents != null) {
            return this.metadataFileContents;
        }
        this.metadataFileContents = this.fileContentsForFileName(this.metadataFileName());
        return this.metadataFileContents;
    }

    public String metadataFileChecksum() {
        if (this.metadataFileChecksum != null) {
            return this.metadataFileChecksum;
        }
        if (this.metadataFileContents() == null || this.metadataFileContents().trim().length() == 0) {
            return null;
        }
        try {
            this.metadataFileChecksum = StringUtil.byteArrayToHexString(FileUtil.md5(new ByteArrayInputStream(this.metadataFileContents().getBytes("utf-8"))));
        }
        catch (Exception e) {
            Logger.warn("Failed to md5 metadata.xml", e);
        }
        return this.metadataFileChecksum;
    }

    public boolean metadataFileHasChanged() {
        String currentMetadataFileChecksum;
        String currentMetadataFileContents = this.fileContentsForFileName(this.metadataFileName());
        if (currentMetadataFileContents == null || currentMetadataFileContents.trim().length() == 0) {
            return this.metadataFileContents() != null && this.metadataFileContents().trim().length() != 0;
        }
        try {
            currentMetadataFileChecksum = StringUtil.byteArrayToHexString(FileUtil.md5(new ByteArrayInputStream(currentMetadataFileContents.getBytes("utf-8"))));
        }
        catch (Exception e) {
            Logger.warn("Failed to md5 metadata.xml", e);
            return !this.metadataFileContents().equalsIgnoreCase(currentMetadataFileContents);
        }
        if (currentMetadataFileChecksum == null || currentMetadataFileChecksum.trim().length() == 0) {
            return this.metadataFileChecksum() != null && this.metadataFileChecksum().trim().length() != 0;
        }
        return !this.metadataFileChecksum().equalsIgnoreCase(currentMetadataFileChecksum);
    }

    public boolean isMetadataWellFormed() {
        String metadataString = this.metadataFileContents();
        if (metadataString == null || metadataString.length() == 0) {
            Logger.error("  The metadata.xml file in " + this.packageNameWithPath() + " doesn't exist or is empty.");
            return false;
        }
        if (!this.isMetadataFilenameProperlyCased()) {
            Logger.error("  The XML file: " + this.metadataFileName() + " in " + this.packageNameWithPath() + " is NOT properly cased.  It needs to be all lower case.");
            return false;
        }
        return this.isXMLWellFormed(this.metadataFileName());
    }

    public String chaptersFileName() {
        if (this.chaptersCaseSensitiveFileName != null) {
            return this.chaptersCaseSensitiveFileName;
        }
        Logger.debug("Getting case-sensitive chapters xml filename...");
        String chaptersFileName = this.chaptersFileNameFromMetadata();
        if (chaptersFileName != null) {
            this.chaptersCaseSensitiveFileName = this.caseSensitiveFileNameForFileName(chaptersFileName);
        }
        Logger.debug("  Case-sensitive chapters filename is: " + this.chaptersCaseSensitiveFileName);
        return this.chaptersCaseSensitiveFileName;
    }

    public String chaptersFileContents() {
        if (this.chaptersFileContents != null) {
            return this.chaptersFileContents;
        }
        this.chaptersFileContents = this.fileContentsForFileName(this.chaptersFileName());
        return this.chaptersFileContents;
    }

    public boolean isChaptersFileWellFormed() {
        return this.isXMLWellFormed(this.chaptersFileName());
    }

    private boolean isMetadataFilenameCaseCheckDisabled() {
        String disabled = System.getProperty("DisableMetadataCaseCheck");
        if (disabled != null) {
            boolean isOff = false;
            try {
                isOff = Boolean.valueOf(disabled);
            }
            catch (Exception e) {
                isOff = false;
            }
            if (isOff) {
                return true;
            }
        }
        return false;
    }

    private boolean isMetadataFilenameProperlyCased() {
        if (this.isMetadataFilenameCaseCheckDisabled()) {
            return true;
        }
        String filename = this.metadataFileName();
        String lowercaseFilename = this.metadataFileNameLowerCased();
        if (filename == null || lowercaseFilename == null) {
            return true;
        }
        if (filename.equals(lowercaseFilename)) {
            return true;
        }
        String lowercaseSource = filename.toLowerCase();
        return !lowercaseSource.equals(lowercaseFilename);
    }

    public String packageName() {
        return this.packageFile.getName();
    }

    public String packageNameWithPath() {
        return this.packageFile.getPath();
    }

    public String newPackageName() {
        return this.newPackageName;
    }

    public void setNewPackageName(String newPackageName) {
        this.newPackageName = newPackageName;
    }

    public List<File> allPackageFiles() {
        if (this.packageFiles != null) {
            return this.packageFiles;
        }
        File[] tempFilesArray = this.packageFile.listFiles();
        Logger.info("Gathering the list of valid files from the package ...");
        ArrayList<File> tempArray = new ArrayList<File>();
        for (File oneFileInPkg : tempFilesArray) {
            String lowerCaseFileName;
            String fileExtension = NSPathUtilities.pathExtension(oneFileInPkg.getName()).toLowerCase();
            if (fileExtension == null) {
                fileExtension = "";
            }
            if ((lowerCaseFileName = oneFileInPkg.getName().toLowerCase()) == null) {
                lowerCaseFileName = "";
            }
            String fileName = oneFileInPkg.getName();
            if (oneFileInPkg.getName().indexOf(46) == 0) {
                Logger.info("  " + fileName + " will be ignored.");
                continue;
            }
            if (encryptedExtensions.contains(fileExtension) || compressionExtensions.contains(fileExtension) || infoExtensions.contains(fileExtension)) {
                Logger.debug("  " + fileName + " is a compression or encryption related filetype; NOT added to the valid files list");
                continue;
            }
            if (ignoredFileNames.contains(lowerCaseFileName)) {
                Logger.debug("  " + fileName + " is an ignored filetype; NOT added to the valid files list");
                continue;
            }
            Logger.debug("  " + fileName + " will be verified by Apple's web service to determine if it is a valid file.");
            tempArray.add(oneFileInPkg);
        }
        this.packageFiles = tempArray;
        Logger.info("Finished gathering the list of valid files from the package.");
        return this.packageFiles;
    }

    public List<File> filesRequestedByApple() {
        return this.filesRequestedByApple;
    }

    public List<String> filesRequestedByAppleCanonicalPaths() {
        ArrayList<String> results = new ArrayList<String>();
        List<File> files = this.filesRequestedByApple();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (file == null) continue;
            try {
                results.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                Logger.warn("Unable to obtain canonical path for package file " + file.getPath());
                results.add(file.getAbsolutePath());
            }
        }
        return results;
    }

    public boolean setFilesRequestedByApple(List<String> fileNamesToUpload) {
        if (fileNamesToUpload != null) {
            ArrayList<File> filesToUpload = new ArrayList<File>();
            String packagePath = this.packageNameWithPath();
            for (String aFileName : fileNamesToUpload) {
                String fullFileName = NSPathUtilities.stringByAppendingPathComponent(packagePath, aFileName);
                File aFileToUpload = new File(fullFileName);
                if (aFileToUpload.exists()) {
                    filesToUpload.add(aFileToUpload);
                    continue;
                }
                Logger.error("The file " + aFileName + " is from the list of files requested by Apple, but it was not found locally.");
                return false;
            }
            this.filesRequestedByApple = filesToUpload;
            Logger.info("The list of files requested for upload by Apple is: " + fileNamesToUpload + ".  These are the files that will be uploaded.");
        } else {
            this.filesRequestedByApple = null;
        }
        return true;
    }

    private List<File> packageFilesToUse() {
        if (this.filesRequestedByApple() == null) {
            return this.allPackageFiles();
        }
        return this.filesRequestedByApple();
    }

    private boolean doesCompressedFileExistForFile(File aFile) {
        if (aFile == null) {
            return false;
        }
        File compressedFile = this.existingCompressedFileForFile(aFile);
        return compressedFile != null && compressedFile.exists();
    }

    public boolean doAnyEncryptionRelatedFilesExistForFile(File aFile) {
        if (aFile == null) {
            return false;
        }
        List<File> encryptionRelatedFiles = this.existingEncryptionRelatedFilesForFile(aFile);
        return encryptionRelatedFiles != null && encryptionRelatedFiles.size() > 0;
    }

    private void removeOutdatedLocalFiles(List<File> validLocalFiles, TransportType transportType) {
        if (this.haveOutdatedFilesBeenDeleted) {
            return;
        }
        this.haveOutdatedFilesBeenDeleted = true;
        Logger.info("Checking if any encryption/compression files are outdated locally ...");
        for (File oneLocalFile : validLocalFiles) {
            Logger.debug("  checking file: " + oneLocalFile.getName());
            boolean shouldEncrtypedFilesBeDeleted = false;
            if (this.doesCompressedFileExistForFile(oneLocalFile)) {
                File compressedFile = this.existingCompressedFileForFile(oneLocalFile);
                compressedFile.delete();
                if (this.doAnyEncryptionRelatedFilesExistForFile(oneLocalFile)) {
                    shouldEncrtypedFilesBeDeleted = true;
                }
            }
            if (this.doAnyEncryptionRelatedFilesExistForFile(oneLocalFile)) {
                shouldEncrtypedFilesBeDeleted = true;
            }
            if (!shouldEncrtypedFilesBeDeleted) continue;
            List<File> encryptedFiles = this.existingEncryptionRelatedFilesForFile(oneLocalFile);
            for (File oneEncryptedFile : encryptedFiles) {
                Logger.debug("  removing outdated file: " + oneEncryptedFile.getName());
                oneEncryptedFile.delete();
            }
        }
        Logger.info("Finished checking if any encryption/compression files are outdated locally.");
    }

    public List<File> filesToBeUploaded(Map<String, Map<String, Object>> fileNamesAndFileInfoAlreadyUploaded, TransportType transportType) throws Exception {
        return this.filesToBeUploaded(fileNamesAndFileInfoAlreadyUploaded, transportType, true);
    }

    public List<File> filesToBeUploaded(Map<String, Map<String, Object>> fileNamesAndFileInfoAlreadyUploaded, TransportType transportType, boolean preUpload) throws Exception {
        List<String> confirmedUploadedFullFileNames = this.confirmFilesUploadedCorrectly(fileNamesAndFileInfoAlreadyUploaded, false, transportType);
        List<String> confirmedUploadedBaseFileNames = this.baseFileNamesForFileNames(confirmedUploadedFullFileNames);
        Logger.info("Determining which files " + (preUpload ? "should be" : "were not") + " uploaded ...");
        List<File> packageFilesInLocalItmsp = this.packageFilesToUse();
        Logger.debug("Valid local files will be checked:\n" + packageFilesInLocalItmsp);
        Logger.debug("Remote files uploaded:\n" + confirmedUploadedBaseFileNames);
        ArrayList<File> filesToBeUploadedArray = new ArrayList<File>();
        for (File oneFileInPkg : packageFilesInLocalItmsp) {
            if (confirmedUploadedBaseFileNames.contains(oneFileInPkg.getName())) {
                Logger.debug("Skipped, " + oneFileInPkg.getName() + " has already been uploaded successfully");
                continue;
            }
            File workingFileInPkg = oneFileInPkg;
            Logger.extreme("Examining working file: " + workingFileInPkg.getName());
            Logger.debug("Adding file " + (preUpload ? "to be" : "not") + " uploaded: " + workingFileInPkg.getName());
            filesToBeUploadedArray.add(workingFileInPkg);
        }
        Logger.info("Finished determining which files " + (preUpload ? "should be" : "were not") + " uploaded.");
        Logger.extreme("ITMSPackage: files " + (preUpload ? "to be" : "not") + " uploaded:\n" + filesToBeUploadedArray);
        return filesToBeUploadedArray;
    }

    private List<String> confirmFilesUploadedCorrectly(Map<String, Map<String, Object>> fileNamesAndFileInfoAlreadyUploaded, boolean ignoreFileSize, TransportType transportType) {
        if (fileNamesAndFileInfoAlreadyUploaded == null || fileNamesAndFileInfoAlreadyUploaded.size() == 0) {
            return new ArrayList<String>();
        }
        List<File> packageFilesInLocalItmsp = this.packageFilesToUse();
        this.removeOutdatedLocalFiles(packageFilesInLocalItmsp, transportType);
        Logger.info("Confirming that the previously uploaded files were uploaded correctly ...");
        Logger.extreme("   Ignoring file size while confirming files: " + ignoreFileSize);
        ArrayList<String> packageFileNamesInLocalItmsp = null;
        for (File file : packageFilesInLocalItmsp) {
            String name = file.getName();
            if (packageFileNamesInLocalItmsp == null) {
                packageFileNamesInLocalItmsp = new ArrayList<String>();
            }
            packageFileNamesInLocalItmsp.add(name);
        }
        ArrayList<String> confirmedFiles = new ArrayList<String>();
        Set<String> remoteFileNames = fileNamesAndFileInfoAlreadyUploaded.keySet();
        Iterator<String> remoteFileEnum = null;
        if (remoteFileNames != null) {
            remoteFileEnum = remoteFileNames.iterator();
        }
        while (remoteFileEnum != null && remoteFileEnum.hasNext()) {
            String remoteFileName = remoteFileEnum.next();
            Map<String, Object> remoteFileDict = fileNamesAndFileInfoAlreadyUploaded.get(remoteFileName);
            Long remoteFileLastModified = (Long)remoteFileDict.get("RemoteFileLastModified");
            Long remoteFileSize = (Long)remoteFileDict.get("RemoteFileSize");
            String assetFileName = this.assetNameForFileName(remoteFileName);
            String fullLocalFilePathForAsset = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), assetFileName);
            File localAssetFile = new File(fullLocalFilePathForAsset);
            String localFilePath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), remoteFileName);
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                Logger.extreme("   UNconfirmed file: " + remoteFileName + " is no longer available locally.");
                continue;
            }
            if (localFile.lastModified() > remoteFileLastModified) {
                Date localFileDate = new Date(localFile.lastModified());
                Date remoteFileDate = new Date(remoteFileLastModified);
                Logger.extreme("   UNconfirmed file: " + remoteFileName + ", date mismatch.  local file's date is " + localFileDate + ", remote file's date is " + remoteFileDate);
                continue;
            }
            if (!ignoreFileSize && this.getFileSize(localFile) != remoteFileSize.longValue()) {
                Logger.extreme("   UNconfirmed file: " + remoteFileName + ", file size mismatch.  local file size = " + TransportUtil.longToSizeSpec(this.getFileSize(localFile)) + ", remote file size = " + TransportUtil.longToSizeSpec(remoteFileSize));
                continue;
            }
            if (!localAssetFile.exists()) {
                Logger.extreme("   UNconfirmed file: " + remoteFileName + ", asset file is no longer available locally.");
                continue;
            }
            if (packageFileNamesInLocalItmsp != null && !packageFileNamesInLocalItmsp.contains(remoteFileName)) {
                Logger.extreme("   UNconfirmed file: " + remoteFileName + " is not set to be uploaded.");
                continue;
            }
            if (this.isInfoFileName(remoteFileName) || this.isCompressedFileName(remoteFileName) || this.isEncryptedFileName(remoteFileName)) continue;
            confirmedFiles.add(remoteFileName);
            Logger.debug("   confirmed file: " + remoteFileName);
        }
        Logger.info("Finished confirming that the previously uploaded files were uploaded correctly.");
        Logger.extreme("Files previously uploaded successfully:\n" + confirmedFiles + "\n");
        return confirmedFiles;
    }

    public Collection<String> filesToBeRemovedFromDestination(Map<String, Map<String, Object>> fileNamesAndFileInfoAlreadyUploaded, TransportType transportType) {
        if (fileNamesAndFileInfoAlreadyUploaded == null) {
            return null;
        }
        List<String> confirmedUploadedFileNames = null;
        confirmedUploadedFileNames = FileChunkUtil.isChunkingEnabled(transportType) ? this.confirmFilesUploadedCorrectly(fileNamesAndFileInfoAlreadyUploaded, true, transportType) : this.confirmFilesUploadedCorrectly(fileNamesAndFileInfoAlreadyUploaded, false, transportType);
        Logger.info("Determining which files (if any) should be removed from the Apple remote server ...");
        if (confirmedUploadedFileNames == null) {
            Logger.error("An error occurred while determining which files need to be removed.");
            return null;
        }
        Set<String> allUploadedFileNames = fileNamesAndFileInfoAlreadyUploaded.keySet();
        if (allUploadedFileNames == null) {
            Logger.error("An error occurred while determining which files need to be removed.");
            return null;
        }
        HashSet<String> removeTheseFilesSet = new HashSet<String>(allUploadedFileNames);
        removeTheseFilesSet.removeAll(confirmedUploadedFileNames);
        Logger.info("Finished determining which files (if any) should be removed from the Apple remote server.");
        Logger.extreme("Files to be removed from destination:\n" + removeTheseFilesSet);
        return removeTheseFilesSet;
    }

    private String assetNameForFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return null;
        }
        String oneFileBaseNameAlreadyUploaded = aFileName;
        while (oneFileBaseNameAlreadyUploaded != null && !oneFileBaseNameAlreadyUploaded.equals("") && (encryptedExtensions.contains(NSPathUtilities.pathExtension(oneFileBaseNameAlreadyUploaded).toLowerCase()) || compressionExtensions.contains(NSPathUtilities.pathExtension(oneFileBaseNameAlreadyUploaded).toLowerCase()) || infoExtensions.contains(NSPathUtilities.pathExtension(oneFileBaseNameAlreadyUploaded).toLowerCase()))) {
            oneFileBaseNameAlreadyUploaded = NSPathUtilities.stringByDeletingPathExtension(oneFileBaseNameAlreadyUploaded);
        }
        return oneFileBaseNameAlreadyUploaded;
    }

    public boolean isCompressedFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return false;
        }
        String fileExtension = NSPathUtilities.pathExtension(aFileName).toLowerCase();
        if (fileExtension == null) {
            fileExtension = "";
        }
        return compressionExtensions.contains(fileExtension);
    }

    public boolean isEncryptedFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return false;
        }
        String fileExtension = NSPathUtilities.pathExtension(aFileName).toLowerCase();
        if (fileExtension == null) {
            fileExtension = "";
        }
        return encryptedExtensions.contains(fileExtension);
    }

    public boolean isInfoFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return false;
        }
        String fileExtension = NSPathUtilities.pathExtension(aFileName).toLowerCase();
        if (fileExtension == null) {
            fileExtension = "";
        }
        return infoExtensions.contains(fileExtension);
    }

    private List<String> baseFileNamesForFileNames(List<String> fileNames) {
        HashSet<String> fileNamesSet = new HashSet<String>();
        for (String oneFileName : fileNames) {
            fileNamesSet.add(this.assetNameForFileName(oneFileName));
        }
        return new ArrayList<String>(fileNamesSet);
    }

    private List<File> existingEncryptionRelatedFilesForFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        if (this.isEncryptedFileName(aFile.getName()) || this.isInfoFileName(aFile.getName())) {
            return null;
        }
        File parentFolder = aFile.getParentFile();
        if (parentFolder == null) {
            return null;
        }
        File[] allFilesInFolder = parentFolder.listFiles();
        ArrayList<File> filesToReturn = new ArrayList<File>();
        for (File oneFileInFolder : allFilesInFolder) {
            String oneFileInFolderName = oneFileInFolder.getName();
            if (!this.isEncryptedFileName(oneFileInFolderName) && !this.isInfoFileName(oneFileInFolderName) || !oneFileInFolderName.startsWith(aFile.getName())) continue;
            filesToReturn.add(oneFileInFolder);
        }
        return filesToReturn;
    }

    public String compressionExentensionForFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        return ".gz";
    }

    public String infoExtensionForFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        return ".info";
    }

    public String encryptedExtensionForFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        return ".aes";
    }

    public String encryptedFileNameForInfoFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return null;
        }
        if (!this.isInfoFileName(aFileName)) {
            return null;
        }
        String encryptExt = this.encryptedExtensionForFile(new File(NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), aFileName)));
        String encryptedFileName = NSPathUtilities.stringByDeletingPathExtension(aFileName) + encryptExt;
        return encryptedFileName;
    }

    private File existingCompressedFileForFile(File aFile) {
        if (aFile == null) {
            return null;
        }
        Logger.extreme("  Looking for compressed version of file: " + aFile.getName() + " in folder: " + NSPathUtilities.stringByDeletingLastPathComponent(aFile.getAbsolutePath()) + " ...");
        String compressionExt = this.compressionExentensionForFile(aFile);
        if (compressionExt == null) {
            return null;
        }
        File compressedFile = new File(aFile.getAbsolutePath() + compressionExt);
        if (compressedFile.exists()) {
            Logger.extreme("  Found compressed file: " + compressedFile.getName());
            return compressedFile;
        }
        return null;
    }

    public boolean validateFileChecksums(Map remoteChecksums, Number minimumChecksumSize, boolean checksumCompletedBefore, Map fileLastModifiedTimestamps, WebService service) {
        List<File> filesNeedingChecksum;
        this.checksumInfo = new ArrayList();
        String checksumComparison = System.getProperty("checksumComparison");
        if (checksumComparison != null && checksumComparison.equalsIgnoreCase("false")) {
            Logger.info("Checksum comparison has been manually turned off.");
            return true;
        }
        if (remoteChecksums == null || remoteChecksums.size() == 0) {
            Logger.info("Apple did not return a list of files to have their md5 checksums checked.");
            return true;
        }
        try {
            filesNeedingChecksum = this.filesNeedingChecksumValidation(remoteChecksums, minimumChecksumSize, checksumCompletedBefore, fileLastModifiedTimestamps);
        }
        catch (RuntimeException re) {
            Logger.error("An error has occurred while preparing to validate checksums.", re);
            return false;
        }
        if (filesNeedingChecksum == null) {
            Logger.info("There are no files needing checksum valdation.");
            return true;
        }
        Collections.sort(filesNeedingChecksum, new CompareFilesBySizesAndPaths());
        boolean haveFileLargerThanThreshold = false;
        for (File fileInPkg : filesNeedingChecksum) {
            String fileName = fileInPkg.getName();
            String remoteMD5Value = (String)remoteChecksums.get(fileName);
            if (minimumChecksumSize != null && this.getFileSize(fileInPkg) > (long)minimumChecksumSize.intValue()) {
                haveFileLargerThanThreshold = true;
            }
            try {
                if (this.isChecksumValidForFile(fileInPkg, remoteMD5Value)) continue;
                return false;
            }
            catch (RuntimeException re) {
                Logger.error("An error has occurred while validating checksums.", re);
                return false;
            }
        }
        if (!checksumCompletedBefore) {
            boolean callSoapOperation = false;
            if (minimumChecksumSize != null && haveFileLargerThanThreshold) {
                callSoapOperation = true;
            } else if (minimumChecksumSize == null) {
                callSoapOperation = true;
            }
            if (callSoapOperation) {
                service.clientChecksumCompletedOperation(this);
            }
        }
        Logger.info("Done checking the md5 checksum.");
        return true;
    }

    private List<File> filesNeedingChecksumValidation(Map remoteChecksums, Number minimumChecksumSize, boolean checksumCompletedBefore, Map fileLastModifiedTimestamps) {
        if (remoteChecksums == null || remoteChecksums.size() == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(remoteChecksums.size());
        Set keySet = remoteChecksums.keySet();
        Logger.info("Checking the md5 checksum of the files: " + keySet);
        for (String fileName : keySet) {
            String fileInPkgPath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), fileName);
            File fileInPkg = new File(fileInPkgPath);
            if (!fileInPkg.exists()) {
                throw new RuntimeException("The file " + fileName + " in the package " + this.packageName() + " does not exist so the MD5 checksum could not be validated.");
            }
            boolean validateChecksum = true;
            if (checksumCompletedBefore && minimumChecksumSize == null) {
                validateChecksum = false;
                Logger.info("Checksum comparison skipped for file named " + fileName + " for resume: checksum has already succeeded");
            } else if (minimumChecksumSize != null && this.getFileSize(fileInPkg) > (long)minimumChecksumSize.intValue() && checksumCompletedBefore) {
                String timestamp;
                Object timestampObject;
                boolean skip = true;
                if (fileLastModifiedTimestamps != null && (timestampObject = fileLastModifiedTimestamps.get(fileName)) != null && (timestamp = String.valueOf(timestampObject)) != null) {
                    try {
                        Long time = Long.parseLong(timestamp);
                        if (time > 0L && time < fileInPkg.lastModified()) {
                            Logger.info("File has been modified since last checksum completed; checksum NOT skipped for file " + fileName);
                            skip = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (skip) {
                    validateChecksum = false;
                    Logger.info("Checksum comparison skipped for file named " + fileName + " for resume: checksum has already succeeded");
                }
            }
            if (!validateChecksum) continue;
            files.add(fileInPkg);
        }
        return files;
    }

    private boolean isChecksumValidForFile(File fileInPkg, String metadataMD5Value) {
        if (fileInPkg == null) {
            throw new IllegalArgumentException("No file was given for checksum validation.");
        }
        if (metadataMD5Value == null || metadataMD5Value.length() == 0) {
            throw new IllegalArgumentException("No metadata md5 value was given for checksum validation.");
        }
        String fileName = fileInPkg.getName();
        String hash = null;
        Date startHashDate = null;
        Date endHashDate = null;
        try {
            Logger.extreme(" Checking the MD5 checksum of file: " + fileName);
            startHashDate = new Date();
            hash = FileUtil.md5Hex(fileInPkg);
            endHashDate = new Date();
            if (hash == null) {
                Logger.error("A MD5 checksum could not be attained for the file " + fileInPkg.getName());
                return false;
            }
            if (!hash.equalsIgnoreCase(metadataMD5Value)) {
                Logger.error("The calculated MD5 checksum of " + hash + " for the local file " + fileName + " does not match what is in the metadata (" + metadataMD5Value + ").");
                return false;
            }
        }
        catch (IOException ioe) {
            Logger.error("An IO error occurred while computing the MD5 checksum for the file " + fileInPkg.getName(), ioe);
            return false;
        }
        catch (NoSuchAlgorithmException nsae) {
            Logger.error("An error occurred while computing the MD5 checksum for the file " + fileInPkg.getName() + ".  The MD5 algorithm could not be found.", nsae);
            return false;
        }
        catch (RuntimeException t) {
            Logger.error("An error occurred while computing the MD5 checksum for the file " + fileInPkg.getName(), t);
            return false;
        }
        try {
            if (this.checksumInfo == null) {
                this.checksumInfo = new ArrayList();
            }
            HashMap<String, Object> checksumInfoforOneFile = new HashMap<String, Object>();
            this.checksumInfo.add(checksumInfoforOneFile);
            checksumInfoforOneFile.put(FILENAME_KEY, fileName);
            checksumInfoforOneFile.put(FILE_SIZE_KEY, this.getFileSize(fileInPkg));
            checksumInfoforOneFile.put(CLIENT_CHECKSUM_CALCULATED_CHECKSUM_KEY, hash);
            long timeInMS = endHashDate.getTime() - startHashDate.getTime();
            checksumInfoforOneFile.put(CLIENT_CHECKSUM_CALCULATION_TIME_KEY, timeInMS);
            checksumInfoforOneFile.put(CLIENT_CHECKSUM_FILE_LAST_MODIFIED_KEY, fileInPkg.lastModified());
        }
        catch (RuntimeException t) {
            Logger.error("An error occurred while caching the checksum value " + hash + " and other info for the file " + fileInPkg.getName() + ".  The error will be ignored.", t);
        }
        return true;
    }

    public boolean validateFileSizes(Map remoteFileSizes) {
        String fileSizeComparison = System.getProperty("fileSizeComparison");
        if (fileSizeComparison != null && fileSizeComparison.equalsIgnoreCase("false")) {
            Logger.info("File size comparison has been manually turned off.");
            return true;
        }
        if (remoteFileSizes == null || remoteFileSizes.size() == 0) {
            Logger.info("Apple did not return a list of files to have their file size checked.");
            return true;
        }
        if (!this.supportsFileSizeCheck()) {
            Logger.info("Package does not support file size checking; skipping");
            return true;
        }
        Set keySet = remoteFileSizes.keySet();
        Logger.info("Checking the file size of the files: " + keySet);
        for (String fileName : keySet) {
            Logger.extreme(" Checking the size of file: " + fileName);
            Long remoteFileSizeValue = (Long)remoteFileSizes.get(fileName);
            String fileInPkgPath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), fileName);
            File fileInPkg = new File(fileInPkgPath);
            if (!fileInPkg.exists()) {
                Logger.error("The file " + fileName + " in the package " + this.packageName() + " does not exist so the file size could not be validated.");
                return false;
            }
            Long fileInPkgFileSize = this.getFileSize(fileInPkg);
            if (remoteFileSizeValue.longValue() == fileInPkgFileSize.longValue()) continue;
            Logger.error("The file size for the local file " + fileName + " does not match what is in the metadata.");
            return false;
        }
        Logger.info("Done checking the file sizes.");
        return true;
    }

    public boolean validateChaptersXML(String schemaName) {
        String chaptersFileName = this.chaptersFileName();
        if (chaptersFileName == null || chaptersFileName.trim().length() == 0) {
            Logger.error("Could not find the chapters xml filename in metadata.xml.  Chapters XML validation cannot be performed but the upload will continue.");
            return true;
        }
        if (this.chaptersFileContents() == null || this.chaptersFileContents().trim().length() == 0) {
            Logger.error("Could not get the contents of the chapteter xml file named '" + chaptersFileName + "'.  Chapters XML validation cannot be performed but the upload will continue.");
            return true;
        }
        Logger.info("Validating chapters file: " + chaptersFileName);
        Logger.extreme("...using schema: " + schemaName);
        if (chaptersFileName != null && this.chaptersFileContents() == null) {
            Logger.error("Chapters file " + chaptersFileName + " referenced in metadata.xml but does not exist or is invalid");
            return false;
        }
        List<String> metadataChapterFiles = this.chapterImageFilesFromMetadata(this.metadataFileName());
        String fullChaptersPath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), this.chaptersFileName());
        File xmlFile = new File(fullChaptersPath);
        XmlObject chaptersRootNode = this.chaptersDomXmlObject(schemaName, xmlFile);
        if (chaptersRootNode == null) {
            return false;
        }
        XmlObject[] chapterXmlObjects = chaptersRootNode.selectPath("//chapters/chapter");
        ArrayList<String> chapterImageFiles = new ArrayList<String>();
        boolean chaptersXMLIsValid = true;
        if (chapterXmlObjects == null || chapterXmlObjects.length == 0) {
            Logger.error("The chapters file " + chaptersFileName + " does not have any chapters information.");
            chaptersXMLIsValid = false;
            return chaptersXMLIsValid;
        }
        Logger.extreme("...checking that first chapter starts at 00:00:00");
        TimeCode firstChapterTimeCode = TimeCode.parseQTTextString(chapterXmlObjects[0].getDomNode().getAttributes().getNamedItem("starttime").getNodeValue());
        if (firstChapterTimeCode.getMillis() != 0L) {
            Logger.error("First chapter encountered should begin at 00:00:00 but instead begins at " + firstChapterTimeCode.prettyDescription());
            chaptersXMLIsValid = false;
        }
        Logger.extreme("...checking that first chapter has a valid title and picture name");
        ChaptersXMLValidationContext context = new ChaptersXMLValidationContext();
        this.validateTitleAndPictureNames(chapterXmlObjects[0], context);
        Logger.extreme("...checking that chapters are in sequential time order and that they have valid titles and pictures");
        TimeCode previousTimeCode = firstChapterTimeCode;
        for (int i = 1; i < chapterXmlObjects.length; ++i) {
            TimeCode timeCode = TimeCode.parseQTTextString(chapterXmlObjects[i].getDomNode().getAttributes().getNamedItem("starttime").getNodeValue());
            if (previousTimeCode.compareTo(timeCode) >= 0) {
                Logger.error("Chapters are out of order.  The chapter at time code " + previousTimeCode.prettyDescription() + " occurs earlier in the file than the chapter at time code " + timeCode.prettyDescription() + ".");
                chaptersXMLIsValid = false;
            }
            previousTimeCode = timeCode;
            if (this.validateTitleAndPictureNames(chapterXmlObjects[i], context)) continue;
            chaptersXMLIsValid = false;
        }
        Logger.extreme("...checking that chapters have valid picture files");
        String packagePath = this.packageNameWithPath();
        for (int i = 0; i < chapterXmlObjects.length; ++i) {
            XmlObject[] pictureNodes = chapterXmlObjects[i].selectPath("./picture");
            Node pictureNode = null;
            if (pictureNodes.length <= 0) continue;
            pictureNode = pictureNodes[0].getDomNode().getFirstChild();
            if (pictureNode == null) {
                Node titleNode;
                String title = "Unspecified title";
                XmlObject[] titles = chapterXmlObjects[i].selectPath("./title");
                if (titles != null && titles[0] != null && titles[0].getDomNode() != null && (titleNode = titles[0].getDomNode().getFirstChild()) != null) {
                    title = titleNode.getNodeValue();
                }
                Logger.error("An empty picture was specified in \"" + title + "\" in " + this.chaptersFileName());
                chaptersXMLIsValid = false;
                continue;
            }
            chapterImageFiles.add(pictureNode.getNodeValue());
            if (this.validateChaptersPictureFileContent(new File(packagePath, pictureNode.getNodeValue()))) continue;
            chaptersXMLIsValid = false;
        }
        Logger.extreme("...checking that metadata.xml contains the same chapter images as chapters xml");
        for (String chapterFile : metadataChapterFiles) {
            if (chapterImageFiles.contains(chapterFile)) continue;
            Logger.error("Referenced picture \"" + chapterFile + "\" not listed in " + this.chaptersFileName());
            chaptersXMLIsValid = false;
        }
        if (chaptersXMLIsValid) {
            Logger.extreme("...chapters file passed all validation!");
        }
        Logger.info("Done validating chapters file.");
        return chaptersXMLIsValid;
    }

    private boolean validateChaptersPictureFileContent(File chaptersPictureFile) {
        String canonicalPath;
        boolean contentIsValid = true;
        try {
            canonicalPath = chaptersPictureFile.getCanonicalPath();
        }
        catch (IOException e) {
            canonicalPath = chaptersPictureFile.getAbsolutePath();
        }
        if (this.filesRequestedByAppleCanonicalPaths().contains(canonicalPath) && !chaptersPictureFile.exists()) {
            Logger.error("Picture " + chaptersPictureFile.getName() + " referenced from " + this.chaptersFileName() + " could not be found in .itmsp package at " + chaptersPictureFile.getParent());
            contentIsValid = false;
        }
        return contentIsValid;
    }

    private boolean validateTitleAndPictureNames(XmlObject chapterXmlObject, ChaptersXMLValidationContext context) {
        boolean titleAndPictureNameAreValid = true;
        Node titleNode = chapterXmlObject.selectPath("./title")[0].getDomNode().getFirstChild();
        XmlObject[] pictureNodes = chapterXmlObject.selectPath("./picture");
        Node pictureNode = null;
        if (pictureNodes.length > 1) {
            Logger.error("Only one chapter image allowed per chapter");
            titleAndPictureNameAreValid = false;
        }
        if (pictureNodes.length > 0) {
            pictureNode = chapterXmlObject.selectPath("./picture")[0].getDomNode().getFirstChild();
        }
        if (titleNode == null || titleNode.getNodeValue().trim().equals("")) {
            Logger.error("Empty titles not allowed in chapters XML files");
            titleAndPictureNameAreValid = false;
        }
        if (pictureNode == null || pictureNode.getNodeValue().trim().equals("")) {
            if (context.isImagesPresent() == null) {
                context.setImagesPresent(Boolean.FALSE);
            } else if (context.isImagesPresent() == Boolean.TRUE) {
                Logger.error("Empty picture names not allowed in chapters XML files when non-empty picture names were already encountered");
                titleAndPictureNameAreValid = false;
            }
        } else {
            if (context.isImagesPresent() == null) {
                context.setImagesPresent(Boolean.TRUE);
            } else if (context.isImagesPresent() == Boolean.FALSE) {
                Logger.error("Non-empty picture names not allowed in chapters XML files when empty picture names were already encountered.");
                titleAndPictureNameAreValid = false;
            }
            if (!pictureNode.getNodeValue().trim().endsWith(".jpg") && !pictureNode.getNodeValue().trim().endsWith(".jpeg")) {
                Logger.error("Referenced picture \"" + pictureNode.getNodeValue().trim() + "\" does not end in \".jpg\" or \".jpeg\"");
                titleAndPictureNameAreValid = false;
            }
            if (pictureNode.getNodeValue().indexOf("/") != -1) {
                Logger.error("Picture names in chapters XML files must not contain slashes");
                titleAndPictureNameAreValid = false;
            }
        }
        if (pictureNode != null) {
            Logger.extreme("...checking metadata XML for chapter picture file " + pictureNode.getNodeValue());
            List<String> metadataChapterFiles = this.chapterImageFilesFromMetadata(this.metadataFileName());
            if (!metadataChapterFiles.contains(pictureNode.getNodeValue())) {
                Logger.error("Referenced picture \"" + pictureNode.getNodeValue().trim() + "\" not listed in metadata.xml");
                titleAndPictureNameAreValid = false;
            } else {
                Logger.extreme("  ...found matching chapters picture file in metadata.xml");
            }
        }
        return titleAndPictureNameAreValid;
    }

    public Long filesRequestedByAppleSizeSum() {
        Long size = this.filesRequestedByApple() == null ? this.allPackageFilesSizeSum() : FileUtil.fileSizeSumForFiles(this, this.filesRequestedByApple());
        return size;
    }

    public Long allPackageFilesSizeSum() {
        List<File> filesArray = this.allPackageFiles();
        Long size = FileUtil.fileSizeSumForFiles(this, filesArray);
        return size;
    }

    public String caseSensitiveFileNameForFileName(String aFileName) {
        List<File> filesArray = this.allPackageFiles();
        String caseSensitiveFileName = null;
        for (File oneFileInPkg : filesArray) {
            if (!oneFileInPkg.getName().toLowerCase().equals(aFileName.toLowerCase())) continue;
            caseSensitiveFileName = oneFileInPkg.getName();
        }
        return caseSensitiveFileName;
    }

    public String fileContentsForFileName(String aFileName) {
        String pkgAndFileName = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), aFileName);
        String fileContents = null;
        if (aFileName == null || aFileName.length() == 0) {
            return null;
        }
        File aFile = new File(pkgAndFileName);
        if (!aFile.exists()) {
            Logger.error("NO " + aFileName + " file was found in the package: " + this.packageNameWithPath());
            return null;
        }
        if (!aFile.canRead()) {
            Logger.error("The file: " + pkgAndFileName + " does NOT have read access.");
            return null;
        }
        try {
            fileContents = FileUtil.stringFromFile(aFile);
        }
        catch (IOException e) {
            Logger.error("Could NOT extract the contents of the " + aFileName + " file: " + this.packageNameWithPath(), e);
            return null;
        }
        catch (Throwable t) {
            Logger.error("Could NOT extract the contents of the " + aFileName + " file: " + this.packageNameWithPath(), t);
            return null;
        }
        if (fileContents != null && !fileContents.equals("")) {
            return fileContents;
        }
        Logger.error("Could NOT extract the contents of the " + aFileName + " file: " + this.packageNameWithPath());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLWellFormed(String aFileName) {
        String xmlString = this.fileContentsForFileName(aFileName);
        if (xmlString == null || xmlString.length() == 0) {
            return false;
        }
        boolean isWellFormed = true;
        try {
            String pkgAndFileName = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), aFileName);
            File aFile = new File(pkgAndFileName);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new SilentErrorReporter());
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(aFile);
                db.parse(inputStream);
            }
        }
        catch (SAXParseException e) {
            Logger.error("  The XML file: " + aFileName + " in " + this.packageNameWithPath() + " is NOT well-formed.");
            isWellFormed = false;
        }
        catch (SAXException e) {
            Logger.error("  The XML file: " + aFileName + " in " + this.packageNameWithPath() + " is NOT well-formed.", e);
            isWellFormed = false;
        }
        catch (IOException e) {
            Logger.error("  The XML file: " + aFileName + " in " + this.packageNameWithPath() + " is NOT well-formed.", e);
            isWellFormed = false;
        }
        catch (Throwable t) {
            Logger.error("  There was an error parsing the XML file: " + aFileName + " in " + this.packageNameWithPath(), t);
            isWellFormed = false;
        }
        return isWellFormed;
    }

    public String chaptersFileNameFromMetadata() {
        String metadataFileName = this.metadataFileName();
        String metadataFilePath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), metadataFileName);
        Logger.extreme(" Searching metadata.xml for chapters file...");
        try {
            File metadataFile = new File(metadataFilePath);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(metadataFile);
            NodeList dataFileNodes = doc.getElementsByTagName("data_file");
            int dataFileNodeCount = dataFileNodes.getLength();
            for (int index = 0; index < dataFileNodeCount; ++index) {
                String fileName;
                NodeList fileNameNodes;
                Element aNode = (Element)dataFileNodes.item(index);
                String role = aNode.getAttribute("role");
                if (!role.equals("chapters") || (fileNameNodes = aNode.getElementsByTagName("file_name")).getLength() <= 0 || !(fileName = fileNameNodes.item(0).getFirstChild().getNodeValue()).contains(".xml")) continue;
                Logger.extreme(" ...found Chapters XML file:" + fileName);
                return fileName;
            }
        }
        catch (Exception e) {
            Logger.error("Error searching metadata for chapters file: ", e);
        }
        return null;
    }

    private List<String> chapterImageFilesFromMetadata(String metadataFileName) {
        if (this.metadataChapterImages == null) {
            ArrayList<String> chapterFiles = new ArrayList<String>();
            String metadataFilePath = NSPathUtilities.stringByAppendingPathComponent(this.packageNameWithPath(), metadataFileName);
            Logger.extreme(" Searching metadata.xml for chapter image files...");
            try {
                File metadataFile = new File(metadataFilePath);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(metadataFile);
                NodeList dataFileNodes = doc.getElementsByTagName("data_file");
                int dataFileNodeCount = dataFileNodes.getLength();
                for (int index = 0; index < dataFileNodeCount; ++index) {
                    String fileName;
                    NodeList fileNameNodes;
                    Element aNode = (Element)dataFileNodes.item(index);
                    String role = aNode.getAttribute("role");
                    if (!role.equals("chapters") || (fileNameNodes = aNode.getElementsByTagName("file_name")).getLength() <= 0 || (fileName = fileNameNodes.item(0).getFirstChild().getNodeValue()).contains(".xml")) continue;
                    Logger.extreme(" ...found chapter image file:" + fileName);
                    chapterFiles.add(fileName);
                }
            }
            catch (Exception e) {
                Logger.error("Error searching metadata for chapters file: ", e);
            }
            this.metadataChapterImages = chapterFiles;
        }
        return this.metadataChapterImages;
    }

    protected Schema getSchema(String schemaName) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(StreamUtil.getResourceAsStream("Schema/" + schemaName)));
        return schema;
    }

    public long getFileSize(File file) {
        return file.length();
    }

    public HttpEntity getDavHttpEntityForFile(File oneFileInPkg) {
        return new FileEntity(oneFileInPkg);
    }

    private XmlObject chaptersDomXmlObject(String schemaName, File xmlFile) {
        if (this.chaptersDomXmlObject == null) {
            Schema schema;
            String schemaFilePath = null;
            try {
                schema = this.getSchema(schemaName);
                Logger.extreme(" ...validating chapters XML using schema : " + schemaFilePath);
            }
            catch (IllegalStateException ioe) {
                Logger.error("An illegal state error occurred while finding the chapters schema file named '" + schemaFilePath + "'.", ioe);
                return null;
            }
            catch (SAXException e) {
                Logger.error("An error occurred while finding the chapters schema file named '" + schemaFilePath + "'.", e);
                return null;
            }
            try {
                XmlObject rootNode;
                FileInputStream inputStream;
                FileInputStream chapterStream = inputStream = new FileInputStream(xmlFile);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setSchema(schema);
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                XMLErrorHandler errorHandler = new XMLErrorHandler();
                errorHandler.setXMLDocumentName(xmlFile.getName());
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setErrorHandler(errorHandler);
                Document document = db.parse(chapterStream);
                if (errorHandler.getExceptions().size() > 0) {
                    List<SAXParseException> exceptions = errorHandler.getExceptions();
                    for (SAXParseException exception : exceptions) {
                        Logger.error("An error occurred while parsing the XML document named '" + xmlFile.getName() + "'.  The exception's message is: " + exception.getMessage(), exception);
                    }
                    Logger.error("The chapters document was not valid as per the schema file named '" + schemaName + "'.");
                    return null;
                }
                this.chaptersDomXmlObject = rootNode = XmlObject.Factory.parse((Node)document);
            }
            catch (SAXException saxException) {
                Logger.error("An error occurred while parsing the XML document named '" + xmlFile.getName() + "'.  The exception's message is: " + saxException.getMessage(), saxException);
            }
            catch (ParserConfigurationException pce) {
                Logger.error("A parse configuration error occurred while parsing the XML document named '" + xmlFile.getName() + "'.  The exception's message is: " + pce.getMessage(), pce);
            }
            catch (XmlException xmle) {
                Logger.error("A XML error occurred while parsing the XML document named '" + xmlFile.getName() + "'.  The exception's message is: " + xmle.getMessage(), xmle);
            }
            catch (IOException ioe) {
                Logger.error("A I/O error occurred while parsing the XML document named '" + xmlFile.getName() + "'.  The exception's message is: " + ioe.getMessage(), ioe);
            }
        }
        return this.chaptersDomXmlObject;
    }

    public Collection checksumInfo() {
        return this.checksumInfo;
    }

    public boolean supportsAssetDescription() {
        return true;
    }

    public boolean supportsFileSizeCheck() {
        return true;
    }

    public Map<String, Long> fileSizeInfo() {
        List<File> files = this.packageFilesToUse();
        Iterator<File> iterator = null;
        if (files == null) {
            return null;
        }
        iterator = files.iterator();
        HashMap<String, Long> fileSizeInfo = new HashMap<String, Long>();
        while (iterator != null && iterator.hasNext()) {
            File aFile = iterator.next();
            fileSizeInfo.put(aFile.getName(), new Long(this.getFileSize(aFile)));
        }
        return fileSizeInfo;
    }

    public void reset() {
    }

    public ChunkedFileSource chunkedFileSource(File oneFileInPkg) throws FileNotFoundException {
        return new RandomAccessFileSource(oneFileInPkg);
    }

    static {
        compressionExtensions.add("gz");
        gzippedExtensions.add("wav");
        ignoredFileNames.add("playlist info");
        encryptedExtensions.add("aes");
        infoExtensions.add("info");
    }

    private static class ChaptersXMLValidationContext {
        public Boolean imagesPresent = null;

        private ChaptersXMLValidationContext() {
        }

        public Boolean isImagesPresent() {
            return this.imagesPresent;
        }

        public void setImagesPresent(Boolean imagesPresent) {
            this.imagesPresent = imagesPresent;
        }
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private List<SAXParseException> exceptions = new LinkedList<SAXParseException>();
        private String xmlDocumentName = null;

        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Logger.error("A warning occurred while parsing the XML document named '" + this.xmlDocumentName() + "'.  The exception's message is: " + exception.getMessage(), exception);
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }

        public void setXMLDocumentName(String value) {
            this.xmlDocumentName = value;
        }

        public String xmlDocumentName() {
            return this.xmlDocumentName;
        }
    }
}

