/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.log.LogMessageType;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.JSONMessageLogger;
import java.util.HashMap;

public class VerifyProgressReporter {
    private static final int displayVerifyProgressStateNone = -1;
    private static final int displayVerifyProgressStateText = 0;
    private static final int displayVerifyProgressStateJSON = 1;
    private static int displayVerifyProgressState = -1;
    private static String phase = "Unknown";
    private static final String VerifyCount = "VerifyCountKey";
    private static final String VerifyIndex = "VerifyIndexKey";
    private static final String VerifyProgressLogPrefix = "Verify progress: ";
    public static final String AnalyzingMetadata = "Analyzing metadata";
    public static final String AddingAssetToAnalyze = "Adding asset to analyze:";
    public static final String ValidatingAssets = "Validating assets";
    public static final String OperationFailed = "Operation failed";
    public static final String OperationCompleted = "Operation completed";

    public void incrementVerifyCount() {
        if (displayVerifyProgressState != -1) {
            this.incrementVerifyCountBy(1);
        }
    }

    public void incrementVerifyCountBy(int aValue) {
        if (displayVerifyProgressState != -1) {
            String verifyCountString = System.getProperty(VerifyCount, "0");
            int verifyCount = new Integer(verifyCountString);
            System.setProperty(VerifyCount, new Integer(verifyCount += aValue).toString());
        }
    }

    public void decrementStepCountBy(int aValue) {
        if (displayVerifyProgressState != -1) {
            String verifyIndexString = System.getProperty(VerifyIndex, "0");
            int verifyIndex = new Integer(verifyIndexString);
            if ((verifyIndex -= aValue) < 0) {
                verifyIndex = 0;
            }
            verifyIndexString = new Integer(verifyIndex).toString();
            System.setProperty(VerifyIndex, verifyIndexString);
        }
    }

    protected int verifyCount() {
        int verifyCount = 0;
        if (displayVerifyProgressState != -1) {
            String verifyCountString = System.getProperty(VerifyCount, "0");
            verifyCount = new Integer(verifyCountString);
        }
        return verifyCount;
    }

    public void resetVerifyCount() {
        if (displayVerifyProgressState != -1) {
            System.clearProperty(VerifyCount);
        }
    }

    public void logVerifyProgress(String verifyDescription) {
        this.logVerifyProgress(verifyDescription, null);
    }

    public void logVerifyProgress(String verifyDescription, String asset) {
        if (displayVerifyProgressState != -1) {
            String verifyIndexString = System.getProperty(VerifyIndex, "0");
            int verifyCount = this.verifyCount();
            int verifyIndex = new Integer(verifyIndexString);
            if (verifyCount > 0) {
                ++verifyIndex;
            }
            if (verifyDescription.equals(OperationFailed) || verifyDescription.equals(OperationCompleted)) {
                verifyIndex = verifyCount;
            }
            verifyIndexString = new Integer(verifyIndex).toString();
            System.setProperty(VerifyIndex, verifyIndexString);
            String verifyCountString = null;
            if (displayVerifyProgressState == 0) {
                if (verifyDescription.equals(AddingAssetToAnalyze) && asset != null && asset.length() > 0) {
                    verifyDescription = verifyDescription + " " + asset;
                }
                if (verifyCount == 0) {
                    Logger.info(VerifyProgressLogPrefix + verifyDescription + " (Step " + verifyIndexString + "/?)");
                    verifyCountString = "?";
                } else {
                    Logger.info(VerifyProgressLogPrefix + verifyDescription + " (Step " + verifyIndexString + "/" + new Integer(verifyCount).toString() + ")");
                    verifyCountString = new Integer(verifyCount).toString();
                }
            } else if (displayVerifyProgressState == 1) {
                HashMap<String, Object> output = new HashMap<String, Object>();
                output.put("phase", phase);
                output.put("description", verifyDescription);
                output.put("index", new Integer(verifyIndex));
                if (asset != null) {
                    output.put("asset", asset);
                }
                if (verifyCount > 0) {
                    output.put("count", new Integer(verifyCount));
                }
                JSONMessageLogger.info(LogMessageType.VERIFY_PROGRESS, output);
            }
        }
    }

    public void setPhase(String aValue) {
        phase = aValue;
    }

    public static void setVerifyProgressState(int aValue) {
        displayVerifyProgressState = aValue;
    }

    public static boolean isJSONEnabled() {
        return displayVerifyProgressState == 1;
    }
}

