/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.Application;
import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.XMLUtil;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UploadProgressReporter {
    private static final float MIN_FILE_UPLOAD_PROGRESS_PERCENT = 0.01f;
    private static final String FIRST_BYTES_TRANSFERRED = "First";
    private static final String CURRENT_BYTES_TRANSFERRED = "Current";
    private static UploadProgressReporter sharedInstance;
    static long totalPkgSize;
    static long completedUploadsSize;
    static Long totalSessionWrittenBytes;
    static Map<String, Float> lastLoggedPercentages;
    private static Map<String, Map<String, Long>> lastLoggedBytesTransferred;
    private static Boolean isResumedUpload;
    private static Boolean isRetry;
    private boolean _registeredForNotifications = false;

    public static UploadProgressReporter sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new UploadProgressReporter();
        }
        return sharedInstance;
    }

    private UploadProgressReporter() {
    }

    public void setupToLogUploadProgress() {
        if (this._registeredForNotifications) {
            return;
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(this, "logUploadProgressForPackage", "FileInPackageUploadSucceeded", null);
        defaultCenter.addObserver(this, "prepareForNewUpload", "PreparingToUploadFilesInPackage", null);
        defaultCenter.addObserver(this, "logUploadProgressForFile", "FileHasBeenPartiallyUploaded", null);
        defaultCenter.addObserver(this, "logTotalBytesTransferredForSession", "TotalBytesWrittenToServer", null);
        this._registeredForNotifications = true;
    }

    public static void setTotalPackageSizeWithFiles(ITMSPackage pkg, List<File> filesToUpload) {
        lastLoggedPercentages = new HashMap<String, Float>();
        lastLoggedBytesTransferred = new HashMap<String, Map<String, Long>>();
        if (filesToUpload == null || filesToUpload.size() == 0 || !Application.shouldDisplayProgress) {
            return;
        }
        Logger.info("Computing total size of files to upload ...");
        Long pkgSize = FileUtil.fileSizeSumForFiles(pkg, filesToUpload);
        if (pkgSize == null) {
            Logger.error("An error occurred while computing the total size of the files to upload.");
            return;
        }
        for (File oneFile : filesToUpload) {
            Logger.extreme("  adding file for % complete logging: " + oneFile.getName() + " , size: " + (pkg == null ? oneFile.length() : pkg.getFileSize(oneFile)));
            lastLoggedPercentages.put(oneFile.getName(), new Float(0.0f));
        }
        Logger.debug("Setting total size of files for upload to: " + pkgSize);
        totalPkgSize = pkgSize;
        Logger.info("Done computing total size of files to upload.");
    }

    public static void resetUploadProgressSizes() {
        lastLoggedPercentages = null;
        lastLoggedBytesTransferred = null;
        isResumedUpload = null;
        isRetry = null;
        Logger.debug("Resetting sizes for progress logging");
        totalPkgSize = 0L;
        completedUploadsSize = 0L;
        totalSessionWrittenBytes = null;
    }

    public void logUploadProgressForPackage(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        try {
            File oneFile = (File)aNotification.getObject();
            if (oneFile == null || !oneFile.exists()) {
                Logger.debug("Log upload progress called with non-existent file");
                return;
            }
            ITMSPackage itmsPackage = (ITMSPackage)aNotification.getUserInfo().get("Package");
            completedUploadsSize += itmsPackage == null ? oneFile.length() : itmsPackage.getFileSize(oneFile);
            if (totalPkgSize == 0L) {
                return;
            }
            if (!Application.shouldDisplayProgress) {
                return;
            }
            float percentComplete = (float)completedUploadsSize / (float)totalPkgSize;
            if (percentComplete > 0.99f && percentComplete < 1.0f) {
                percentComplete = 0.99f;
            }
            NumberFormat df = NumberFormat.getPercentInstance();
            df.setMaximumFractionDigits(2);
            String percentCompleteRounded = df.format(percentComplete);
            Logger.info("Package upload progress: " + percentCompleteRounded + " completed");
        }
        catch (Throwable t) {
            Logger.error("An error occurred while logging the upload progress of a package.", t);
        }
    }

    public void prepareForNewUpload(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        try {
            Map<String, Object> userInfo = aNotification.getUserInfo();
            Boolean tempIsRetry = (Boolean)userInfo.get("IsRetry");
            if (tempIsRetry != null && !tempIsRetry.booleanValue()) {
                UploadProgressReporter.resetUploadProgressSizes();
            }
            isResumedUpload = (Boolean)userInfo.get("IsResumedUpload");
            isRetry = (Boolean)userInfo.get("IsRetry");
            if (isResumedUpload == null) {
                isResumedUpload = Boolean.FALSE;
            }
            if (isRetry == null) {
                isRetry = Boolean.FALSE;
            }
            List filesToUpload = (List)aNotification.getObject();
            ITMSPackage pkg = (ITMSPackage)userInfo.get("Package");
            UploadProgressReporter.setTotalPackageSizeWithFiles(pkg, filesToUpload);
        }
        catch (Throwable t) {
            Logger.error("An error occurred while preparing the progress indicator for new files to be uploaded.", t);
        }
    }

    public void logTotalBytesTransferredForSession(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        totalSessionWrittenBytes = (Long)aNotification.getObject();
    }

    public void logUploadProgressForFile(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        try {
            Float temp;
            String fileName = (String)aNotification.getObject();
            Map<String, Object> userInfo = aNotification.getUserInfo();
            Long bytesWritten = (Long)userInfo.get("BytesWritten");
            Long fileSize = (Long)userInfo.get("FileSize");
            if (fileName == null) {
                fileName = "*Unknown*";
            }
            if (bytesWritten == null || fileSize == null) {
                if (Application.shouldDisplayProgress) {
                    Logger.info("A chunk of the file, " + fileName + " has been uploaded.");
                }
                return;
            }
            String justFilename = NSPathUtilities.lastPathComponent(fileName);
            float lastLoggedPercentage = 0.0f;
            if (lastLoggedPercentages != null && (temp = lastLoggedPercentages.get(justFilename)) != null) {
                lastLoggedPercentage = temp.floatValue();
            }
            if (lastLoggedBytesTransferred != null && bytesWritten != null) {
                Map<String, Long> infoForFile = lastLoggedBytesTransferred.get(justFilename);
                if (infoForFile == null) {
                    infoForFile = new HashMap<String, Long>();
                    lastLoggedBytesTransferred.put(justFilename, infoForFile);
                }
                if (infoForFile.get(FIRST_BYTES_TRANSFERRED) == null) {
                    if (!isResumedUpload.booleanValue()) {
                        infoForFile.put(FIRST_BYTES_TRANSFERRED, new Long(0L));
                        infoForFile.put(CURRENT_BYTES_TRANSFERRED, bytesWritten);
                    } else {
                        infoForFile.put(FIRST_BYTES_TRANSFERRED, bytesWritten);
                    }
                } else {
                    infoForFile.put(CURRENT_BYTES_TRANSFERRED, bytesWritten);
                }
            }
            long bytesWrittenLong = bytesWritten;
            long fileSizeLong = fileSize;
            float percentComplete = fileSizeLong == 0L ? lastLoggedPercentage : (float)(bytesWrittenLong * 100L / fileSizeLong) / 100.0f;
            NumberFormat df = NumberFormat.getPercentInstance();
            df.setMaximumFractionDigits(2);
            String percentCompleteRounded = df.format(percentComplete);
            if (percentComplete - lastLoggedPercentage > 0.01f || percentComplete == 1.0f) {
                lastLoggedPercentage = percentComplete != 1.0f ? (float)Math.floor(percentComplete / 0.01f) * 0.01f : 0.0f;
                if (lastLoggedPercentages != null) {
                    Float temp2 = new Float(lastLoggedPercentage);
                    lastLoggedPercentages.put(justFilename, temp2);
                }
                if (!Application.shouldDisplayProgress) {
                    return;
                }
                Logger.info("     File: " + fileName + " " + bytesWritten + "/" + fileSize + ", " + percentCompleteRounded + " completed");
                if (Application.shouldGenerateXML()) {
                    XMLUtil.XMLTag tag = new XMLUtil.XMLTag("file_progress", 1);
                    tag.addAttribute("filename", fileName);
                    tag.addAttribute("size", String.valueOf(fileSize));
                    tag.addAttribute("bytes_written", String.valueOf(bytesWritten));
                    String xml = tag.marshall();
                    Application.writeXML(xml);
                }
            }
        }
        catch (Throwable t) {
            Logger.error("An error occurred while logging the upload progress of a file.", t);
        }
    }

    public static Long totalLastLoggedBytesTransferedForAllFiles() {
        if (totalSessionWrittenBytes != null) {
            return (long)totalSessionWrittenBytes;
        }
        if (lastLoggedBytesTransferred == null) {
            return null;
        }
        if (lastLoggedBytesTransferred.size() == 0) {
            return new Long(0L);
        }
        long totalBytes = 0L;
        for (String key : lastLoggedBytesTransferred.keySet()) {
            HashMap infoForFile = (HashMap)lastLoggedBytesTransferred.get(key);
            long bytesDelta = 0L;
            if (infoForFile != null) {
                Long current = (Long)infoForFile.get(CURRENT_BYTES_TRANSFERRED);
                Long first = (Long)infoForFile.get(FIRST_BYTES_TRANSFERRED);
                if (current != null && first != null && current > first) {
                    bytesDelta = current - first;
                }
            }
            totalBytes += bytesDelta;
        }
        return new Long(totalBytes);
    }

    public static Long totalBytesOnServerForAllFiles() {
        if (lastLoggedBytesTransferred == null) {
            return null;
        }
        if (lastLoggedBytesTransferred.size() == 0) {
            return new Long(0L);
        }
        long totalBytes = 0L;
        for (String key : lastLoggedBytesTransferred.keySet()) {
            HashMap infoForFile = (HashMap)lastLoggedBytesTransferred.get(key);
            long bytes = 0L;
            if (infoForFile != null) {
                if (infoForFile.get(CURRENT_BYTES_TRANSFERRED) == null) {
                    Long first = (Long)infoForFile.get(FIRST_BYTES_TRANSFERRED);
                    if (first != null) {
                        bytes = first;
                    }
                } else {
                    Long current = (Long)infoForFile.get(CURRENT_BYTES_TRANSFERRED);
                    bytes = current;
                }
            }
            totalBytes += bytes;
        }
        return new Long(totalBytes);
    }
}

