/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.arg.WebServiceArgument;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.StreamUtil;
import java.io.IOException;
import java.util.Map;

public class TransportLog
implements WebServiceArgument {
    private final String argKey;
    private final String logString;

    TransportLog(String argKey, String logString) {
        this.argKey = argKey;
        this.logString = logString;
    }

    @Override
    public void addToArgumentsMap(Map<String, Object> args) {
        args.put(this.argKey, this.logString);
    }

    public static TransportLog extraTransportLog(String extraTransportLog) {
        if (extraTransportLog == null || extraTransportLog.isEmpty()) {
            return null;
        }
        if (System.getProperty("disableParameterCompression") == null) {
            try {
                return new TransportLog("ExtraTransportLogCompressed", StreamUtil.bytesToBase64Gzip(TransportLog.stripControlChars(extraTransportLog).getBytes("utf-8")));
            }
            catch (IOException e) {
                Logger.info("Failed to compress transporter extra log; sending raw bytes");
            }
        }
        return new TransportLog("ExtraTransportLog", extraTransportLog);
    }

    static String stripControlChars(String in) {
        if (in == null) {
            return null;
        }
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (!Character.isIdentifierIgnorable(c)) continue;
            in = in.replace(c, ' ');
        }
        return in;
    }
}

