/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.log.LogMessageType;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.VerifyProgressReporter;
import com.apple.transporter.util.JSONMessageLogger;
import java.util.HashMap;

public class NetworkStatusReporter {
    public final String PAUSED_DESCRIPTION = "Operation Paused.";
    private final String reachableMessage;
    private final VerifyProgressReporter vpr;

    public NetworkStatusReporter(String reachableMessage, VerifyProgressReporter vpr) {
        this.reachableMessage = reachableMessage;
        this.vpr = vpr;
    }

    public NetworkStatusReporter(String reachableMessage) {
        this.reachableMessage = reachableMessage;
        this.vpr = null;
    }

    public void logReachability(boolean isReachable) {
        if (null != this.vpr && isReachable) {
            this.vpr.logVerifyProgress(this.reachableMessage);
            return;
        }
    }

    private void logJSON(boolean isReachable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (isReachable) {
            map.put("description", this.reachableMessage);
            map.put("paused", Boolean.FALSE);
        } else {
            map.put("description", "Operation Paused.");
            map.put("original", this.reachableMessage);
            map.put("paused", Boolean.TRUE);
        }
        JSONMessageLogger.info(LogMessageType.NETWORK_STATUS, map);
    }

    private void logText(boolean isReachable) {
        if (isReachable) {
            Logger.info(this.reachableMessage);
        } else {
            Logger.info("Operation Paused.");
        }
    }
}

