/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.LogCache;
import com.apple.transporter.log.TransportLog;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.LoggerFactory;

public class Logger {
    public static final String ErrorMessageLoggedNotification = "ErrorMessageLogged";
    public static final String WarnMessageLoggedNotification = "WarnMessageLogged";
    public static final String InfoMessageLoggedNotification = "InfoMessageLogged";
    private static org.slf4j.Logger logger;
    private static org.apache.log4j.Logger rootLogger;
    private static Appender consoleAppender;
    private static Appender fileAppender;
    private static PrintStream logHistoryStream;
    private static boolean isExtremeLogging;
    private static Logger sharedInstance;
    private static String timestampFormatString;
    private Map<String, Map<String, ?>> uploadedFilesInfo;
    private String packageName;
    private static LogCache logCache;
    private static boolean doLogCaching;
    private static boolean notificationsAdded;
    private static PrintWriter _SystemOutUTF8;
    private static File errorLogsBasePath;
    private static volatile File currentPackageLogFile;
    private static volatile Writer currentPackageLogStream;

    private static PrintWriter SystemOutUTF8() {
        if (_SystemOutUTF8 == null) {
            try {
                _SystemOutUTF8 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return _SystemOutUTF8;
    }

    public static boolean configureLogging() {
        String logHistoryFilePath;
        File logHistoryFile;
        String logFilePath;
        File logFile;
        System.setProperty("log4j.ignoreTCL", "true");
        Properties props = new Properties();
        try {
            BasicConfigurator.resetConfiguration();
            Logger.setDefaultProperties(props);
            PropertyConfigurator.configure((Properties)props);
        }
        catch (Exception e) {
            BasicConfigurator.configure();
        }
        rootLogger = org.apache.log4j.Logger.getRootLogger();
        consoleAppender = rootLogger.getAppender("console");
        fileAppender = rootLogger.getAppender("file");
        String outputFormat = System.getProperty("outputFormat");
        if (outputFormat != null && outputFormat.equalsIgnoreCase("xml")) {
            ((ConsoleAppender)consoleAppender).setTarget("System.err");
        }
        String logLevel = System.getProperty("v");
        isExtremeLogging = false;
        if (logLevel != null && (logLevel.equals("eXtreme") || logLevel.equals("extreme"))) {
            isExtremeLogging = true;
        } else if (logLevel == null) {
            isExtremeLogging = true;
        }
        if (logLevel == null || !isExtremeLogging) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        } else if (isExtremeLogging) {
            String simpleLogDefaultLog = System.getProperty("simpleLogDefaultLog");
            if (simpleLogDefaultLog == null || simpleLogDefaultLog.length() == 0) {
                simpleLogDefaultLog = "error";
            }
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.defaultlog", simpleLogDefaultLog);
        }
        logger = LoggerFactory.getLogger(Logger.class);
        if (logLevel != null && logLevel.length() > 0) {
            if (isExtremeLogging) {
                rootLogger.setLevel(org.apache.log4j.Level.TRACE);
                Logger.info("Logging level set to eXtreme");
            } else if (logLevel.equals("detailed")) {
                rootLogger.setLevel(org.apache.log4j.Level.DEBUG);
                Logger.info("Logging level set to detailed");
            } else if (logLevel.equals("informational")) {
                rootLogger.setLevel(org.apache.log4j.Level.INFO);
                Logger.info("Logging level set to informational");
            } else if (logLevel.equals("critical")) {
                rootLogger.setLevel(org.apache.log4j.Level.ERROR);
                Logger.info("Logging level set to critical");
            } else if (logLevel.equals("off")) {
                rootLogger.setLevel(org.apache.log4j.Level.OFF);
                Logger.info("Logging level set to off");
            } else {
                Logger.SystemOutUTF8().println("Unknown logging level: " + logLevel + " specified. Defaulting to critical.");
                Logger.SystemOutUTF8().println("  valid choices are: off, detailed, informational, critical");
            }
        }
        if ((logFile = Logger.validateAndCreateLogFile(logFilePath = System.getProperty("o"))) != null) {
            if (fileAppender != null) {
                ((FileAppender)fileAppender).setFile(logFile.getPath());
                ((FileAppender)fileAppender).activateOptions();
                Logger.info("Logging to file: " + logFile.getPath());
            }
        } else if (fileAppender != null) {
            rootLogger.removeAppender(fileAppender);
            fileAppender = null;
        }
        if ((logHistoryFile = Logger.validateAndCreateLogFile(logHistoryFilePath = System.getProperty("loghistory"))) != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(logHistoryFile);
                logHistoryStream = new PrintStream(outputStream);
            }
            catch (FileNotFoundException fnfe) {
                Logger.error("An error occurred while creating the print stream to the log history file.", fnfe);
                return false;
            }
            catch (Throwable t) {
                Logger.error("An error occurred while creating the print stream to the log history file.", t);
                return false;
            }
            if (!notificationsAdded) {
                NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
                defaultCenter.addObserver(Logger.sharedInstance(), "gatherUploadFilesInfo", "FinishedUploadOfFilesInPackage", null);
                defaultCenter.addObserver(Logger.sharedInstance(), "logSuccessfulUploadPackageFiles", "PackageUploadSucceeded", null);
                notificationsAdded = true;
            }
        }
        Logger.clearLogCache();
        return true;
    }

    private static void setDefaultProperties(Properties props) {
        String conversionPattern = "[%d{yyyy-MM-dd HH:mm:ss zzz}] <%t> %m%n";
        props.setProperty("log4j.rootLogger", "trace, console, file");
        props.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.console.target", "System.err");
        props.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.console.layout.ConversionPattern", conversionPattern);
        props.setProperty("log4j.appender.console.encoding", "UTF-8");
        props.setProperty("log4j.appender.file", "org.apache.log4j.FileAppender");
        props.setProperty("log4j.appender.file.encoding", "UTF-8");
        try {
            File tempFile = File.createTempFile("temp", null);
            tempFile.deleteOnExit();
            props.setProperty("log4j.appender.file.file", tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        props.setProperty("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.file.layout.ConversionPattern", conversionPattern);
        props.setProperty("log4j.logger.com.asperasoft", "warn");
        props.setProperty("log4j.logger.aspera", "warn");
        props.setProperty("log4j.logger.com.apple.jingle.leghorn", "warn");
        props.setProperty("log4j.logger.com.webobjects", "warn");
        props.setProperty("log4j.logger.org.apache.http", "warn");
        props.setProperty("log4j.logger.org.apache.http.wire", "warn");
    }

    public static String stackTraceToString(Throwable aThrowable) {
        if (aThrowable != null) {
            StringWriter stackTraceSW = new StringWriter();
            aThrowable.printStackTrace(new PrintWriter(stackTraceSW));
            return stackTraceSW.toString();
        }
        return "";
    }

    public static void extreme(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = "DBG-X: " + logMsg;
        if (logger != null) {
            logger.trace(message);
        }
        Logger.appendToLogCache(message);
    }

    public static void extreme(String logMsg, Throwable aThrowable) {
        Logger.extreme(logMsg);
        if (aThrowable != null) {
            Logger.extreme("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, true);
    }

    public static void debug(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = "DEBUG: " + logMsg;
        if (logger != null) {
            logger.debug(message);
        }
        Logger.appendToLogCache(message);
    }

    public static void debug(String logMsg, Throwable aThrowable) {
        Logger.debug(logMsg);
        if (aThrowable != null) {
            Logger.debug("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, true);
    }

    public static void infoMessage(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = " INFO-X: " + logMsg;
        if (logger != null) {
            logger.info(message);
        }
        Logger.appendToLogCache(message);
        Logger.postLogNotification(logMsg, Level.Info, InfoMessageLoggedNotification);
    }

    public static void info(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = " INFO: " + logMsg;
        if (logger != null) {
            logger.info(message);
        }
        Logger.appendToLogCache(message);
    }

    public static void info(String logMsg, Throwable aThrowable) {
        Logger.info(logMsg);
        if (aThrowable != null) {
            Logger.info("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, true);
    }

    public static void warn(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = " WARN: " + logMsg;
        if (logger != null) {
            logger.warn(message);
        }
        Logger.appendToLogCache(message);
        Logger.postLogNotification(logMsg, Level.Warn, WarnMessageLoggedNotification);
    }

    public static void warn(String logMsg, Throwable aThrowable) {
        Logger.warn(logMsg);
        if (aThrowable != null) {
            Logger.warn("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, true);
    }

    public static void error(String logMsg) {
        Logger.error(logMsg, true);
    }

    public static void error(String logMsg, boolean postNotification) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = "ERROR: " + logMsg;
        if (logger != null) {
            logger.error(message);
        }
        Logger.appendToLogCache(message);
        if (postNotification) {
            Logger.postLogNotification(logMsg, Level.Error, ErrorMessageLoggedNotification);
        }
    }

    public static void error(String logMsg, Throwable aThrowable) {
        Logger.error(logMsg, aThrowable, true);
    }

    public static void error(String logMsg, Throwable aThrowable, boolean postNotification) {
        Logger.error(logMsg, postNotification);
        if (aThrowable != null) {
            Logger.error("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, postNotification);
    }

    public static void fatal(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        String message = "ERROR: " + logMsg;
        if (logger != null) {
            logger.error(message);
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification(ErrorMessageLoggedNotification, logMsg, null);
        Logger.appendToLogCache(message);
    }

    public static void fatal(String logMsg, Throwable aThrowable) {
        Logger.fatal(logMsg);
        if (aThrowable != null) {
            Logger.fatal("An exception has occurred: " + aThrowable.getMessage());
        }
        Logger.showExceptionInfo(aThrowable, true);
    }

    public static void essential(String logMsg) {
        if (logMsg == null || logMsg.length() == 0) {
            return;
        }
        Logger.appendToLogCache(logMsg);
        Logger.SystemOutUTF8().println(logMsg);
        if (rootLogger != null) {
            if (consoleAppender != null) {
                rootLogger.removeAppender(consoleAppender);
            }
            if (fileAppender != null) {
                PatternLayout patternLayout = (PatternLayout)fileAppender.getLayout();
                String oldConversionPattern = patternLayout.getConversionPattern();
                patternLayout.setConversionPattern("%m%n");
                if (logger != null) {
                    logger.error(logMsg);
                }
                patternLayout.setConversionPattern(oldConversionPattern);
            }
            if (consoleAppender != null) {
                rootLogger.addAppender(consoleAppender);
            }
        }
    }

    private static void postLogNotification(String logMsg, Level level, String loggedNotification) {
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        Notification notification = new Notification(loggedNotification, logMsg);
        notification.getUserInfo().put("logLevel", (Object)level);
        defaultCenter.postNotification(notification);
    }

    public static void closeLogPrintStream() {
        if (logHistoryStream != null) {
            logHistoryStream.close();
        }
    }

    private static File validateAndCreateLogFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        try {
            filePath = FileUtil.absolutePathForPath(filePath);
        }
        catch (IOException ioe) {
            Logger.error("Could not get the full log file path.  No log file will be created.", ioe);
            return null;
        }
        File logFile = new File(filePath);
        File logFileDir = null;
        logFileDir = logFile.getParentFile();
        if (logFileDir != null && !logFileDir.exists()) {
            Logger.error("The directory: " + logFileDir.getPath() + " for the log file does NOT exist.");
            return null;
        }
        if (logFileDir != null && !logFileDir.canWrite()) {
            Logger.error("The directory: " + logFileDir.getPath() + " is NOT writable.");
            return null;
        }
        if (logFile != null && logFile.exists() && !logFile.canWrite()) {
            Logger.error("The file: " + logFile.getPath() + " is NOT writable.");
            return null;
        }
        if (logFile.isDirectory()) {
            Logger.error("The file: " + logFile.getPath() + " is a directory and can NOT be used.");
            return null;
        }
        if (logFile != null && logFile.exists()) {
            Logger.info("The log file: " + logFile.getPath() + " already exists.  It will be overwritten.");
        }
        return logFile;
    }

    public static Logger sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new Logger();
        }
        return sharedInstance;
    }

    public void gatherUploadFilesInfo(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        this.uploadedFilesInfo = (Map)aNotification.getObject();
        Map<String, Object> userInfo = aNotification.getUserInfo();
        ITMSPackage aPkg = null;
        if (userInfo != null) {
            aPkg = (ITMSPackage)userInfo.get("Package");
        }
        this.packageName = aPkg != null ? aPkg.packageName() : null;
    }

    public void logSuccessfulUploadPackageFiles(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        if (this.uploadedFilesInfo == null || this.uploadedFilesInfo.size() == 0) {
            return;
        }
        for (String fileName : this.uploadedFilesInfo.keySet()) {
            Map<String, ?> fileInfoDict = this.uploadedFilesInfo.get(fileName);
            Long fileDateAsLong = (Long)fileInfoDict.get("RemoteFileLastModified");
            Long fileSize = (Long)fileInfoDict.get("RemoteFileSize");
            SimpleDateFormat formatter = new SimpleDateFormat(timestampFormatString);
            Date date = new Date(fileDateAsLong);
            String formattedDate = formatter.format(date);
            String packageAndFileName = fileName;
            if (this.packageName != null) {
                packageAndFileName = NSPathUtilities.stringByAppendingPathComponent(this.packageName, fileName);
            }
            String delimitedFileInfo = packageAndFileName + "\t" + formattedDate + "\t" + fileSize;
            logHistoryStream.println(delimitedFileInfo);
        }
    }

    private static void showExceptionInfo(Throwable aThrowable, boolean postNotification) {
        if (aThrowable == null) {
            return;
        }
        Logger.debug(Logger.stackTraceToString(aThrowable));
    }

    public static void startCachingLogMessages() {
        doLogCaching = true;
    }

    public static void stopCachingLogMessages() {
        doLogCaching = false;
    }

    public static void clearLogCache() {
        logCache = null;
    }

    public static TransportLog logCache() {
        if (logCache == null) {
            return null;
        }
        TransportLog response = logCache.transportLog();
        logCache = null;
        return response;
    }

    public static synchronized void appendToLogCache(String aString) {
        if (doLogCaching || currentPackageLogStream != null) {
            String stringToAppend;
            block15: {
                if (aString == null) {
                    return;
                }
                if (doLogCaching && logCache == null) {
                    logCache = LogCache.createLogCache(logger);
                }
                String truncString = aString;
                if (doLogCaching && Logger.shouldTruncateInputOutputLogs()) {
                    int maxLength = Logger.maxInputOutputLogEntrySize();
                    if (aString.length() > maxLength) {
                        truncString = aString.substring(0, maxLength) + "...";
                    }
                }
                stringToAppend = aString;
                String truncStringToAppend = truncString;
                try {
                    if (doLogCaching) {
                        truncStringToAppend = new String(truncString.getBytes("UTF-8"), "UTF-8");
                    }
                    if (currentPackageLogStream != null) {
                        stringToAppend = new String(aString.getBytes("UTF-8"), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    Logger.error("An error occurred while converting a string to UTF-8 for the logCache.  Will use the logCache string as-is.", uee);
                }
                if (doLogCaching) {
                    truncStringToAppend = String.format("[%1$tF %1$tT %1$tZ] %2$s\n", new Date(), truncStringToAppend);
                    try {
                        logCache.write(truncStringToAppend);
                    }
                    catch (IOException e) {
                        if (logger == null) break block15;
                        logger.trace("error writing to log cache", (Throwable)e);
                    }
                }
            }
            if (currentPackageLogStream != null) {
                stringToAppend = String.format("[%1$tF %1$tT %1$tZ] %2$s\n", new Date(), stringToAppend);
                try {
                    currentPackageLogStream.append(stringToAppend);
                }
                catch (IOException e) {
                    Logger.releaseLogFileResources();
                    Logger.error("error writing to per-upload log file", e);
                }
            }
        }
    }

    public static String errorLogsPathFromProperty() {
        String destOption = System.getProperty("errorLogs");
        File destFile = null;
        if (destOption != null && destOption.length() != 0) {
            destFile = new File(destOption);
        }
        try {
            destOption = FileUtil.absolutePathForFile(destFile);
        }
        catch (IOException ioe) {
            Logger.error("Cannot get the full destination path.", ioe);
            destOption = null;
        }
        String destPath = "";
        if (destOption != null && destOption.length() > 0) {
            File aFile = new File(destOption);
            destPath = aFile.getAbsolutePath();
        }
        return destPath;
    }

    public static void setErrorLogsPath(String destPath) {
        errorLogsBasePath = new File(destPath);
    }

    private static void releaseLogFileResources() {
        if (currentPackageLogStream != null) {
            try {
                currentPackageLogStream.close();
            }
            catch (IOException e) {
                Logger.error("Unable to close per-upload log file", e);
            }
            currentPackageLogStream = null;
        }
        currentPackageLogFile = null;
    }

    public static void startLogFileForPackage(File aPkgFile) {
        Logger.releaseLogFileResources();
        if (errorLogsBasePath != null) {
            currentPackageLogFile = new File(errorLogsBasePath, aPkgFile.getName() + ".log");
            try {
                if (currentPackageLogFile.createNewFile() && !currentPackageLogFile.canWrite() || !currentPackageLogFile.exists()) {
                    Logger.error("unable to create per-upload log file");
                    return;
                }
                currentPackageLogStream = new FileWriter(currentPackageLogFile);
            }
            catch (IOException e) {
                currentPackageLogFile = null;
                Logger.error("Unable to create per-upload log file", e);
            }
        }
    }

    public static void cleanupLogFileForPackage(boolean success) {
        File logFile = currentPackageLogFile;
        Logger.releaseLogFileResources();
        if (success && logFile != null && !logFile.delete()) {
            logFile.deleteOnExit();
        }
    }

    private static boolean shouldTruncateInputOutputLogs() {
        return !Boolean.getBoolean("disableInputOutputLogEntryTruncation");
    }

    private static int maxInputOutputLogEntrySize() {
        return Integer.getInteger("maxInputOutputLogEntrySize", 0x100000);
    }

    static {
        timestampFormatString = "EEE MMMMM dd HH:mm:ss zzz yyyy";
        logCache = null;
        notificationsAdded = false;
    }

    public static enum Level {
        Info,
        Warn,
        Error;

    }
}

