/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.Application;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.TransportLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public abstract class LogCache {
    private static int _startLogCacheMemorySize = 0xA00000;
    private static boolean startLogCacheMemorySizeInitialized = false;
    final Writer writer;

    LogCache(Writer writer) {
        this.writer = writer;
    }

    public abstract TransportLog transportLog();

    void write(String message) throws IOException {
        this.writer.write(TransportLog.stripControlChars(message));
    }

    static LogCache createLogCache(org.slf4j.Logger logger) {
        if (System.getProperty("disableParameterCompression") == null && Application.modeSupportsLogCompression()) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(LogCache.startLogCacheMemorySize());
            try {
                GZIPOutputStream logCacheZipStream = new GZIPOutputStream(byteStream);
                return new CompressedLogCache(byteStream, new OutputStreamWriter(logCacheZipStream));
            }
            catch (IOException e) {
                logger.trace("unable to compress log stream", (Throwable)e);
            }
        }
        return new PlaintextLogCache();
    }

    private static int startLogCacheMemorySize() {
        if (!startLogCacheMemorySizeInitialized) {
            String propName = "com.apple.transporter.log.startLogCacheMemorySize";
            String s = System.getProperty("com.apple.transporter.log.startLogCacheMemorySize");
            if (s != null) {
                try {
                    int size = Integer.parseInt(s);
                    if (size > 0) {
                        _startLogCacheMemorySize = size;
                    }
                    startLogCacheMemorySizeInitialized = true;
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid value for property com.apple.transporter.log.startLogCacheMemorySize");
                }
            }
        }
        return _startLogCacheMemorySize;
    }

    private static class CompressedLogCache
    extends LogCache {
        private final ByteArrayOutputStream byteStream;

        CompressedLogCache(ByteArrayOutputStream byteStream, Writer writer) {
            super(writer);
            this.byteStream = byteStream;
        }

        @Override
        public TransportLog transportLog() {
            return new TransportLog("TransportLogCompressed", this.byteStreamAsBase64());
        }

        private String byteStreamAsBase64() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                Logger.extreme("unable to close log stream", e);
            }
            try {
                return new String(Base64.encodeBase64((byte[])this.byteStream.toByteArray()), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.extreme("utf-8 is not supported", e);
                return null;
            }
        }
    }

    private static class PlaintextLogCache
    extends LogCache {
        PlaintextLogCache() {
            super(new StringWriter());
        }

        @Override
        public TransportLog transportLog() {
            return new TransportLog("TransportLog", ((StringWriter)this.writer).toString());
        }
    }
}

