/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.log.Logger;
import com.apple.transporter.util.CopyListener;
import java.text.NumberFormat;

public class DownloadProgressReporter
implements CopyListener {
    private static final float MIN_FILE_UPLOAD_PROGRESS_PERCENT = 0.01f;
    private String filename;
    private long fileSize;
    private long totalBytesCopied;
    private float lastLoggedPercentage;

    public DownloadProgressReporter(String aName, long aSize) {
        this.filename = aName;
        this.fileSize = aSize;
        this.totalBytesCopied = 0L;
        this.lastLoggedPercentage = 0.0f;
    }

    @Override
    public void numberOfBytesCopied(long numBytesJustCopied) {
        this.totalBytesCopied += numBytesJustCopied;
        this.logProgressIfNeeded();
    }

    private void logProgressIfNeeded() {
        if (this.fileSize <= 0L) {
            Logger.info("     File: " + this.filename + ",  " + this.totalBytesCopied + " bytes downloaded");
            return;
        }
        try {
            float percentComplete = (float)this.totalBytesCopied / (float)this.fileSize;
            NumberFormat df = NumberFormat.getPercentInstance();
            df.setMaximumFractionDigits(2);
            String percentCompleteRounded = df.format(percentComplete);
            if (percentComplete - this.lastLoggedPercentage > 0.01f || percentComplete == 1.0f) {
                if (percentComplete != 1.0f) {
                    this.lastLoggedPercentage = (float)Math.floor(percentComplete / 0.01f) * 0.01f;
                }
                Logger.info("     File: " + this.filename + " " + this.totalBytesCopied + "/" + this.fileSize + ", " + percentCompleteRounded + " completed");
            }
        }
        catch (RuntimeException re) {
            Logger.error("An error occurred while reporting the download progress of the file '" + this.filename + "'.", re);
        }
    }
}

