/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.log;

import com.apple.transporter.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ColumnarOutputFormatter {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final List<OutputColumn<?>> columns;
    private final int spacesBetweenColums;

    public ColumnarOutputFormatter(List<OutputColumn<?>> columns, int spacesBetweenColums) {
        this.columns = columns;
        this.spacesBetweenColums = spacesBetweenColums;
    }

    public boolean processRows(@Nonnull List<Map<String, Object>> rows) {
        if (!rows.isEmpty()) {
            for (Map<String, Object> map : rows) {
                for (OutputColumn<?> outputColumn : this.columns) {
                    outputColumn.setWidthByCheckingValueForRow(map);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (OutputColumn<?> col : this.columns) {
                col.appendHeaderValue(sb, this.spacesBetweenColums);
            }
            Logger.essential(sb.toString());
            sb.setLength(0);
            for (OutputColumn<?> col : this.columns) {
                col.appendUnderline(sb, this.spacesBetweenColums);
            }
            Logger.essential(sb.toString());
            ArrayList arrayList = new ArrayList();
            for (Map map : rows) {
                sb.setLength(0);
                arrayList.clear();
                for (OutputColumn<?> col : this.columns) {
                    Pair<?, String[]> wrappedCol = col.appendValueForRow(sb, map, this.spacesBetweenColums);
                    if (null == wrappedCol) continue;
                    arrayList.add(wrappedCol);
                }
                Logger.essential(sb.toString());
                sb.setLength(0);
                this.processWrappedColumns(sb, arrayList, this.spacesBetweenColums);
                if (sb.length() <= 0) continue;
                Logger.essential(sb.toString());
            }
        }
        return true;
    }

    private void processWrappedColumns(StringBuilder sb, List<Pair<?, String[]>> wrappedCols, int spaceBetweenColumns) {
        if (wrappedCols.isEmpty()) {
            return;
        }
        ArrayList nextWrappedCols = new ArrayList();
        for (OutputColumn<?> column : this.columns) {
            if (wrappedCols.isEmpty()) {
                column.appendEmptyData(sb, spaceBetweenColumns);
                continue;
            }
            Pair<?, String[]> wc = wrappedCols.get(0);
            if (column == wc.getLeft()) {
                wrappedCols.remove(0);
                Pair<?, String[]> next = column.appendWrappedValue(sb, wc);
                if (next == null) continue;
                nextWrappedCols.add(next);
                continue;
            }
            column.appendEmptyData(sb, spaceBetweenColumns);
        }
        if (!nextWrappedCols.isEmpty()) {
            sb.append(LINE_SEP);
        }
        this.processWrappedColumns(sb, nextWrappedCols, spaceBetweenColumns);
    }

    public static class OutputColumn<InputType> {
        public final String header;
        public final String key;
        public final InputType defaultValue;
        private int width;
        private int maxWidth;
        private String formatString;
        private Alignment alignment = Alignment.LEFT;
        private OutputFormatter<InputType> outputFormmater;

        public OutputColumn(String header, String key, InputType defaultValue, int maxWidth) {
            this.header = header;
            this.key = key;
            this.defaultValue = defaultValue;
            this.maxWidth = maxWidth;
            if (header.length() > maxWidth) {
                throw new IllegalArgumentException("maxWidth cannot be smaller than header length");
            }
            this.setWidthByCheckingValue(header);
        }

        public OutputColumn(String header, String key, InputType defaultValue) {
            this(header, key, defaultValue, Integer.MAX_VALUE);
        }

        public OutputColumn<InputType> setAlignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public OutputColumn<InputType> setOutputFormatter(OutputFormatter<InputType> outputFormmater) {
            this.outputFormmater = outputFormmater;
            return this;
        }

        private void setWidthByCheckingValue(Object obj) {
            if (null != obj) {
                this.width = Math.max(this.width, obj.toString().length());
                this.width = Math.min(this.width, this.maxWidth);
            }
        }

        public InputType getOrDefault(Map<String, Object> row) {
            Object val = row.get(this.key);
            if (null != val) {
                return (InputType)val;
            }
            return this.defaultValue;
        }

        public void setWidthByCheckingValueForRow(Map<String, Object> row) {
            InputType value = this.getOrDefault(row);
            if (null != this.outputFormmater) {
                List<String> strings = this.outputFormmater.format(value);
                for (String s : strings) {
                    this.setWidthByCheckingValue(s);
                }
            } else {
                this.setWidthByCheckingValue(value);
            }
        }

        public void appendHeaderValue(StringBuilder sb, int spaceBetweenColumns) {
            if (null == this.formatString) {
                this.formatString = "%-" + (this.width + spaceBetweenColumns) + "s";
            }
            sb.append(String.format(this.formatString, this.header));
        }

        public void appendUnderline(StringBuilder sb, int spaceBetweenColumns) {
            sb.append(StringUtils.repeat((char)'-', (int)this.width));
            sb.append(StringUtils.repeat((char)' ', (int)spaceBetweenColumns));
        }

        public void appendEmptyData(StringBuilder sb, int spaceBetweenColumns) {
            sb.append(StringUtils.repeat((char)' ', (int)(this.width + spaceBetweenColumns)));
        }

        private Pair<?, String[]> wrapIfNecessary(StringBuilder sb, Object value, int spaceBetweenColumns) {
            String s = String.format(this.formatString, value);
            int w = s.length();
            if (w > this.maxWidth) {
                String wrapped = WordUtils.wrap((String)s, (int)this.maxWidth, (String)LINE_SEP, (boolean)true);
                String[] splitWrapped = wrapped.split(LINE_SEP);
                return this.appendWrappedValue(sb, Pair.of((Object)this, (Object)splitWrapped));
            }
            if (this.alignment == Alignment.LEFT) {
                sb.append(s);
            } else if (this.alignment == Alignment.CENTER) {
                if (null == value) {
                    sb.append(s);
                } else {
                    String centered = StringUtils.center((String)value.toString(), (int)this.width);
                    sb.append(centered);
                    sb.append(StringUtils.repeat((char)' ', (int)spaceBetweenColumns));
                }
            } else if (this.alignment == Alignment.RIGHT) {
                if (null == value) {
                    sb.append(s);
                } else {
                    String right = StringUtils.leftPad((String)value.toString(), (int)this.width);
                    sb.append(right);
                    sb.append(StringUtils.repeat((char)' ', (int)spaceBetweenColumns));
                }
            }
            return null;
        }

        public Pair<?, String[]> appendValueForRow(StringBuilder sb, Map<String, Object> row, int spaceBetweenColumns) {
            InputType value = this.getOrDefault(row);
            if (null == this.outputFormmater) {
                return this.wrapIfNecessary(sb, value, spaceBetweenColumns);
            }
            List<String> strings = this.outputFormmater.format(value);
            if (null == strings || strings.isEmpty()) {
                return this.wrapIfNecessary(sb, "", spaceBetweenColumns);
            }
            if (strings.size() == 1) {
                return this.wrapIfNecessary(sb, strings.get(0), spaceBetweenColumns);
            }
            ArrayList<String> resultingStrings = new ArrayList<String>();
            for (String s : strings) {
                String[] splitWrapped;
                if (null == s) {
                    s = "";
                }
                String wrapped = WordUtils.wrap((String)s, (int)this.maxWidth, (String)LINE_SEP, (boolean)true);
                for (String ws : splitWrapped = wrapped.split(LINE_SEP)) {
                    String centered;
                    if (this.alignment == Alignment.LEFT) {
                        resultingStrings.add(String.format(this.formatString, ws));
                        continue;
                    }
                    if (this.alignment == Alignment.CENTER) {
                        centered = StringUtils.center((String)ws, (int)this.width) + StringUtils.repeat((char)' ', (int)spaceBetweenColumns);
                        resultingStrings.add(centered);
                        continue;
                    }
                    if (this.alignment != Alignment.RIGHT) continue;
                    centered = StringUtils.leftPad((String)ws, (int)this.width) + StringUtils.repeat((char)' ', (int)spaceBetweenColumns);
                    resultingStrings.add(centered);
                }
            }
            sb.append((String)resultingStrings.remove(0));
            String[] array = new String[resultingStrings.size()];
            int i = 0;
            Iterator iterator = resultingStrings.iterator();
            while (iterator.hasNext()) {
                String s;
                array[i] = s = (String)iterator.next();
                ++i;
            }
            return Pair.of((Object)this, (Object)array);
        }

        public Pair<?, String[]> appendWrappedValue(StringBuilder sb, Pair<?, String[]> wrappedInfo) {
            String[] s = (String[])wrappedInfo.getRight();
            if (s.length == 0) {
                sb.append(String.format(this.formatString, ""));
                return null;
            }
            sb.append(String.format(this.formatString, s[0]));
            if (s.length > 1) {
                String[] result = new String[s.length - 1];
                for (int i = 1; i < s.length; ++i) {
                    result[i - 1] = String.format(this.formatString, s[i]);
                }
                return Pair.of((Object)this, (Object)result);
            }
            return null;
        }
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static interface OutputFormatter<InputType> {
        public List<String> format(InputType var1);
    }
}

