/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.foundation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Selector {
    private String _methodName;
    private Class<?>[] _parameterTypes;

    public Selector(String methodName) {
        this(methodName, null);
    }

    public Selector(String methodName, Class<?>[] parameterTypes) {
        this._methodName = methodName;
        this._parameterTypes = parameterTypes;
    }

    public int hashCode() {
        int hashCode = this._methodName.hashCode() << 8;
        if (this._parameterTypes != null) {
            hashCode |= this._parameterTypes.hashCode() & 0xFF;
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Selector)) {
            return false;
        }
        Selector other = (Selector)object;
        return this._methodName.equals(other.getName()) && (this._parameterTypes != null ? this._parameterTypes.equals(other.getParameterTypes()) : this._parameterTypes == other.getParameterTypes());
    }

    public boolean isImplementedByClass(Class<?> targetClass) {
        Method method = this.getMethodOnClass(targetClass);
        return method != null;
    }

    public boolean isImplementedByObject(Object target) {
        return this.isImplementedByClass(target.getClass());
    }

    public Object invoke(Object target, Object[] arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = this.getMethodOnObject(target);
        if (method == null) {
            throw new NoSuchMethodException(this.toString());
        }
        method.invoke(target, arguments);
        return null;
    }

    public Object invoke(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, null);
    }

    public Object invoke(Object target, Object argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, new Object[]{argument});
    }

    public Object invoke(Object target, Object argument1, Object argument2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, new Object[]{argument1, argument2});
    }

    public Method getMethodOnClass(Class<?> targetClass) {
        Method method = null;
        try {
            method = targetClass.getMethod(this._methodName, this._parameterTypes);
        }
        catch (SecurityException e) {
            method = null;
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }

    public Method getMethodOnObject(Object target) {
        Class<?> targetClass = target.getClass();
        return this.getMethodOnClass(targetClass);
    }

    public String getName() {
        return this._methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this._parameterTypes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this._methodName);
        buf.append("(");
        if (this._parameterTypes != null) {
            for (int i = 0; i < this._parameterTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = this._parameterTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

