/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.foundation;

import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationObserver;
import com.apple.transporter.foundation.Selector;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class NotificationCenter {
    private static NotificationCenter _defaultCenter = null;
    private Map<String, ObserverRegistrations> _observers = new HashMap<String, ObserverRegistrations>();
    private static final Class[] _notificationSelectorTypes;

    public static NotificationCenter defaultCenter() {
        return _defaultCenter;
    }

    public void addObserver(NotificationObserver observer, String notificationName, Object object) {
        this.addObserver(observer, "handleNotification", notificationName, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Object observer, String methodName, String notificationName, Object object) {
        Map<String, ObserverRegistrations> map = this._observers;
        synchronized (map) {
            ObserverRegistrations observers = this._notificationObserversWithInsertion(notificationName);
            observers.addObserver(observer, methodName, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNotification(Notification notification) {
        String notificationName = notification.getName();
        List<ObserverRegistration> interestedObservers = null;
        Map<String, ObserverRegistrations> map = this._observers;
        synchronized (map) {
            ObserverRegistrations observers = this._notificationObservers(notificationName);
            if (observers != null) {
                interestedObservers = observers.getInterestedObservers(notification);
            }
        }
        this.dispatchNotificationToObservers(interestedObservers, notification);
    }

    public void postNotification(String notificationName, Object object) {
        this.postNotification(notificationName, object, null);
    }

    public void postNotification(String notificationName, Object object, Object context) {
        Notification notification = new Notification(notificationName, object, context);
        this.postNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Object observer) {
        Map<String, ObserverRegistrations> map = this._observers;
        synchronized (map) {
            Collection<ObserverRegistrations> values = this._observers.values();
            Iterator<ObserverRegistrations> iterator = values.iterator();
            ObserverRegistrations currentObservers = null;
            while (iterator.hasNext()) {
                currentObservers = iterator.next();
                currentObservers.removeObserver(observer);
            }
        }
        this.removeUnobserveredNotificationNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnobserveredNotificationNames() {
        Map<String, ObserverRegistrations> map = this._observers;
        synchronized (map) {
            HashSet<String> keySet = new HashSet<String>(this._observers.keySet());
            for (String key : keySet) {
                ObserverRegistrations observers = this._observers.get(key);
                if (observers.observerCount() != 0) continue;
                this._observers.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Object observer, String notificationName, Object object) {
        Map<String, ObserverRegistrations> map = this._observers;
        synchronized (map) {
            ObserverRegistrations observers = this._notificationObservers(notificationName);
            int count = 0;
            if (observers != null) {
                observers.removeObserver(observer, object);
                count = observers.observerCount();
            }
            if (count == 0) {
                this._observers.remove(notificationName);
            }
        }
    }

    public String toString() {
        this.removeUnobserveredNotificationNames();
        return this._observers.toString();
    }

    private void dispatchNotificationToObservers(List<ObserverRegistration> observers, Notification notification) {
        if (observers == null) {
            return;
        }
        Iterator<ObserverRegistration> iterator = observers.iterator();
        ObserverRegistration currentObserver = null;
        while (iterator.hasNext()) {
            currentObserver = iterator.next();
            currentObserver.postNotification(notification);
        }
    }

    private ObserverRegistrations _notificationObservers(String notificationName) {
        ObserverRegistrations observers = this._observers.get(notificationName);
        return observers;
    }

    private ObserverRegistrations _notificationObserversWithInsertion(String notificationName) {
        ObserverRegistrations observers = this._observers.get(notificationName);
        if (observers == null) {
            observers = new ObserverRegistrations(notificationName, this);
            this._observers.put(notificationName, observers);
        }
        return observers;
    }

    static {
        _defaultCenter = new NotificationCenter();
        _notificationSelectorTypes = new Class[]{Notification.class};
    }

    private class ObserverRegistrations {
        private String _notificationName;
        private List<ObserverRegistration> _observersForAllObjects;
        private Map<Object, List<ObserverRegistration>> _observersByObject;
        private Map<Object, List<ObserverRegistration>> _observersByObserver;
        private ReferenceQueue<Object> _referenceQueue;
        private WeakReference<NotificationCenter> _center;

        public ObserverRegistrations(String notificationName, NotificationCenter notificationCenter2) {
            this._notificationName = notificationName;
            this._observersForAllObjects = new ArrayList<ObserverRegistration>();
            this._observersByObject = new WeakHashMap<Object, List<ObserverRegistration>>();
            this._observersByObserver = new WeakHashMap<Object, List<ObserverRegistration>>();
            this._referenceQueue = new ReferenceQueue();
            this._center = new WeakReference<NotificationCenter>(notificationCenter2);
        }

        public List<ObserverRegistration> getInterestedObservers(Notification notification) {
            Object object = notification.getObject();
            this.removeNullObserversFromAllObjectsList();
            ArrayList<ObserverRegistration> results = new ArrayList<ObserverRegistration>(this._observersForAllObjects);
            if (object == null) {
                return results;
            }
            List<ObserverRegistration> observers = this._observersByObject.get(object);
            if (observers != null) {
                results.addAll(observers);
            }
            return results;
        }

        public int observerCount() {
            int count = this._observersForAllObjects.size();
            return count += this._observersByObserver.size();
        }

        private void removeNullObserversFromAllObjectsList() {
            Reference<Object> reference = this._referenceQueue.poll();
            if (reference == null) {
                return;
            }
            Iterator<ObserverRegistration> iterator = this._observersForAllObjects.iterator();
            while (iterator.hasNext()) {
                ObserverRegistration registration = iterator.next();
                if (registration.getObserver() != null) continue;
                iterator.remove();
            }
            NotificationCenter center = (NotificationCenter)this._center.get();
            if (center == null) {
                return;
            }
            center.removeUnobserveredNotificationNames();
        }

        public void addObserver(Object observer, String methodName, Object object) {
            ObserverRegistration addition = new ObserverRegistration(observer, methodName, object, this._referenceQueue);
            if (object == null) {
                this._observersForAllObjects.add(addition);
            } else {
                List<ObserverRegistration> objectCache = this._observersByObject.get(object);
                if (objectCache == null) {
                    objectCache = new ArrayList<ObserverRegistration>();
                    this._observersByObject.put(object, objectCache);
                }
                objectCache.add(addition);
            }
            List<ObserverRegistration> observerCache = this._observersByObserver.get(observer);
            if (observerCache == null) {
                observerCache = new ArrayList<ObserverRegistration>();
                this._observersByObserver.put(observer, observerCache);
            }
            observerCache.add(addition);
        }

        public void removeObserver(Object observer) {
            List<ObserverRegistration> observerCache = this._observersByObserver.get(observer);
            if (observerCache == null) {
                return;
            }
            Iterator<ObserverRegistration> iterator = observerCache.iterator();
            ObserverRegistration currentObserver = null;
            while (iterator.hasNext()) {
                currentObserver = iterator.next();
                Object object = currentObserver.getObject();
                if (object == null) {
                    this._observersForAllObjects.remove(currentObserver);
                    continue;
                }
                List<ObserverRegistration> objectCache = this._observersByObject.get(object);
                objectCache.remove(currentObserver);
                if (objectCache.size() != 0) continue;
                this._observersByObject.remove(object);
            }
            this._observersByObserver.remove(observer);
        }

        public void removeObserver(Object observer, Object object) {
            if (object == null) {
                this.removeObserver(observer);
                return;
            }
            List<ObserverRegistration> observerCache = this._observersByObserver.get(observer);
            if (observerCache == null) {
                return;
            }
            List<ObserverRegistration> objectCache = this._observersByObject.get(object);
            if (objectCache != null) {
                Iterator<ObserverRegistration> iterator = objectCache.iterator();
                ObserverRegistration currentObserver = null;
                while (iterator.hasNext()) {
                    currentObserver = iterator.next();
                    if (!observer.equals(currentObserver.getObserver())) continue;
                    iterator.remove();
                    observerCache.remove(currentObserver);
                }
                if (objectCache.size() == 0) {
                    this._observersByObject.remove(object);
                }
            }
            if (observerCache.size() == 0) {
                this._observersByObserver.remove(observer);
            }
        }

        public String toString() {
            this.removeNullObserversFromAllObjectsList();
            StringBuilder buffer = new StringBuilder("NAME: ");
            buffer.append(this._notificationName);
            buffer.append(", ALL: ");
            buffer.append(this._observersForAllObjects.toString());
            buffer.append(", OBJECT: ");
            buffer.append(this._observersByObject.toString());
            return buffer.toString();
        }
    }

    private class ObserverRegistration {
        private WeakReference<Object> _observer;
        private WeakReference<Object> _object;
        private Selector _selector;
        private Method _method;

        public ObserverRegistration(Object observer, String methodName, Object object, ReferenceQueue<Object> queue) {
            this._observer = new WeakReference<Object>(observer, queue);
            this._object = new WeakReference<Object>(object);
            this._selector = new Selector(methodName, _notificationSelectorTypes);
            this._method = this._selector.getMethodOnObject(observer);
            if (this._method == null) {
                throw new IllegalStateException("Observer does not implement the specified method: " + methodName + " observer: " + observer);
            }
        }

        public void postNotification(Notification notification) {
            try {
                Object observer = this.getObserver();
                if (observer != null) {
                    this._method.invoke(observer, notification);
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getObserver() {
            return this._observer.get();
        }

        public Object getObject() {
            return this._object.get();
        }

        public Selector getSelector() {
            return this._selector;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("[");
            Object observer = this._observer.get();
            buffer.append(observer);
            buffer.append(" ");
            buffer.append(this._selector.getName());
            buffer.append("()]");
            return buffer.toString();
        }
    }
}

