/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.factory;

import com.apple.transporter.JSONService;
import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;

public class WebServiceFactory {
    private static WebServiceFactory instance = new WebServiceFactory();
    private Class<? extends WebService> webServiceClass_ = null;

    public static WebServiceFactory instance() {
        return instance;
    }

    private WebServiceFactory() {
    }

    public void setWebServiceClass(Class<? extends WebService> webServiceClass) {
        this.webServiceClass_ = webServiceClass;
    }

    public WebService createWebService() {
        Class<WebService> webServiceClass = this.webServiceClass_;
        String webServiceClassName = System.getProperty("WebServiceClass", JSONService.class.getName());
        try {
            if (webServiceClass == null) {
                webServiceClass = Class.forName(webServiceClassName);
            }
            return webServiceClass.newInstance();
        }
        catch (Exception e) {
            Logger.warn("unable to use WebService of type: " + (webServiceClass != null ? webServiceClass.getName() : webServiceClassName) + " using " + JSONService.class.getName() + " instead.", e);
            return new JSONService();
        }
    }
}

