/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.factory;

import com.apple.transporter.WebService;
import com.apple.transporter.operation.AuthenticatePurpleProvider;
import com.apple.transporter.operation.CreateArtistOperation;
import com.apple.transporter.operation.CreateAssetOnlyStubPackage;
import com.apple.transporter.operation.CreateMetadataTicket;
import com.apple.transporter.operation.Diagnostic;
import com.apple.transporter.operation.DownloadMetadataGuides;
import com.apple.transporter.operation.GenerateSchema;
import com.apple.transporter.operation.ITunesQCDownload;
import com.apple.transporter.operation.ListReportTypes;
import com.apple.transporter.operation.ListReports;
import com.apple.transporter.operation.LookupArtist;
import com.apple.transporter.operation.LookupMetadata;
import com.apple.transporter.operation.LookupProvider;
import com.apple.transporter.operation.LookupPurpleSoftwareVersions;
import com.apple.transporter.operation.LookupVideo;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.QueryTickets;
import com.apple.transporter.operation.RepairEpubAssets;
import com.apple.transporter.operation.RequestReport;
import com.apple.transporter.operation.RequestiTunesConnectArtistBinding;
import com.apple.transporter.operation.ResetSoftwareApplication;
import com.apple.transporter.operation.Sleep;
import com.apple.transporter.operation.Status;
import com.apple.transporter.operation.TransferTest;
import com.apple.transporter.operation.Upload;
import com.apple.transporter.operation.ValidateRawAssets;
import com.apple.transporter.operation.Verify;
import com.apple.transporter.operation.VerifyAssetOperation;
import com.apple.transporter.operation.ehusercrud.EncodingHouseUserAdd;
import com.apple.transporter.operation.ehusercrud.EncodingHouseUserDelete;
import com.apple.transporter.operation.ehusercrud.EncodingHouseUserList;

public class OperationFactory {
    private static OperationFactory _defaultFactory = new OperationFactory();

    public static OperationFactory defaultFactory() {
        return _defaultFactory;
    }

    public void setDefaultFactory(OperationFactory factory) {
        _defaultFactory = factory;
    }

    public Operation operation(WebService service) {
        String mode = System.getProperty("m");
        return this.operationForMode(mode, service);
    }

    public Operation operationForMode(String mode, WebService service) {
        if (mode.equals("upload")) {
            return new Upload(service);
        }
        if (mode.equals("verify")) {
            return new Verify(service);
        }
        if (mode.equals("lookupPurpleSoftwareVersions")) {
            return new LookupPurpleSoftwareVersions(service);
        }
        if (mode.equals("authenticatePurpleProvider")) {
            return new AuthenticatePurpleProvider(service);
        }
        if (mode.equals(LookupProvider.NAME)) {
            return new LookupProvider(service);
        }
        if (mode.equals("lookupMetadata")) {
            return new LookupMetadata(service);
        }
        if (mode.equals("lookupVideo")) {
            return new LookupVideo(service);
        }
        if (mode.equals("createArtist")) {
            return new CreateArtistOperation(service);
        }
        if (mode.equals("lookupArtist")) {
            return new LookupArtist(service);
        }
        if (mode.equals("diagnostic")) {
            return new Diagnostic(service);
        }
        if (mode.equals("resetSoftwareApplication")) {
            return new ResetSoftwareApplication(service);
        }
        if (mode.equals("sleep")) {
            return new Sleep(service);
        }
        if (mode.equals("status")) {
            return new Status(service, false);
        }
        if (mode.equals("statusAll")) {
            return new Status(service, true);
        }
        if (mode.equals("verifyAsset")) {
            return new VerifyAssetOperation(service);
        }
        if (mode.equals("queryTickets")) {
            return new QueryTickets(service);
        }
        if (mode.equals("generateSchema")) {
            return new GenerateSchema(service);
        }
        if (mode.equals("transferTest")) {
            return new TransferTest(service);
        }
        if (mode.equals("downloadMetadataGuides")) {
            return new DownloadMetadataGuides(service);
        }
        if (mode.equalsIgnoreCase("iTunesExtraQCDownload")) {
            return new ITunesQCDownload(service, ITunesQCDownload.QCDownloadType.Extra);
        }
        if (mode.equalsIgnoreCase("iTunesLPQCDownload")) {
            return new ITunesQCDownload(service, ITunesQCDownload.QCDownloadType.LP);
        }
        if (mode.equalsIgnoreCase("createAssetOnlyStubPackage")) {
            return new CreateAssetOnlyStubPackage(service);
        }
        if (mode.equalsIgnoreCase("validateRawAssets")) {
            return new ValidateRawAssets(service);
        }
        if (mode.equals("encodingHouseUserAdd")) {
            return new EncodingHouseUserAdd(service);
        }
        if (mode.equals("encodingHouseUserDelete")) {
            return new EncodingHouseUserDelete(service);
        }
        if (mode.equals("encodingHouseUserList")) {
            return new EncodingHouseUserList(service);
        }
        if (mode.equals("pingArtistRequest")) {
            return new RequestiTunesConnectArtistBinding(service);
        }
        if (mode.equals("createMetadataTicket")) {
            return new CreateMetadataTicket(service);
        }
        if (mode.equals("repairEpubAssets")) {
            return new RepairEpubAssets(service);
        }
        if (mode.equals("listReportTypes")) {
            return new ListReportTypes(service);
        }
        if (mode.equals("listReports")) {
            return new ListReports(service);
        }
        if (mode.equals("requestReport")) {
            return new RequestReport(service);
        }
        return null;
    }
}

