/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.arg;

import com.apple.transporter.arg.WebServiceArgument;
import com.apple.transporter.streaming.api.StreamableContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AssetDescriptions
implements WebServiceArgument {
    private final Collection<Map<String, Object>> assetDescriptions;

    public AssetDescriptions(Collection<Map<String, Object>> descriptions) {
        this.assetDescriptions = descriptions;
    }

    @Override
    public void addToArgumentsMap(Map<String, Object> args) {
        ArrayList<StreamableContent> streamableList = new ArrayList<StreamableContent>();
        for (Map<String, Object> descMap : this.assetDescriptions) {
            StreamableContent streamableContent;
            Object sc = descMap.remove("$STREAMABLE_ITEM$");
            if (!(sc instanceof StreamableContent) || (streamableContent = (StreamableContent)sc).getUncompressedContentLength() >= streamableContent.getMaximumFileSize()) continue;
            streamableList.add(streamableContent);
        }
        args.put("AssetDescriptionsCompressed", this.assetDescriptions);
        if (!streamableList.isEmpty()) {
            args.put("StreamingInfoList", streamableList);
        }
    }
}

