/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.Application;
import com.apple.transporter.NetworkReachability;
import com.apple.transporter.NetworkReachabilityMonitor;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.SystemUtil;
import com.apple.transporter.util.TransportUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;

public class WebServiceInvoker {
    public static <T> T invokeWithRetry(Invocation<T> invocation) {
        Integer maxNumOfTries = new Integer(System.getProperty("numberOfRetries"));
        BackOffExecution expBackoff = new ExponentialBackOff().start();
        Random random = new Random();
        int numOfTriesPerformed = 0;
        int failureCount = 0;
        Object returnValue = null;
        Logger.extreme(SystemUtil.memoryStatsString());
        NetworkReachability lastReachability = NetworkReachabilityMonitor.reachability();
        invocation.setNetworkIsReachable(lastReachability.isReachable());
        ArrayList<Exception> serverExceptions = new ArrayList<Exception>();
        while (returnValue == null && numOfTriesPerformed < maxNumOfTries && failureCount < maxNumOfTries) {
            Exception serverException;
            NetworkReachabilityMonitor.WaitResult waitResult = NetworkReachabilityMonitor.waitForReachabilityWithTimeout(30000);
            if (waitResult.didWait) {
                ++numOfTriesPerformed;
            }
            if (lastReachability != waitResult.reachability) {
                invocation.setNetworkIsReachable(waitResult.reachability.isReachable());
                lastReachability = waitResult.reachability;
            }
            if (waitResult.reachability.isUnreachable()) continue;
            if (!waitResult.didWait && numOfTriesPerformed > 0) {
                TransportUtil.needToSleep(30000L, null, true);
                ++numOfTriesPerformed;
            }
            try {
                returnValue = invocation.invoke();
            }
            catch (Exception e) {
                Application.logUnnecessaryError("Error invoking web-service", e);
            }
            if (null != returnValue && returnValue instanceof Map && null != (serverException = (Exception)((Map)returnValue).get("$SERVER_EXCEPTION$"))) {
                serverExceptions.add(serverException);
                returnValue = null;
            }
            if (null != returnValue) continue;
            ++failureCount;
            long nextSleep = expBackoff.nextBackOff();
            if (nextSleep <= 0L) continue;
            double multiplier = random.nextDouble() * 0.2;
            nextSleep += (long)((double)nextSleep * multiplier);
            TransportUtil.needToSleep(nextSleep, null, false);
        }
        if (returnValue == null) {
            Logger.error("Could not connect to Apple's web service.");
            String lastMessge = null;
            for (Exception exc : serverExceptions) {
                if (exc.getMessage().equals(lastMessge)) continue;
                lastMessge = exc.getMessage();
                Logger.error(lastMessge);
            }
        }
        return returnValue;
    }

    public static interface Invocation<T> {
        public void setNetworkIsReachable(boolean var1);

        public T invoke();
    }
}

