/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.Application;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.arg.AssetDescriptions;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.TransportLog;
import com.apple.transporter.model.AssetValidationUpload;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.operation.LookupProvider;
import com.apple.transporter.operation.option.AppPlatformOption;
import com.apple.transporter.operation.option.AppleIdOption;
import com.apple.transporter.operation.option.ArtistNameOption;
import com.apple.transporter.operation.option.DSTokenOption;
import com.apple.transporter.operation.option.Hsa2HeadersOption;
import com.apple.transporter.operation.option.ItcProviderNameOption;
import com.apple.transporter.operation.option.PasswordOption;
import com.apple.transporter.operation.option.ProviderNameOption;
import com.apple.transporter.operation.option.SchemaOption;
import com.apple.transporter.operation.option.SearchLocaleOption;
import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.operation.option.VendorIdOption;
import com.apple.transporter.stats.api.Statistic;
import com.apple.transporter.stats.api.StatisticCollector;
import com.apple.transporter.streaming.StreamingParameters;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.ConfigurationUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class WebService {
    protected static final String ARGUMENT_DICT__USERNAME_KEY = "Username";
    protected static final String ARGUMENT_DICT__PASSWORD_KEY = "Password";
    protected static final String ARGUMENT_DICT__PROVIDERNAME_KEY = "ProviderName";
    protected static final String ARGUMENT_DICT__ITCPROVIDERNAME_KEY = "ItcProviderName";
    protected static final String ARGUMENT_DICT__PACKAGENAME_KEY = "PackageName";
    protected static final String ARGUMENT_DICT__FILES_KEY = "Files";
    protected static final String ARGUMENT_DICT__TRANSPORT_KEY = "Transport";
    protected static final String ARGUMENT_DICT__METADATA_KEY = "Metadata";
    protected static final String ARGUMENT_DICT__METADATA_COMPRESSED_KEY = "MetadataCompressed";
    protected static final String ARGUMENT_DICT__METADATA_CHECKSUM_KEY = "MetadataChecksum";
    protected static final String ARGUMENT_DICT__PACKAGESIZE_KEY = "PackageSize";
    protected static final String ARGUMENT_DICT__MOUNT_KEY = "Mount";
    protected static final String ARGUMENT_DICT__VERSION_KEY = "Version";
    protected static final String ARGUMENT_DICT__BASE_VERSION_KEY = "BaseVersion";
    protected static final String ARGUMENT_DICT__APPLICATION_KEY = "Application";
    protected static final String ARGUMENT_DICT__CLIENT_KEY = "Client";
    protected static final String ARGUMENT_DICT__CLIENT_VERSION_KEY = "ClientVersion";
    protected static final String ARGUMENT_DICT__OS_IDENTIFIER_KEY = "OSIdentifier";
    protected static final String ARGUMENT_DICT__PKG_PATH_WITHOUT_BASE_KEY = "PackagePathWithoutBase";
    protected static final String ARGUMENT_DICT__NEW_PKG_NAME_KEY = "NewPackageName";
    public static final String ARGUMENT_DICT__TRANSPORT_LOG_KEY = "TransportLog";
    public static final String ARGUMENT_DICT__TRANSPORT_LOG_COMPRESSED_KEY = "TransportLogCompressed";
    public static final String ARGUMENT_DICT__EXTRA_TRANSPORT_LOG_KEY = "ExtraTransportLog";
    public static final String ARGUMENT_DICT__EXTRA_TRANSPORT_LOG_COMPRESSED_KEY = "ExtraTransportLogCompressed";
    protected static final String ARGUMENT_DICT__TRANSFER_TIME_KEY = "TransferTime";
    protected static final String ARGUMENT_DICT__POD_NAME_KEY = "Pod";
    protected static final String ARGUMENT_DICT__HOST_NAME_KEY = "Host";
    protected static final String ARGUMENT_DICT__VENDOR_ID_KEY = "VendorId";
    protected static final String ARGUMENT_DICT__VENDOR_IDS_KEY = "VendorIds";
    protected static final String ARGUMENT_DICT__VENDOR_IDENTIFIER_KEY = "VendorIdentifier";
    protected static final String ARGUMENT_DICT__APPLE_ID_KEY = "AppleId";
    protected static final String ARGUMENT_DICT__APPLE_IDS_KEY = "AppleIds";
    public static final String ARGUMENT_DICT__CHECKSUM_KEY = "Checksum";
    public static final String ARGUMENT_DICT__GZIP_CONTENT_KEY = "GzipContent";
    protected static final String ARGUMENT_DICT__FILENAME_KEY = "Filename";
    protected static final String ARGUMENT_DICT__FILE_SIZE_KEY = "FileSize";
    protected static final String ARGUMENT_DICT__ASSET_DESCRIPTIONS_KEY = "AssetDescriptions";
    public static final String ARGUMENT_DICT__ASSET_DESCRIPTIONS_COMPRESSED_KEY = "AssetDescriptionsCompressed";
    public static final String ARGUMENT_DICT__CPU_TOKEN = "CPUToken";
    protected static final String ARGUMENT_DICT__THROTTLE_KEY = "Throttle";
    protected static final String ARGUMENT_DICT__TRANSPORTER_ARGS_KEY = "TransporterArguments";
    protected static final String ARGUMENT_DICT__NUM_BYTES_TRANSFERRED_KEY = "NumberBytesTransferred";
    protected static final String ARGUMENT_DICT__SCHEMA_PACKAGE = "SchemaPackage";
    protected static final String ARGUMENT_DICT__SCHEMA_TYPE = "SchemaType";
    protected static final String ARGUMENT_DICT__STATIC_SCHEMA = "StaticSchema";
    protected static final String ARGUMENT_DICT__TEST_TRANSFER_KEY = "TestTransfer";
    protected static final String ARGUMENT_DICT__CLIENT_CHECKSUM_INFO_KEY = "ClientChecksumInfo";
    protected static final String ARGUMENT_DICT__FILE_SIZE_INFO_KEY = "FileSizeInfo";
    protected static final String ARGUMENT_DICT__DRY_RUN_KEY = "DryRun";
    protected static final String ARGUMENT_DICT__STATE_KEY = "State";
    protected static final String ARGUMENT_DICT__QUALITY_KEY = "Quality";
    protected static final String ARGUMENT_DICT__ENCODING_HOUSE_KEY = "EncodingHouse";
    protected static final String ARGUMENT_DICT__EMAIL_KEY = "Email";
    protected static final String ARGUMENT_DICT__INCLUDE_INACTIVE = "IncludeInactive";
    protected static final String ARGUMENT_DICT__REQUEST_ITUNES_CONNECT_ACTIVATION_URL_XML = "iTunesConnectActivationRequestXML";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_TITLE = "PlaylistTitle";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_TITLE_TRANSLATION = "PlaylistTitleTranslation";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_VERSION_TITLE = "VersionTitle";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLES = "TrackTitles";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLE_TRANSLATIONS = "TrackTitleTranslations";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLE_VERSIONS = "TrackTitleVersions";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_NOTE = "Note";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_GENRE = "PlaylistGenre";
    protected static final String ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_GENRES = "TrackGenres";
    protected static final String ARGUMENT_DICT__SECONDS_KEY = "Seconds";
    protected static final String ARGUMENT_DICT__TRANSPORTS_KEY = "Transports";
    private static final String ARGUMENT_DICT__SUB_ITEM_TYPE_KEY = "SubItemType";
    private static final String ARGUMENT_DICT__SUB_ITEM_IDS_KEY = "SubItemIds";
    private static final String ARGUMENT_DICT__REPORT_TYPE_KEY = "ReportType";
    private static final String ARGUMENT_DICT__REPORT_DATE_KEY = "ReportDate";
    private static final String ARGUMENT_DICT__INCLUDE_STATUS_IDS_KEY = "IncludeStatusIds";
    private static final String ARGUMENT_DICT__DSTOKEN_KEY = "DSToken";
    private static final String ARGUMENT_DICT__HSA2HEADERS_KEY = "HttpHeaders";
    private static final String ARGUMENT_DICT__OUTPUT_FORMAT_KEY = "OutputFormat";
    private static final String ARGUMENT_DICT__OUTPUT_TYPE_KEY = "OutputType";
    protected static final String ARGUMENT_DICT__KEYWORDS = "Keywords";
    protected static final String ARGUMENT_DICT__CONTENT_TYPE = "ContentType";
    protected static final String ARGUMENT_DICT__ARTIST_NAME = "artistName";
    protected static final String ARGUMENT_DICT__APPLEID = "appleid";
    protected static final String ARGUMENT_DICT__MUSIC = "music";
    protected static final String ARGUMENT_DICT__SEARCH_FIELDS = "SearchFields";
    protected static final String ARGUMENT_DICT__SEARCH_LOCALES = "SearchLocales";
    protected static final String ARGUMENT_DICT__EXCLUDE_FILTERING_BY_PROVIDER = "ExcludeFilteringByProvider";
    protected static final String ARGUMENT_DICT__MODE_KEY = "iTMSTransporterMode";
    protected static final String ARGUMENT_DICT__APP_PLATFORM_KEY = "AppPlatform";
    protected static final String ARGUMENT_DICT__STATISTICS_CLIENT_START_DATE_TIME_ZONE_ISO_KEY = "StatisticsClientStartDateTimeZoneISO";
    protected static final String ARGUMENT_DICT__STATISTICS_PREVIOUS_CALL_DURATION_IN_SECS_KEY = "StatisticsPreviousCallDurationInSecs";
    protected static final String ARGUMENT_DICT__STATISTICS_ARRAY_KEY = "StatisticsArray";
    public static final String ARGUMENT_DICT__STREAMING_INFO_LIST_KEY = "StreamingInfoList";
    protected static final String RETURN_DICT__TRANSPORTER_HEADERS_KEY = "TxHeaders";
    public static final String PRIVATE_STREAMABLE_ITEM = "$STREAMABLE_ITEM$";
    public static final String PRIVATE_SERVER_EXCEPTION_KEY = "$SERVER_EXCEPTION$";
    private Set<String> loggingResponseKeysToIgnore;
    boolean computeNextRequestChecksum;
    byte[] requestChecksum;
    private String sharedSecret;
    private String sessionId;
    private boolean attemptSessionAuthentication = true;
    private static String _osIdentifier = null;
    protected static final String TXCorrelationKeyHeaderName = "x-tx-correlation-key";
    protected static final String TXMethodHeaderName = "x-tx-method";
    protected static final String TXVersionHeaderName = "x-tx-version";
    public static String TXVersionNumberString = null;
    protected static final String TXCorrelationKeyHeaderValue = UUID.randomUUID().toString();
    private Map<String, String> transporterHeaders;

    void setSessionIdAndSharedSecret(String sessionId, String sharedSecret) {
        if (null != sessionId && !sessionId.isEmpty() && null != sharedSecret && !sharedSecret.isEmpty()) {
            this.sessionId = sessionId;
            this.sharedSecret = sharedSecret;
        } else {
            this.sessionId = null;
            this.sharedSecret = null;
        }
    }

    String sharedSecret() {
        return this.sharedSecret;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void shouldComputeNextRequestChecksum(boolean value) {
        this.computeNextRequestChecksum = value;
    }

    public byte[] getLastRequestChecksum() {
        return this.requestChecksum;
    }

    public static String getOSIdentifier() {
        if (_osIdentifier == null) {
            StringBuilder builder = new StringBuilder();
            String os = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArch = System.getProperty("os.arch");
            String jvmVersion = System.getProperty("java.vm.version");
            String jreVersion = System.getProperty("java.runtime.version");
            builder.append(os).append(" ");
            builder.append(osVersion).append(" (");
            builder.append(osArch).append("); jvm=");
            builder.append(jvmVersion).append("; jre=");
            builder.append(jreVersion);
            _osIdentifier = builder.toString();
        }
        return _osIdentifier;
    }

    public Map authenticateOperation(ITMSPackage aPkg, boolean hidePassword, TransportType transportType) {
        return this.authenticateOperation(aPkg, hidePassword, null, null, transportType);
    }

    protected void setTransporterHeaders(Map<String, String> transporterHeaders) {
        this.transporterHeaders = transporterHeaders;
    }

    protected Map<String, String> getTransporterHeaders() {
        return this.transporterHeaders;
    }

    public Map authenticateOperation(ITMSPackage aPkg, boolean hidePassword, AssetDescriptions descriptions, String cpuToken, TransportType transportType) {
        Map<String, Object> returnValue;
        String podName;
        String mount;
        if (aPkg == null) {
            return null;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__PACKAGENAME_KEY, aPkg.packageName());
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        if ((mount = System.getProperty("mount")) != null) {
            args.put(ARGUMENT_DICT__MOUNT_KEY, mount);
        }
        if ((podName = System.getProperty("pod")) != null) {
            args.put(ARGUMENT_DICT__POD_NAME_KEY, podName);
        } else {
            String hostName = System.getProperty("host");
            if (hostName != null) {
                args.put(ARGUMENT_DICT__HOST_NAME_KEY, hostName);
            }
        }
        this.addMetadataArgument(aPkg, args);
        args.put(ARGUMENT_DICT__PACKAGESIZE_KEY, aPkg.filesRequestedByAppleSizeSum());
        if (cpuToken != null) {
            args.put(ARGUMENT_DICT__CPU_TOKEN, cpuToken);
        }
        if (System.getProperty("k") != null) {
            args.put(ARGUMENT_DICT__THROTTLE_KEY, System.getProperty("k"));
        }
        List<String> validFileNamesStringArray = this.getValidFileNames(aPkg);
        args.put(ARGUMENT_DICT__FILES_KEY, validFileNamesStringArray);
        if (descriptions == null) {
            String swinfoPlistFormat;
            HashMap<String, Object> logableParameters = new HashMap<String, Object>(1);
            logableParameters.put(ARGUMENT_DICT__METADATA_KEY, aPkg.metadataFileContents());
            returnValue = this.invokeStandard("validateMetadata", args, logableParameters, hidePassword);
            Map softwareThresholds = (Map)returnValue.get("SoftwareMediaDescriptionThresholds");
            if (null != softwareThresholds) {
                StreamingParameters.setSoftwareSizeThresholds(softwareThresholds);
            }
            if (null != (swinfoPlistFormat = (String)returnValue.get("SoftwareMediaDescriptionFormat"))) {
                StreamingParameters.setSwinfoPlistFormat(swinfoPlistFormat);
            }
        } else {
            descriptions.addToArgumentsMap(args);
            returnValue = this.invokeStandard("validateAssets", args, hidePassword);
        }
        return returnValue;
    }

    public Map clientChecksumCompletedOperation(ITMSPackage aPackage) {
        if (aPackage == null) {
            return null;
        }
        if (aPackage.newPackageName() == null) {
            return null;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__NEW_PKG_NAME_KEY, aPackage.newPackageName());
        Map<String, Object> returnValue = this.invokeStandard("clientChecksumCompleted", args);
        return returnValue;
    }

    public Map uploadDoneOperation(String packageName, String newPkgName, String folderPath, boolean hidePassword, Long transferTime, TransportLog transportLog, TransportLog extraTransportLog, Long transferredBytes, Collection checksumInfo, Map fileSizeInfo, String cpuToken, TransportType transportType) {
        if (packageName == null || newPkgName == null || newPkgName.trim().length() == 0 || folderPath == null || folderPath.trim().length() == 0) {
            return null;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__NEW_PKG_NAME_KEY, newPkgName);
        args.put(ARGUMENT_DICT__PKG_PATH_WITHOUT_BASE_KEY, folderPath);
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        args.put(ARGUMENT_DICT__TRANSFER_TIME_KEY, transferTime);
        if (transportLog != null) {
            transportLog.addToArgumentsMap(args);
        }
        if (extraTransportLog != null) {
            extraTransportLog.addToArgumentsMap(args);
        }
        args.put(ARGUMENT_DICT__NUM_BYTES_TRANSFERRED_KEY, transferredBytes);
        args.put(ARGUMENT_DICT__CLIENT_CHECKSUM_INFO_KEY, checksumInfo);
        if (fileSizeInfo != null && fileSizeInfo.size() > 0) {
            args.put(ARGUMENT_DICT__FILE_SIZE_INFO_KEY, fileSizeInfo);
        }
        if (cpuToken != null) {
            args.put(ARGUMENT_DICT__CPU_TOKEN, cpuToken);
        }
        if (System.getProperty("k") != null) {
            args.put(ARGUMENT_DICT__THROTTLE_KEY, System.getProperty("k"));
        }
        if (System.getProperty("m").equalsIgnoreCase("transferTest")) {
            args.put(ARGUMENT_DICT__TEST_TRANSFER_KEY, "true");
        }
        StatisticCollector statCollector = Application.getStatisticCollector();
        args.put(ARGUMENT_DICT__STATISTICS_ARRAY_KEY, statCollector.getResults());
        Map<String, Object> returnValue = this.invokeStandard("uploadDoneWithArguments", args, hidePassword);
        return returnValue;
    }

    public Map<String, Object> uploadStatusVendorIds(String vendorIds, boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_IDS_KEY, vendorIds);
        Map<String, Object> returnValue = this.invokeStandard("uploadStatusIDs", args, hidePassword);
        return returnValue;
    }

    public Map<String, Object> uploadStatusAppleIds(String appleIds, boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__APPLE_IDS_KEY, appleIds);
        Map<String, Object> returnValue = this.invokeStandard("uploadStatusIDs", args, hidePassword);
        return returnValue;
    }

    public Map<String, Object> lookupMetadataVendorIds(String vendorIds) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_IDS_KEY, vendorIds);
        Map<String, Object> returnValue = this.invokeStandard("lookupMetadataIDs", args, Application.shouldHidePassword());
        return returnValue;
    }

    public Map<String, Object> lookupMetadataAppleIds(String appleIds) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__APPLE_IDS_KEY, appleIds);
        Map<String, Object> returnValue = this.invokeStandard("lookupMetadataIDs", args, Application.shouldHidePassword());
        return returnValue;
    }

    public Map<String, Object> uploadStatusForVendorId(String vendorId, boolean hidePassword, boolean wantComplete, boolean shouldReturnStateIDs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, vendorId);
        return this.uploadStatus(hidePassword, wantComplete, shouldReturnStateIDs, args);
    }

    public Map<String, Object> uploadStatusForAppleId(String appleId, boolean hidePassword, boolean wantComplete, boolean shouldReturnStateIDs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ARGUMENT_DICT__APPLE_ID_KEY, appleId);
        return this.uploadStatus(hidePassword, wantComplete, shouldReturnStateIDs, args);
    }

    private Map<String, Object> uploadStatus(boolean hidePassword, boolean wantComplete, boolean shouldReturnStateIDs, Map<String, Object> args) {
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (Application.shouldGenerateXML()) {
            args.put(ARGUMENT_DICT__OUTPUT_FORMAT_KEY, "xml");
        } else {
            args.put(ARGUMENT_DICT__OUTPUT_FORMAT_KEY, "plain");
        }
        args.put(ARGUMENT_DICT__INCLUDE_STATUS_IDS_KEY, shouldReturnStateIDs);
        Map<String, Object> returnValue = this.invokeStandard(wantComplete ? "completeUploadStatusWithArguments" : "uploadStatusWithArguments", args, hidePassword);
        return returnValue;
    }

    public Map<String, Object> lookupTransportDiagnostic() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("lookupTransportDiagnostic", args, Application.shouldHidePassword());
        return returnValue;
    }

    public Map verifyOperation(ITMSPackage aPkg, boolean hidePassword, AssetDescriptions descriptions) {
        Map<String, Object> returnValue;
        if (aPkg == null) {
            return null;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__DRY_RUN_KEY, "true");
        args.put(ARGUMENT_DICT__PACKAGENAME_KEY, aPkg.packageName());
        this.addMetadataArgument(aPkg, args);
        args.put(ARGUMENT_DICT__PACKAGESIZE_KEY, aPkg.filesRequestedByAppleSizeSum());
        args.put(ARGUMENT_DICT__FILES_KEY, this.getValidFileNames(aPkg));
        if (descriptions != null) {
            descriptions.addToArgumentsMap(args);
            returnValue = this.invokeStandard("validateAssets", args, hidePassword);
        } else {
            HashMap<String, Object> logableParameters = new HashMap<String, Object>(1);
            logableParameters.put(ARGUMENT_DICT__METADATA_KEY, aPkg.metadataFileContents());
            returnValue = this.invokeStandard("validateMetadata", args, logableParameters, hidePassword);
        }
        return returnValue;
    }

    public Map<String, ?> lookupPurpleSoftwareVersions(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("lookupPurpleSoftwareVersions", args, null, hidePassword, true);
        return returnValue;
    }

    public Map<String, ? extends Object> authenticatePurpleProvider(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("authenticatePurpleProvider", args, null, hidePassword, true);
        return returnValue;
    }

    public Map<String, ?> snowfallAuthenticate(AssetValidationUpload upload, TransportType transportType) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        this.appendAssetValidationUploadAttributesToAuthenticateArguments(args, upload);
        Map<String, Object> returnValue = this.invokeStandard("snowfallAuthenticate", args, null, true, true);
        return returnValue;
    }

    public Map<String, ?> snowfallValidateAssets(AssetValidationUpload upload, TransportType transportType) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        this.appendAssetValidationUploadAttributesToVerifyArguments(args, upload);
        Map<String, Object> returnValue = this.invokeStandard("snowfallVerifyAssets", args, null, true, true);
        return returnValue;
    }

    public Map<String, Object> snowfallUploadFailed(AssetValidationUpload upload, TransportLog transportLog, TransportType transportType) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        if (transportLog != null) {
            transportLog.addToArgumentsMap(args);
        }
        args.put(ARGUMENT_DICT__FILENAME_KEY, upload.getNewFilename());
        Map<String, Object> returnValue = this.invokeStandard("snowfallUploadFailed", args, null, true, true);
        return returnValue;
    }

    public Map<String, Object> providersOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        boolean callEncodingHouseService = true;
        String propertyValue = System.getProperty("account_type");
        if (propertyValue != null && propertyValue.equalsIgnoreCase("itunes_connect")) {
            callEncodingHouseService = false;
        }
        Map<String, Object> returnValue = this.invokeStandard("providersWithArguments", args, null, hidePassword, callEncodingHouseService);
        return returnValue;
    }

    public Map<String, Object> createArtistOperation(boolean hidePassword, Map<String, Object> args) {
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("createArtist", args, null, hidePassword);
        return returnValue;
    }

    public Map<String, Object> artistSearchOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        String artistName = ArtistNameOption.artistName();
        String appleId = AppleIdOption.appleIdentifier();
        args.put(ARGUMENT_DICT__CONTENT_TYPE, ARGUMENT_DICT__MUSIC);
        ArrayList<String> list = new ArrayList<String>();
        if (artistName != null) {
            args.put(ARGUMENT_DICT__KEYWORDS, artistName);
            list.add(ARGUMENT_DICT__ARTIST_NAME);
        } else if (appleId != null) {
            args.put(ARGUMENT_DICT__KEYWORDS, appleId);
            list.add(ARGUMENT_DICT__APPLEID);
        }
        String searchLocale = SearchLocaleOption.searchLocale();
        if (null != searchLocale && searchLocale.length() > 0) {
            args.put(ARGUMENT_DICT__SEARCH_LOCALES, Arrays.asList(searchLocale.split(",")));
        }
        args.put(ARGUMENT_DICT__SEARCH_FIELDS, list);
        args.put(ARGUMENT_DICT__EXCLUDE_FILTERING_BY_PROVIDER, Boolean.TRUE);
        Map<String, Object> returnValue = this.invokeStandard("searchArtist", args, null, hidePassword, false);
        return returnValue;
    }

    public Map lookupVideoMetadataOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, VendorIdOption.vendorIdentifier());
        Map<String, Object> returnValue = this.invokeStandard("lookupVideoMetadataWithArguments", args, null, hidePassword, true);
        return returnValue;
    }

    public Map<String, Object> lookupVideoOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, VendorIdOption.vendorIdentifier());
        Map<String, Object> returnValue = this.invokeStandard("lookupVideoWithArguments", args, null, hidePassword, true);
        return returnValue;
    }

    public Map uploadFailed(boolean hidePassword, String newPackageName, TransportLog transportLog, TransportLog extraTransportLog, Long transferTime, Long transferredBytes, Collection checksumInfo, String cpuToken, TransportType transportType) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__NEW_PKG_NAME_KEY, newPackageName);
        if (transportLog != null) {
            transportLog.addToArgumentsMap(args);
        }
        if (extraTransportLog != null) {
            extraTransportLog.addToArgumentsMap(args);
        }
        if (transportType != null) {
            args.put(ARGUMENT_DICT__TRANSPORT_KEY, transportType.name());
        }
        args.put(ARGUMENT_DICT__TRANSFER_TIME_KEY, transferTime);
        args.put(ARGUMENT_DICT__NUM_BYTES_TRANSFERRED_KEY, transferredBytes);
        args.put(ARGUMENT_DICT__CLIENT_CHECKSUM_INFO_KEY, checksumInfo);
        if (cpuToken != null) {
            args.put(ARGUMENT_DICT__CPU_TOKEN, cpuToken);
        }
        if (System.getProperty("k") != null) {
            args.put(ARGUMENT_DICT__THROTTLE_KEY, System.getProperty("k"));
        }
        StatisticCollector statCollector = Application.getStatisticCollector();
        args.put(ARGUMENT_DICT__STATISTICS_ARRAY_KEY, statCollector.getResults());
        Map<String, Object> returnValue = this.invokeStandard("uploadFailedWithArguments", args, hidePassword);
        return returnValue;
    }

    public Map<String, ?> lookupMetadataForVendorIdOperation(String vendorId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, vendorId);
        Map<String, ?> returnValue = this.lookupMetadataOperation(args);
        return returnValue;
    }

    public Map<String, ?> lookupMetadataForAppleIdOperation(String appleId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ARGUMENT_DICT__APPLE_ID_KEY, appleId);
        Map<String, ?> returnValue = this.lookupMetadataOperation(args);
        return returnValue;
    }

    private Map<String, ?> lookupMetadataOperation(Map<String, Object> args) {
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (System.getProperty("subitemtype") != null) {
            args.put(ARGUMENT_DICT__SUB_ITEM_TYPE_KEY, System.getProperty("subitemtype"));
        }
        if (System.getProperty("subitemids") != null) {
            args.put(ARGUMENT_DICT__SUB_ITEM_IDS_KEY, System.getProperty("subitemids"));
        }
        if (System.getProperty("outputtype") != null) {
            args.put(ARGUMENT_DICT__OUTPUT_TYPE_KEY, System.getProperty("outputtype"));
        }
        Map<String, Object> returnValue = this.invokeStandard("lookupMetadataWithArguments", args, Application.shouldHidePassword());
        return returnValue;
    }

    public Map<String, Object> resetSoftwareApplicationOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, VendorIdOption.vendorIdentifier());
        args.put(ARGUMENT_DICT__APPLE_ID_KEY, System.getProperty("apple_id"));
        Map<String, Object> returnValue = this.invokeStandard("resetSoftwareApplication", args, hidePassword);
        return returnValue;
    }

    public Map<String, Object> sleepOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Integer seconds = new Integer(System.getProperty("seconds"));
        args.put(ARGUMENT_DICT__SECONDS_KEY, seconds);
        Map<String, Object> returnValue = this.invokeStandard("sleepWithArguments", args, null, hidePassword, true);
        return returnValue;
    }

    public Map queryTickets() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        String vendorId = VendorIdOption.vendorIdentifier();
        if (vendorId != null) {
            args.put(ARGUMENT_DICT__VENDOR_ID_KEY, vendorId);
        }
        if (System.getProperty("apple_id") != null) {
            args.put(ARGUMENT_DICT__APPLE_ID_KEY, System.getProperty("apple_id"));
        }
        Map<String, Object> returnValue = this.invokeStandard("queryTickets", args);
        return returnValue;
    }

    public Map listReportTypes() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("listReportTypes", args);
        return returnValue;
    }

    public Map listReports() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("listReports", args);
        return returnValue;
    }

    public Map requestReport(String type, Object reportDate) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__REPORT_TYPE_KEY, type);
        if (reportDate != null) {
            args.put(ARGUMENT_DICT__REPORT_DATE_KEY, reportDate);
        }
        Map<String, Object> returnValue = this.invokeStandard("requestReport", args);
        return returnValue;
    }

    public Map generateSchema() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (SchemaOption.isStaticSchema()) {
            args.put(ARGUMENT_DICT__STATIC_SCHEMA, SchemaOption.getSchemaValue());
            if (SchemaOption.supportsSchemaType()) {
                args.put(ARGUMENT_DICT__SCHEMA_TYPE, System.getProperty("schemaType"));
            }
        } else {
            args.put(ARGUMENT_DICT__SCHEMA_PACKAGE, SchemaOption.getSchemaValue());
            args.put(ARGUMENT_DICT__SCHEMA_TYPE, System.getProperty("schemaType"));
        }
        Map<String, Object> returnValue = this.invokeStandard("generateSchema", args);
        return returnValue;
    }

    public Map metadataGuidesForDownloadWithArgumentsOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("metadataGuidesForDownloadWithArguments", args, null, hidePassword);
        return returnValue;
    }

    public Map iTunesExtraQCForDownloadOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, VendorIdOption.vendorIdentifier());
        args.put(ARGUMENT_DICT__APPLE_ID_KEY, System.getProperty("apple_id"));
        args.put(ARGUMENT_DICT__STATE_KEY, System.getProperty("state"));
        args.put(ARGUMENT_DICT__QUALITY_KEY, System.getProperty("quality"));
        Map<String, Object> returnValue = this.invokeStandard("iTunesExtraQCForDownloadWithArguments", args, null, hidePassword);
        return returnValue;
    }

    public Map iTunesLpQcForDownloadOperation(boolean hidePassword) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__VENDOR_ID_KEY, VendorIdOption.vendorIdentifier());
        args.put(ARGUMENT_DICT__APPLE_ID_KEY, System.getProperty("apple_id"));
        args.put(ARGUMENT_DICT__STATE_KEY, System.getProperty("state"));
        args.put(ARGUMENT_DICT__QUALITY_KEY, System.getProperty("quality"));
        this.appendClientInformationToArgs(args);
        Map<String, Object> returnValue = this.invokeStandard("iTunesLpQcForDownloadWithArguments", args, null, hidePassword);
        return returnValue;
    }

    public Map queryAssetTypes(List<String> files) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__FILES_KEY, files);
        Map<String, Object> returnValue = this.invokeStandard("queryAssetTypes", args);
        return returnValue;
    }

    public Map validateRawAssets(AssetDescriptions descriptions) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (descriptions != null) {
            descriptions.addToArgumentsMap(args);
        }
        Map<String, Object> returnValue = this.invokeStandard("validateRawAssets", args);
        return returnValue;
    }

    public Map createEncodingHouseUserAddRequest() {
        String encodingHouse;
        String password;
        HashMap<String, Object> args = new HashMap<String, Object>();
        String username = UsernameOption.username();
        if (username != null) {
            args.put(ARGUMENT_DICT__USERNAME_KEY, username);
        }
        if ((password = System.getProperty("p")) != null) {
            args.put(ARGUMENT_DICT__PASSWORD_KEY, password);
        }
        if ((encodingHouse = System.getProperty("encodingHouse")) != null) {
            args.put(ARGUMENT_DICT__ENCODING_HOUSE_KEY, encodingHouse);
        }
        args.put(ARGUMENT_DICT__EMAIL_KEY, System.getProperty("email"));
        Map<String, Object> returnValue = this.invokeStandard("createEncodingHouseUserAddRequest", args, null, true, true);
        return returnValue;
    }

    public Map deleteEncodingHouseUser(String meail) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__EMAIL_KEY, System.getProperty("email"));
        Map<String, Object> returnValue = this.invokeStandard("deleteEncodingHouseUser", args, null, true, true);
        return returnValue;
    }

    public Map listEncodingHouseUsers(boolean includeInactive) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__INCLUDE_INACTIVE, includeInactive);
        Map<String, Object> returnValue = this.invokeStandard("listEncodingHouseUsers", args, null, true, true);
        return returnValue;
    }

    public Map requestiTunesConnectArtistBinding(String xml) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__REQUEST_ITUNES_CONNECT_ACTIVATION_URL_XML, xml);
        Map<String, Object> returnValue = this.invokeStandard("requestiTunesConnectArtistBinding", args);
        return returnValue;
    }

    public Map createMetadataTicket(String playlistTitle, String playlistTitleTranslation, String versionTitle, List<String> trackTitles, List<String> trackTitleTranslations, List<String> trackTitleVersions, String playlistGenre, List<String> trackGenres, String note) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        if (System.getProperty("vendor_id") != null) {
            args.put(ARGUMENT_DICT__VENDOR_ID_KEY, System.getProperty("vendor_id"));
        } else if (System.getProperty("apple_id") != null) {
            args.put(ARGUMENT_DICT__APPLE_ID_KEY, System.getProperty("apple_id"));
        }
        if (playlistTitle != null) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_TITLE, playlistTitle);
        }
        if (playlistTitleTranslation != null) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_TITLE_TRANSLATION, playlistTitleTranslation);
        }
        if (versionTitle != null) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_VERSION_TITLE, versionTitle);
        }
        if (trackTitles != null && !trackTitles.isEmpty()) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLES, trackTitles);
        }
        if (trackTitleTranslations != null && !trackTitleTranslations.isEmpty()) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLE_TRANSLATIONS, trackTitleTranslations);
        }
        if (trackTitleVersions != null && !trackTitleVersions.isEmpty()) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_TITLE_VERSIONS, trackTitleVersions);
        }
        if (playlistGenre != null) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_PLAYLIST_GENRE, playlistGenre);
        }
        if (trackGenres != null && !trackGenres.isEmpty()) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_TRACK_GENRES, trackGenres);
        }
        if (note != null) {
            args.put(ARGUMENT_DICT__CREATE_METADATA_TICKET_NOTE, note);
        }
        Map<String, Object> returnValue = this.invokeStandard("createMetadataTicket", args);
        return returnValue;
    }

    public Map authenticateForTransportDiscovery() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        Map<String, Object> returnValue = this.invokeStandard("authenticateForTransportDiscovery", args);
        return returnValue;
    }

    public Map<String, ?> assignTransportPodToUpload(String newPkgName, String cpuToken, String transport, String podName, String hostName) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        try {
            this.addAuthenticationArguments(args);
        }
        catch (AuthenticationException ax) {
            return ax.getResults();
        }
        args.put(ARGUMENT_DICT__NEW_PKG_NAME_KEY, newPkgName);
        args.put(ARGUMENT_DICT__TRANSPORT_KEY, transport);
        String mount = System.getProperty("mount");
        if (mount != null) {
            args.put(ARGUMENT_DICT__MOUNT_KEY, mount);
        }
        if (podName != null) {
            args.put(ARGUMENT_DICT__POD_NAME_KEY, podName);
        } else if (hostName != null) {
            args.put(ARGUMENT_DICT__HOST_NAME_KEY, hostName);
        }
        if (cpuToken != null) {
            args.put(ARGUMENT_DICT__CPU_TOKEN, cpuToken);
        }
        Map<String, Object> returnValue = this.invokeStandard("assignTransportPodToUpload", args);
        return returnValue;
    }

    public Map<String, Object> authenticateForSession() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        this.addAuthenticationArgumentsForNewSession(args);
        Map<String, Object> returnValue = this.invokeStandard("authenticateForSession", args);
        if (returnValue != null && !returnValue.isEmpty()) {
            String sessionId = (String)returnValue.get(System.getProperty("SessionIdKey"));
            String sharedSecret = (String)returnValue.get(System.getProperty("SharedSecretKey"));
            if (sessionId != null && !sessionId.isEmpty() && sharedSecret != null && !sharedSecret.isEmpty()) {
                this.sessionId = sessionId;
                this.sharedSecret = sharedSecret;
            } else {
                this.sessionId = null;
                this.sharedSecret = null;
            }
            Boolean multipartUploadsEnabled = (Boolean)returnValue.get("MultipartUploadsEnabled");
            if (null != multipartUploadsEnabled) {
                StreamingParameters.setMultipartUploadsEnabled(multipartUploadsEnabled);
            }
        }
        return returnValue;
    }

    private void establishSessionAuthentication() throws AuthenticationException {
        if (!this.hasSession() && this.shouldUseSessionAuthentication()) {
            Map<String, Object> result = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map<String, Object>>(){

                @Override
                public void setNetworkIsReachable(boolean isReachable) {
                }

                @Override
                public Map<String, Object> invoke() {
                    return WebService.this.authenticateForSession();
                }
            });
            if (result == null || result.get(System.getProperty("errorsKey")) != null || result.get(System.getProperty("errorCodeKey")) != null || result.get(System.getProperty("exceptionKey")) != null || result.get(PRIVATE_SERVER_EXCEPTION_KEY) != null) {
                this.attemptSessionAuthentication = false;
            }
            if (!this.hasSession()) {
                throw new AuthenticationException(result);
            }
        }
    }

    public boolean performDiagnostic() {
        Logger.info("Performing web service diagnostic test ...");
        boolean returnValue = false;
        String serviceAddress = System.getProperty("serviceAddress");
        returnValue = serviceAddress != null && serviceAddress.length() > 0 ? this.testServiceAddress(serviceAddress) : this.testServiceAddress(this.getMZEncodingHouseServiceAddress());
        Logger.info("Done performing web service diagnostic test.");
        return returnValue;
    }

    protected Map<String, Object> invokeStandard(String operationName, Map<String, Object> args) {
        return this.invokeStandard(operationName, args, true);
    }

    protected Map<String, Object> invokeStandard(String operationName, Map<String, Object> args, boolean hidePassword) {
        return this.invokeStandard(operationName, args, null, hidePassword);
    }

    protected Map<String, Object> invokeStandard(String operationName, Map<String, Object> args, Map<String, Object> logableParameters, boolean hidePassword) {
        boolean callEncodingHouseService = ProviderNameOption.wasProviderNameGiven();
        String modeValue = System.getProperty("m");
        if (modeValue != null && modeValue.equalsIgnoreCase(LookupProvider.NAME)) {
            String accountTypeValue = System.getProperty("account_type");
            if (accountTypeValue != null && accountTypeValue.equalsIgnoreCase("itunes_connect")) {
                callEncodingHouseService = false;
            } else if (accountTypeValue != null && accountTypeValue.equalsIgnoreCase("encoding_house")) {
                callEncodingHouseService = true;
            } else if (!callEncodingHouseService) {
                callEncodingHouseService = true;
            }
        }
        return this.invokeStandard(operationName, args, logableParameters, hidePassword, callEncodingHouseService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> invokeStandard(String operationName, Map<String, Object> args, Map<String, Object> logableParameters, boolean hidePassword, boolean callEncodingHouseService) {
        Map<String, Object> returnValue = null;
        Logger.extreme("Using operation named: " + operationName);
        try {
            this.appendClientInformationToArgs(args);
            args.put(ARGUMENT_DICT__TRANSPORTER_ARGS_KEY, Application.commandLineArgsAsString());
            StatisticCollector statCollector = Application.getStatisticCollector();
            Statistic previousStat = statCollector.startOperationReturningPreviousStatistic(operationName);
            if (null != previousStat && previousStat.isFinished()) {
                Double secs = previousStat.getDurationInSeconds();
                args.put(ARGUMENT_DICT__STATISTICS_PREVIOUS_CALL_DURATION_IN_SECS_KEY, secs);
            }
            String nowString = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(System.currentTimeMillis());
            args.put(ARGUMENT_DICT__STATISTICS_CLIENT_START_DATE_TIME_ZONE_ISO_KEY, nowString);
            Map<String, Object> toLog = this.filterLogableArguments(args);
            if (logableParameters != null) {
                toLog.putAll(logableParameters);
            }
            this.logInputParameters(toLog, hidePassword);
            try {
                returnValue = callEncodingHouseService ? this.mzEncodingHouseServiceCall(operationName, args) : this.mzITunesProducerServiceCall(operationName, args);
            }
            finally {
                statCollector.stopCurrent();
            }
            Application.collectInfoMessages(returnValue);
            Application.collectWarningMessages(returnValue);
            Application.checkUpdateOverride(returnValue);
            this.logReturnValue(returnValue, true);
        }
        catch (RuntimeException t) {
            Logger.error("An error occurred while invoking service method: " + operationName, t);
        }
        return returnValue;
    }

    protected abstract String getDefaultMZEncodingHouseServiceAddress();

    protected abstract String getDefaultMZITunesProducerServiceAddress();

    protected abstract Map<String, Object> mzEncodingHouseServiceCall(String var1, Map<String, Object> var2);

    protected abstract Map<String, Object> mzITunesProducerServiceCall(String var1, Map<String, Object> var2);

    protected String getMZITunesProducerServiceAddress() {
        String serviceAddress = System.getProperty("iTPServiceAddress");
        if ((serviceAddress == null || serviceAddress.equals("")) && ((serviceAddress = System.getProperty("serviceAddress")) == null || serviceAddress.equals(""))) {
            serviceAddress = this.getDefaultMZITunesProducerServiceAddress();
        }
        return serviceAddress;
    }

    protected String getMZEncodingHouseServiceAddress() {
        String serviceAddress = System.getProperty("encodingHouseServiceAddress");
        if ((serviceAddress == null || serviceAddress.equals("")) && ((serviceAddress = System.getProperty("serviceAddress")) == null || serviceAddress.equals(""))) {
            serviceAddress = this.getDefaultMZEncodingHouseServiceAddress();
        }
        return serviceAddress;
    }

    protected abstract boolean testServiceAddress(String var1);

    private void addAuthenticationArgumentsInSession(Map<String, Object> args) {
        args.put(ARGUMENT_DICT__USERNAME_KEY, UsernameOption.username());
        if (!this.hasSession()) {
            if (Hsa2HeadersOption.hsa2headersWereGiven()) {
                args.put(ARGUMENT_DICT__HSA2HEADERS_KEY, Hsa2HeadersOption.hsa2headers());
            } else if (DSTokenOption.dsTokenWasGiven()) {
                args.put(ARGUMENT_DICT__DSTOKEN_KEY, DSTokenOption.dsToken());
            } else {
                args.put(ARGUMENT_DICT__PASSWORD_KEY, System.getProperty("p"));
            }
        }
        if (ProviderNameOption.wasProviderNameGiven()) {
            args.put(ARGUMENT_DICT__PROVIDERNAME_KEY, ProviderNameOption.providerName());
        }
        if (ItcProviderNameOption.wasItcProviderNameGiven()) {
            args.put(ARGUMENT_DICT__ITCPROVIDERNAME_KEY, ItcProviderNameOption.itcProviderName());
        }
        if (AppPlatformOption.hasAppPlatform()) {
            String result = AppPlatformOption.appPlatform();
            args.put(ARGUMENT_DICT__APP_PLATFORM_KEY, result);
        }
    }

    private void addAuthenticationArguments(Map<String, Object> args) throws AuthenticationException {
        this.establishSessionAuthentication();
        this.addAuthenticationArgumentsInSession(args);
    }

    private void addAuthenticationArgumentsForNewSession(Map<String, Object> args) {
        this.addAuthenticationArgumentsInSession(args);
    }

    private void appendClientInformationToArgs(Map<String, Object> args) {
        String client = System.getProperty("transporter.client");
        String clientVersion = System.getProperty("transporter.client.version");
        String application = System.getProperty("projectName");
        String applicationVersion = System.getProperty("versionNumber");
        String osIdentifier = WebService.getOSIdentifier();
        String baseApplicationVersion = ConfigurationUtil.getBaseInstallVersion();
        String mode = System.getProperty("m");
        if (baseApplicationVersion != null) {
            args.put(ARGUMENT_DICT__BASE_VERSION_KEY, baseApplicationVersion);
        }
        if (application != null) {
            args.put(ARGUMENT_DICT__APPLICATION_KEY, application);
        }
        if (applicationVersion != null) {
            args.put(ARGUMENT_DICT__VERSION_KEY, applicationVersion);
        }
        if (osIdentifier != null) {
            args.put(ARGUMENT_DICT__OS_IDENTIFIER_KEY, osIdentifier);
        }
        if (client != null) {
            args.put(ARGUMENT_DICT__CLIENT_KEY, client);
        }
        if (clientVersion != null) {
            args.put(ARGUMENT_DICT__CLIENT_VERSION_KEY, clientVersion);
        }
        if (mode != null) {
            args.put(ARGUMENT_DICT__MODE_KEY, mode);
        }
    }

    private Map<String, Object> filterLogableArguments(Map<String, Object> args) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : args.keySet()) {
            if (ARGUMENT_DICT__ASSET_DESCRIPTIONS_KEY.equals(key) || ARGUMENT_DICT__ASSET_DESCRIPTIONS_COMPRESSED_KEY.equals(key)) continue;
            if (ARGUMENT_DICT__HSA2HEADERS_KEY.equals(key)) {
                result.put(key, "**hidden value**");
                continue;
            }
            if (ARGUMENT_DICT__METADATA_COMPRESSED_KEY.equals(key) || ARGUMENT_DICT__TRANSPORT_LOG_COMPRESSED_KEY.equals(key) || ARGUMENT_DICT__EXTRA_TRANSPORT_LOG_COMPRESSED_KEY.equals(key)) {
                result.put(key, "(suppressed)");
                continue;
            }
            result.put(key, args.get(key));
        }
        return result;
    }

    private List<String> getValidFileNames(ITMSPackage itmsPackage) {
        List<File> validFiles = itmsPackage.allPackageFiles();
        ArrayList<String> validFileNames = new ArrayList<String>();
        for (File file : validFiles) {
            validFileNames.add(file.getName());
        }
        return validFileNames;
    }

    private void addMetadataArgument(ITMSPackage itmsPackage, Map<String, Object> arguments) {
        if (System.getProperty("disableParameterCompression") != null) {
            arguments.put(ARGUMENT_DICT__METADATA_KEY, itmsPackage.metadataFileContents());
        } else {
            try {
                arguments.put(ARGUMENT_DICT__METADATA_COMPRESSED_KEY, StreamUtil.stringToBase64Gzip(itmsPackage.metadataFileContents()));
            }
            catch (IOException e) {
                Logger.info("Failed to compress metadata.xml; sending raw bytes", e);
                arguments.put(ARGUMENT_DICT__METADATA_KEY, itmsPackage.metadataFileContents());
            }
        }
        try {
            arguments.put(ARGUMENT_DICT__METADATA_CHECKSUM_KEY, itmsPackage.metadataFileChecksum());
        }
        catch (Exception e) {
            Logger.warn("Failed to md5 metadata.xml", e);
        }
    }

    private void appendAssetValidationUploadAttributesToAuthenticateArguments(Map<String, Object> args, AssetValidationUpload upload) {
        String checksum = upload.getChecksum();
        String filename = upload.getFilename();
        Long size = upload.getSize();
        args.put(ARGUMENT_DICT__CHECKSUM_KEY, checksum);
        args.put(ARGUMENT_DICT__FILENAME_KEY, filename);
        args.put(ARGUMENT_DICT__FILE_SIZE_KEY, size);
    }

    private void appendAssetValidationUploadAttributesToVerifyArguments(Map<String, Object> args, AssetValidationUpload upload) {
        args.put(ARGUMENT_DICT__FILENAME_KEY, upload.getNewFilename());
    }

    protected void logInputParameters(Map<String, Object> parameters, boolean hidePassword) {
        if (parameters == null) {
            return;
        }
        String passwordValue = System.getProperty("p");
        ArrayList<String> sortedKeys = new ArrayList<String>(parameters.keySet());
        Collections.sort(sortedKeys);
        Iterator iterator = sortedKeys.iterator();
        Logger.extreme("Apple's web service operation input parameters:");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object aParameter = parameters.get(key);
            boolean isParameterString = false;
            if (aParameter instanceof String) {
                isParameterString = true;
            }
            String valueToDisplay = null;
            valueToDisplay = hidePassword && isParameterString && (aParameter.equals(passwordValue) || key.equalsIgnoreCase(ARGUMENT_DICT__DSTOKEN_KEY) || key.equalsIgnoreCase(ARGUMENT_DICT__HSA2HEADERS_KEY)) ? "**hidden value**" : (this.displayStringForKeyShouldBeNullOrNotNullString(key) ? this.nullOrNotNullDisplayStringForValue(aParameter) : this.convertToDisplayValue(aParameter));
            if (valueToDisplay == null) continue;
            Logger.extreme("  parameter " + key + " = " + valueToDisplay);
        }
    }

    private boolean displayStringForKeyShouldBeNullOrNotNullString(Object aKey) {
        if (!(aKey instanceof String)) {
            return false;
        }
        String keyString = (String)aKey;
        if (keyString == null || keyString.length() == 0) {
            return false;
        }
        if (keyString.equals(ARGUMENT_DICT__TRANSPORT_LOG_KEY) || keyString.equals(ARGUMENT_DICT__EXTRA_TRANSPORT_LOG_KEY) || keyString.equals(System.getProperty("imageValidationActionKey")) || keyString.equals(System.getProperty("imageValidationMinimumSizeFailMessageKey"))) {
            return true;
        }
        return (System.getProperty("m").equalsIgnoreCase("iTunesExtraQCDownload") || System.getProperty("m").equalsIgnoreCase("iTunesLPQCDownload")) && keyString.equalsIgnoreCase("QCUrl");
    }

    private String nullOrNotNullDisplayStringForValue(Object aValue) {
        String displayString = "null value";
        if (aValue != null) {
            displayString = "not null value (just not showing the value)";
        }
        return displayString;
    }

    private String convertToDisplayValue(Object value) {
        if (value == null) {
            return "(null)";
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            Object[] prototype = (Object[])value;
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int index = 0; index < prototype.length; ++index) {
                if (index > 0) {
                    builder.append(", ");
                }
                builder.append(this.convertToDisplayValue(prototype[index]));
            }
            builder.append("]");
            return builder.toString();
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Map valueAsHashMap = (Map)value;
            if (this.mapIsChecksumGzipBlob(valueAsHashMap)) {
                return "-ChecksumGzipBlob-";
            }
            HashMap displayableHashMap = new HashMap();
            for (Object key : valueAsHashMap.keySet()) {
                Object valueFromHashMap = valueAsHashMap.get(key);
                String displayStringForValueFromHashMap = "(null)";
                if (this.displayStringForKeyShouldBeNullOrNotNullString(key)) {
                    displayStringForValueFromHashMap = this.nullOrNotNullDisplayStringForValue(valueFromHashMap);
                } else if (valueFromHashMap != null) {
                    try {
                        displayStringForValueFromHashMap = this.convertToDisplayValue(valueFromHashMap);
                    }
                    catch (RuntimeException re) {
                        displayStringForValueFromHashMap = valueFromHashMap.toString();
                    }
                }
                displayableHashMap.put(key, displayStringForValueFromHashMap);
            }
            return displayableHashMap.toString();
        }
        return value.toString();
    }

    protected void logReturnValue(Map<String, Object> returnValue, boolean hidePassword) {
        Object aValue;
        if (returnValue == null) {
            return;
        }
        Set<String> keys = returnValue.keySet();
        if (keys == null) {
            return;
        }
        ArrayList<String> visibleKeys = new ArrayList<String>(keys.size());
        for (String aKey : keys) {
            if (this.shouldHideResponseKey(aKey) || this.shouldHideResponseValue(aValue = returnValue.get(aKey))) continue;
            visibleKeys.add(aKey);
        }
        if (visibleKeys.isEmpty()) {
            Logger.extreme("Apple's web service operation returned");
            return;
        }
        Logger.extreme("Apple's web service operation return value:");
        for (String aKey : visibleKeys) {
            aValue = returnValue.get(aKey);
            if (aKey.equals("ErrorMessage") && null != aValue && aValue instanceof String) {
                String val = this.overridenErrorMessage((String)aValue);
                if (null != val) {
                    returnValue.put(aKey, val);
                    aValue = val;
                }
            } else if (aKey.equals("Errors") && aValue instanceof Object[]) {
                Object[] errors = (Object[])aValue;
                int i = 0;
                for (Object obj : errors) {
                    String value;
                    if (obj instanceof String && null != (value = this.overridenErrorMessage((String)obj))) {
                        errors[i] = value;
                    }
                    ++i;
                }
                returnValue.put(aKey, errors);
            }
            String value = null;
            value = hidePassword && aKey.toLowerCase().indexOf("password") != -1 ? "**hidden value**" : (aKey.equalsIgnoreCase("SharedSecret") ? "**hidden value**" : (this.displayStringForKeyShouldBeNullOrNotNullString(aKey) ? this.nullOrNotNullDisplayStringForValue(aValue) : this.convertToDisplayValue(aValue)));
            Logger.extreme("  parameter " + aKey + " = " + value);
        }
    }

    private String overridenErrorMessage(String message) {
        if (message.contains("(-20101)") && !PasswordOption.wasProvided() && PasswordOption.shouldProvidePassword()) {
            return "The password must have a non-empty value.";
        }
        return null;
    }

    private boolean shouldHideResponseValue(Object aValue) {
        if (!(aValue instanceof Map)) {
            return false;
        }
        Map mapValue = (Map)aValue;
        return this.mapIsChecksumGzipBlob(mapValue);
    }

    public boolean hasSession() {
        return this.sessionId != null && !this.sessionId.isEmpty() && this.sharedSecret != null && !this.sharedSecret.isEmpty();
    }

    public void removeSession() {
        this.sessionId = null;
        this.sharedSecret = null;
    }

    public void addSessionHeaders(HttpRequestBase method) {
        String rangeString;
        String urlmd5;
        if (!this.hasSession()) {
            return;
        }
        StringBuilder tohash = new StringBuilder(this.sessionId);
        String url = method.getURI().getRawPath();
        if (method.getURI().getRawQuery() != null) {
            url = url + '?' + method.getURI().getRawQuery();
        }
        if ((urlmd5 = WebService.digest(url)) == null) {
            return;
        }
        tohash.append(urlmd5);
        Header rangeHeader = method.getFirstHeader("Content-Range");
        if (rangeHeader != null && (rangeString = rangeHeader.getValue()) != null && !rangeString.isEmpty()) {
            String rangemd5 = WebService.digest(rangeString);
            tohash.append(rangemd5);
        }
        String requestId = UUID.randomUUID().toString();
        tohash.append(requestId);
        tohash.append(this.sharedSecret);
        String requestDigest = WebService.digest(tohash.toString());
        method.setHeader(WebService.sessionDigestHeader(), requestDigest);
        method.setHeader(WebService.requestIdHeader(), requestId);
        method.setHeader(WebService.sessionIdHeader(), this.sessionId);
    }

    private static String digest(String tohash) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(WebService.messageDigestMethod());
            byte[] mdhash = messageDigest.digest(tohash.getBytes("UTF-8"));
            return StringUtil.byteArrayToHexString(mdhash).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            Logger.debug("unable to find " + WebService.messageDigestMethod() + " digest");
        }
        catch (UnsupportedEncodingException e) {
            Logger.debug("unable to find UTF-8 encoding");
        }
        return null;
    }

    private boolean mapIsChecksumGzipBlob(Map mapValue) {
        String checksumKey = System.getProperty("checksummedBlobChecksumKey");
        String gzipContentKey = System.getProperty("checksummedBlobGzipContentKey");
        return mapValue.containsKey(checksumKey) && mapValue.containsKey(gzipContentKey);
    }

    private Set<String> loggingResponseKeysToIgnore() {
        if (this.loggingResponseKeysToIgnore == null || this.loggingResponseKeysToIgnore.isEmpty()) {
            HashSet<String> newValue = new HashSet<String>();
            String responseKeysToIgnore = System.getProperty("loggingResponseKeysToIgnore");
            if (responseKeysToIgnore != null && responseKeysToIgnore.trim().length() != 0) {
                String[] split;
                for (String s : split = responseKeysToIgnore.split(",")) {
                    newValue.add(s.trim().toLowerCase());
                }
            }
            this.loggingResponseKeysToIgnore = newValue;
        }
        return this.loggingResponseKeysToIgnore;
    }

    private boolean shouldHideResponseKey(String param) {
        if (param == null) {
            return true;
        }
        if (System.getProperty("m") == null) {
            return false;
        }
        if (System.getProperty("m").equalsIgnoreCase("generateSchema") && param.equalsIgnoreCase("schema")) {
            return true;
        }
        if (param.startsWith("$") && param.endsWith("$")) {
            return true;
        }
        return this.loggingResponseKeysToIgnore().contains(param.toLowerCase());
    }

    public static String messageDigestMethod() {
        return System.getProperty("messageDigestMethod", "MD5");
    }

    public static String sessionDigestHeader() {
        return System.getProperty("sessionDigestHeader", "x-session-digest");
    }

    public static String sessionIdHeader() {
        return System.getProperty("sessionIdHeader", "x-session-id");
    }

    public static String requestIdHeader() {
        return System.getProperty("requestIdHeader", "x-request-id");
    }

    private boolean shouldUseSessionAuthentication() {
        if (!this.attemptSessionAuthentication) {
            return false;
        }
        if (System.getProperty("shouldUseSessionAuthentication") != null) {
            return Boolean.getBoolean("shouldUseSessionAuthentication");
        }
        return true;
    }

    public static class AuthenticationException
    extends Exception {
        private static final long serialVersionUID = 7627308166813067104L;
        private final Map<String, Object> results;

        public AuthenticationException(Map<String, Object> results) {
            super("Authentication Failed");
            this.results = results;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }
    }
}

