/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.exception.ConcurrentTransportException;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.ProcUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;

public class UploadTokenManager {
    private static final int LOCK_RETRY_INITIAL_WAIT_MS = 5000;
    private static final int LOCK_RETRY_MAX_ATTEMPTS = 3;
    private static final UploadTokenManager instance = new UploadTokenManager();
    private final Map<String, Token> tokenMap = new HashMap<String, Token>();

    private UploadTokenManager() {
    }

    public static UploadTokenManager instance() {
        return instance;
    }

    public void deleteToken(String contentProvider, String vendorId) {
        Token token;
        String key = UploadTokenManager.tokenFilePath(contentProvider, vendorId);
        if (key != null && (token = this.tokenMap.remove(key)) != null) {
            token.release();
            if (token.file != null) {
                Logger.extreme("Removing token at path " + token.file.getPath());
                if (!token.file.delete()) {
                    token.file.deleteOnExit();
                }
            }
        }
    }

    private static String tokenFilePath(String contentProvider, String vendorId) {
        File tokenFolderPath;
        File configHome = FileUtil.localConfigHome();
        if (configHome != null && ((tokenFolderPath = new File(configHome + File.separator + "UploadTokens")).mkdirs() || tokenFolderPath.exists() && tokenFolderPath.isDirectory())) {
            String tokenPath = tokenFolderPath.getPath() + File.separator + UploadTokenManager.getHostName() + "_" + contentProvider.replace(' ', '_') + "_" + vendorId.replace(' ', '_') + ".token";
            return tokenPath;
        }
        return null;
    }

    public String setToken(String contentProvider, String vendorId, String token) {
        try {
            return this.setToken(contentProvider, vendorId, token, false);
        }
        catch (ConcurrentTransportException e) {
            return null;
        }
    }

    public String testAndSetToken(String contentProvider, String vendorId, String token) throws ConcurrentTransportException {
        return this.setToken(contentProvider, vendorId, token, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setToken(String contentProvider, String vendorId, String tokenString, boolean performTest) throws ConcurrentTransportException {
        String string;
        Token token = new Token(tokenString);
        String tokenFilePath = UploadTokenManager.tokenFilePath(contentProvider, vendorId);
        if (tokenFilePath == null) {
            Logger.debug("Cannot create token file");
            return null;
        }
        Token oldToken = this.tokenMap.remove(tokenFilePath);
        if (oldToken != null) {
            Logger.extreme("Existing token found, cleaning up");
            oldToken.release();
        }
        File tokenFile = new File(tokenFilePath);
        Logger.debug("Using token file path " + tokenFile.getPath());
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        boolean acquired = false;
        try {
            tokenFile.createNewFile();
            raf = new RandomAccessFile(tokenFile, "rws");
            channel = raf.getChannel();
            lock = UploadTokenManager.tryLockWithRetry(tokenFile, (FileChannel)channel);
            if (lock == null) {
                String string2 = null;
                return string2;
            }
            int len = (int)raf.length();
            if (performTest && len > 0) {
                Logger.debug("Token exists, examining");
                byte[] buf = new byte[len];
                raf.read(buf);
                Token existingToken = Token.demarshal(new String(buf, "utf-8"));
                Logger.debug("Token pid: " + existingToken.pid + ", found process = " + ProcUtil.processExists(existingToken.pid) + "; my pid: " + ProcUtil.getPid());
                if (existingToken.pid != ProcUtil.getPid() && ProcUtil.processExists(existingToken.pid)) {
                    throw new ConcurrentTransportException();
                }
                Logger.debug("Reusing existing token: " + existingToken.token);
                token = new Token(existingToken.token);
            }
            raf.seek(0L);
            raf.setLength(0L);
            raf.write(token.marshal());
            token.file = tokenFile;
            token.raf = raf;
            token.channel = channel;
            token.lock = lock;
            this.tokenMap.put(tokenFilePath, token);
            acquired = true;
            Logger.debug("Set token: " + token.token);
            string = token.token;
        }
        catch (IOException e) {
            Logger.debug("Error reading token at " + tokenFile.getPath());
            String string3 = null;
            return string3;
        }
        finally {
            if (!acquired) {
                if (lock != null) {
                    try {
                        Logger.extreme("Releasing token file lock");
                        lock.release();
                    }
                    catch (IOException iOException) {}
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return string;
    }

    private static FileLock tryLockWithRetry(File file, FileChannel channel) throws ConcurrentTransportException {
        long waitTime = 5000L;
        int attemptNumber = 0;
        try {
            do {
                Logger.debug("Attempting exclusive file lock on token file");
                FileLock lock = channel.tryLock(0L, Long.MAX_VALUE, false);
                if (lock != null) {
                    return lock;
                }
                if (++attemptNumber >= 3) continue;
                Thread.sleep(waitTime);
                waitTime *= 2L;
            } while (attemptNumber < 3);
            Logger.warn("Failed to obtain exclusive lock on token file.  Please ensure the following file is not locked by another process: " + file.getCanonicalPath());
            if (FileUtil.canUseNIOLocking()) {
                throw new ConcurrentTransportException();
            }
        }
        catch (IOException e) {
            Logger.warn("Exception attempting to obtain file lock", e);
        }
        catch (InterruptedException e) {
            Logger.warn("Exception attempting to obtain file lock", e);
        }
        return null;
    }

    static String getHostName() {
        String result = "localhost";
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    private static class Token {
        final String token;
        final int pid;
        File file;
        RandomAccessFile raf;
        FileChannel channel;
        FileLock lock;

        private Token(String token) {
            this.token = token;
            this.pid = ProcUtil.getPid();
        }

        private Token(String token, int pid) {
            this.token = token;
            this.pid = pid;
        }

        static Token demarshal(String in) {
            String token = in;
            int pid = 0;
            int lastTilde = in.lastIndexOf("~");
            if (lastTilde != -1) {
                pid = Integer.parseInt(in.substring(lastTilde + 1).trim());
                token = in.substring(0, lastTilde);
            }
            return new Token(token, pid);
        }

        byte[] marshal() {
            String tokenWithPid = this.token + "~" + this.pid;
            try {
                return tokenWithPid.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return tokenWithPid.getBytes();
            }
        }

        void release() {
            if (this.file != null) {
                Logger.extreme("Unlocking token at path " + this.file.getPath());
                if (this.lock != null) {
                    try {
                        Logger.extreme("Releasing token file lock");
                        this.lock.release();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

