/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeCode
implements Comparable {
    public static final String QTEXT_TIMECODE_REGEX = "((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\.(\\d{1,3}))?";
    public static final String W3C_TIMED_TEXT_REGEXP = "((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\:(\\d+))";
    protected long time;
    protected long hourComponent;
    protected long minuteComponent;
    protected long secondComponent;
    protected long millisComponent;
    private String _prettyDescription;
    protected static final Pattern QTTEXT_TIMECODE = Pattern.compile("((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\.(\\d{1,3}))?");
    protected static final Pattern W3C_TIMED_TEXT = Pattern.compile("((\\d*):)??((\\d\\d):)?(\\d{2,4})(\\:(\\d+))");
    protected static final int QTTEXT_HOUR_GROUP = 2;
    protected static final int QTTEXT_MINUTE_GROUP = 4;
    protected static final int QTTEXT_SECOND_GROUP = 5;
    protected static final int QTTEXT_MILLIS_GROUP = 7;
    protected static final int W3C_HOUR_GROUP = 2;
    protected static final int W3C_MINUTE_GROUP = 4;
    protected static final int W3C_SECOND_GROUP = 5;
    protected static final int W3C_FRAMES_GROUP = 7;
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;

    protected TimeCode() {
    }

    public static TimeCode parseQTTextString(String timeCodeString) throws IllegalArgumentException {
        Matcher matcher = QTTEXT_TIMECODE.matcher(timeCodeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(timeCodeString + " does not match expected expression " + QTTEXT_TIMECODE.pattern());
        }
        TimeCode timeCode = new TimeCode();
        if (matcher.group(2) != null) {
            timeCode.hourComponent = Long.parseLong(matcher.group(2));
        }
        if (matcher.group(4) != null) {
            timeCode.minuteComponent = Long.parseLong(matcher.group(4));
        }
        if (matcher.group(5) != null) {
            timeCode.secondComponent = Long.parseLong(matcher.group(5));
        }
        if (matcher.group(7) != null) {
            timeCode.millisComponent = Long.parseLong(matcher.group(7));
        }
        timeCode.time = timeCode.millisComponent + timeCode.secondComponent * 1000L + timeCode.minuteComponent * 60000L + timeCode.hourComponent * 3600000L;
        return timeCode;
    }

    public static TimeCode parseMillis(String millis) {
        return TimeCode.parseMillis(Long.parseLong(millis));
    }

    public static TimeCode parseW3CTimedTextClockTimeString(String timedTextString, int frameRate) throws IllegalArgumentException {
        Matcher matcher = W3C_TIMED_TEXT.matcher(timedTextString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(timedTextString + " does not match expected expression " + W3C_TIMED_TEXT.pattern());
        }
        TimeCode timeCode = new TimeCode();
        if (matcher.group(2) != null) {
            timeCode.hourComponent = Long.parseLong(matcher.group(2));
        }
        if (matcher.group(4) != null) {
            timeCode.minuteComponent = Long.parseLong(matcher.group(4));
        }
        if (matcher.group(5) != null) {
            timeCode.secondComponent = Long.parseLong(matcher.group(5));
        }
        if (matcher.group(7) != null) {
            long frames = Long.parseLong(matcher.group(7));
            timeCode.millisComponent = frames / (long)frameRate * 1000L;
        }
        timeCode.time = timeCode.millisComponent + timeCode.secondComponent * 1000L + timeCode.minuteComponent * 60000L + timeCode.hourComponent * 3600000L;
        return timeCode;
    }

    public static TimeCode parseMillis(long millis) {
        TimeCode timeCode = new TimeCode();
        timeCode.time = millis;
        timeCode.hourComponent = millis / 3600000L;
        timeCode.minuteComponent = (millis -= timeCode.hourComponent * 3600000L) / 60000L;
        timeCode.secondComponent = (millis -= timeCode.minuteComponent * 60000L) / 1000L;
        timeCode.millisComponent = millis -= timeCode.secondComponent * 1000L;
        return timeCode;
    }

    public long getMillis() {
        return this.time;
    }

    public String getMillisString() {
        return String.valueOf(this.time);
    }

    public long getHoursComponent() {
        return this.hourComponent;
    }

    public long getMinutesComponent() {
        return this.minuteComponent;
    }

    public long getSecondsComponent() {
        return this.secondComponent;
    }

    public long getMillisComponent() {
        return this.millisComponent;
    }

    public long getRoundedSeconds() {
        return this.getSecondsComponent() + (this.getMillisComponent() > 499L ? 1L : 0L);
    }

    public String toMMSSString() {
        return this.twoDigit(this.getHoursComponent() * 60L + this.getMinutesComponent()) + ":" + this.twoDigit(this.getRoundedSeconds());
    }

    public String toHMMSSString() {
        return (this.getHoursComponent() == 0L ? "" : this.getHoursComponent() + ":") + this.twoDigit(this.getMinutesComponent()) + ":" + this.twoDigit(this.getRoundedSeconds());
    }

    public String toQTTextString() {
        return this.twoDigit(this.getHoursComponent()) + ":" + this.twoDigit(this.getMinutesComponent()) + ":" + this.twoDigit(this.getSecondsComponent()) + "." + this.threeDigit(this.getMillisComponent());
    }

    public String toSMPTETimeCode(boolean dropFrame, float frameRate) {
        throw new RuntimeException("Unimplemented method.");
    }

    private String twoDigit(long value) {
        return value < 10L ? "0" + value : String.valueOf(value);
    }

    private String threeDigit(long value) {
        return value < 100L ? "0" + this.twoDigit(value) : String.valueOf(value);
    }

    public String toString() {
        return this.toQTTextString();
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot compare to null.");
        }
        if (!(object instanceof TimeCode)) {
            throw new ClassCastException("Cannot compare TimeCode to " + object);
        }
        TimeCode otherTimeCode = (TimeCode)object;
        return new Long(this.time).compareTo(new Long(otherTimeCode.time));
    }

    public String prettyDescription() {
        if (this._prettyDescription == null) {
            this._prettyDescription = this.toQTTextString();
        }
        return this._prettyDescription;
    }
}

