/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PackageMover {
    private static PackageMover sharedInstance;
    private File successDir;
    private File failureDir;
    private boolean shouldDeleteSuccessfulPackages = false;
    private boolean _registeredUploadSucceededNotification = false;
    private boolean _registeredUploadFailedNotification = false;

    public static void setupToDeletePackagesThatSucceeded() {
        PackageMover.sharedInstance().setShouldDeleteSuccessfulPackages(true);
        PackageMover.sharedInstance().registerPackageUploadSucceededNotification();
    }

    public static void setupToMovePackagesThatSucceeded(String aDirectoryPath) {
        if (aDirectoryPath == null || aDirectoryPath.length() == 0) {
            Logger.error("The directory path for the success option is invalid.  The successfully uploaded packages will NOT be moved.");
            return;
        }
        Logger.info("Setting successful uploads folder to: " + aDirectoryPath);
        try {
            aDirectoryPath = FileUtil.absolutePathForPath(aDirectoryPath);
        }
        catch (IOException ioe) {
            Logger.error("Could not get the full path for the success option. The successfully uploaded packages will NOT be moved.", ioe);
            return;
        }
        File aDir = new File(aDirectoryPath);
        if (!aDir.exists()) {
            Logger.error(aDir.getAbsolutePath() + " does NOT exist. The successfully uploaded packages will NOT be moved.");
            return;
        }
        if (!aDir.isDirectory()) {
            Logger.error(aDir.getAbsolutePath() + " is NOT a directory. The successfully uploaded packages will NOT be moved.");
            return;
        }
        if (!aDir.canWrite()) {
            Logger.error(aDir.getAbsolutePath() + " does NOT have write access. The successfully uploaded packages will NOT be moved.");
            return;
        }
        if (PackageMover.sharedInstance().successDir() != null) {
            Logger.error(System.getProperty("projectName") + " has alredy been setup with a success directory, " + PackageMover.sharedInstance().successDir().getPath());
            return;
        }
        PackageMover.sharedInstance().setSuccessDir(aDir);
        PackageMover.sharedInstance().registerPackageUploadSucceededNotification();
    }

    private void registerPackageUploadSucceededNotification() {
        if (this._registeredUploadSucceededNotification) {
            return;
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(this, "packageUploadSucceeded", "PackageUploadSucceeded", null);
        this._registeredUploadSucceededNotification = true;
    }

    private void registerPackageUploadFailedNotification() {
        if (this._registeredUploadFailedNotification) {
            return;
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(this, "packageUploadFailed", "PackageUploadFailed", null);
        this._registeredUploadFailedNotification = true;
    }

    public static void setupToMovePackagesThatFailed(String aDirectoryPath) {
        if (aDirectoryPath == null || aDirectoryPath.length() == 0) {
            Logger.error("The directory path for the failure option is invalid.  The uploaded packages that fail to upload will NOT be moved.");
            return;
        }
        try {
            aDirectoryPath = FileUtil.absolutePathForPath(aDirectoryPath);
        }
        catch (IOException ioe) {
            Logger.error("Could not get the full path for the failure option. The uploaded packages that fail to upload will NOT be moved.", ioe);
            return;
        }
        File aDir = new File(aDirectoryPath);
        if (!aDir.exists()) {
            Logger.error(aDir.getAbsolutePath() + " does NOT exist. The uploaded packages that fail to upload will NOT be moved.");
            return;
        }
        if (!aDir.isDirectory()) {
            Logger.error(aDir.getAbsolutePath() + " is NOT a directory. The uploaded packages that fail to upload will NOT be moved.");
            return;
        }
        if (!aDir.canWrite()) {
            Logger.error(aDir.getAbsolutePath() + " does NOT have write access. The uploaded packages that fail to upload will NOT be moved.");
            return;
        }
        if (PackageMover.sharedInstance().failureDir() != null) {
            Logger.error(System.getProperty("projectName") + " has alredy been setup with a failure directory, " + PackageMover.sharedInstance().successDir().getPath() + ".");
            return;
        }
        PackageMover.sharedInstance().setFailureDir(aDir);
        PackageMover.sharedInstance().registerPackageUploadFailedNotification();
    }

    private static PackageMover sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new PackageMover();
        }
        return sharedInstance;
    }

    private PackageMover() {
    }

    private boolean shouldDeleteSuccessfulPackages() {
        return this.shouldDeleteSuccessfulPackages;
    }

    private void setShouldDeleteSuccessfulPackages(boolean value) {
        this.shouldDeleteSuccessfulPackages = value;
    }

    private File successDir() {
        return this.successDir;
    }

    private void setSuccessDir(File value) {
        this.successDir = value;
    }

    private File failureDir() {
        return this.failureDir;
    }

    private void setFailureDir(File value) {
        this.failureDir = value;
    }

    public void packageUploadSucceeded(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        String aPkgPath = (String)aNotification.getObject();
        if (this.shouldDeleteSuccessfulPackages()) {
            Logger.info("Deleting package: " + aPkgPath + " ...");
            boolean wasDeleted = this.deletePackageWithPath(aPkgPath);
            if (wasDeleted) {
                Logger.info("Finished deleting package");
            } else {
                Logger.error("Could not delete the package.");
            }
            return;
        }
        boolean wasMoved = this.movePackageToDir(aPkgPath, this.successDir());
        if (!wasMoved) {
            Logger.error("An error occurred while moving the package " + aPkgPath + " to the success directory.");
        }
    }

    public void packageUploadFailed(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        if (aNotification.getUserInfo().containsKey("UploadMayRetry") && Boolean.TRUE.equals(aNotification.getUserInfo().get("UploadMayRetry"))) {
            return;
        }
        String aPkgPath = (String)aNotification.getObject();
        boolean wasMoved = this.movePackageToDir(aPkgPath, this.failureDir());
        if (!wasMoved) {
            Logger.error("An error occurred while moving the package " + aPkgPath + " to the failure directory.");
        }
    }

    private boolean movePackageToDir(String aPkgPath, File destDir) {
        if (aPkgPath == null || aPkgPath.length() == 0 || destDir == null) {
            return false;
        }
        File packageFile = null;
        File newPackageFile = null;
        try {
            Logger.info("Moving package: " + aPkgPath + " ...");
            packageFile = new File(aPkgPath);
            String aPkgName = NSPathUtilities.lastPathComponent(aPkgPath);
            String newDirWithPackageName = NSPathUtilities.stringByAppendingPathComponent(destDir.getPath(), aPkgName);
            Logger.info("  to: " + newDirWithPackageName);
            newPackageFile = new File(newDirWithPackageName);
            if (newPackageFile.exists()) {
                Logger.info("  a package with the same name already exists");
                Date currentTime = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.S");
                String dateString = formatter.format(currentTime);
                newDirWithPackageName = newDirWithPackageName + " " + dateString;
                Logger.info("  using new package name: " + newDirWithPackageName);
                newPackageFile = new File(newDirWithPackageName);
            }
        }
        catch (Throwable t) {
            Logger.error("", t);
            return false;
        }
        boolean wasMoved = this.deleteOrMovePackage(packageFile, newPackageFile);
        if (wasMoved) {
            Logger.info("Finished moving package.");
        }
        return wasMoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteOrMovePackage(File packageFile, File newPackageFile) {
        if (packageFile == null) {
            return false;
        }
        if (!this.shouldDeleteSuccessfulPackages() && newPackageFile == null) {
            return false;
        }
        boolean wasSuccessful = false;
        boolean isWindows = TransportUtil.isOSWindows();
        if (isWindows && !this.shouldDeleteSuccessfulPackages()) {
            Logger.extreme("Windows OS detected");
        }
        if (!isWindows) {
            wasSuccessful = this.shouldDeleteSuccessfulPackages() ? packageFile.delete() : packageFile.renameTo(newPackageFile);
            return wasSuccessful;
        }
        int moveAttempts = 0;
        while (!wasSuccessful && moveAttempts < 10) {
            try {
                TransportUtil.needToSleep(100L, "Wait between move attempts on Windows");
                System.gc();
                if (this.shouldDeleteSuccessfulPackages()) {
                    wasSuccessful = packageFile.delete();
                    continue;
                }
                wasSuccessful = packageFile.renameTo(newPackageFile);
            }
            catch (Throwable t) {
                if (this.shouldDeleteSuccessfulPackages()) {
                    Logger.extreme("An error occurred while trying to delete: " + packageFile.getName(), t);
                } else {
                    Logger.extreme("An error occurred while trying to move: " + packageFile.getName() + " to: " + newPackageFile.getName(), t);
                }
                if (moveAttempts + 1 >= 10) continue;
                Logger.extreme("Another attempt will be made.");
            }
            finally {
                ++moveAttempts;
            }
        }
        return wasSuccessful;
    }

    private boolean deletePackageWithPath(String aPkgPath) {
        if (aPkgPath == null || aPkgPath.length() == 0) {
            return false;
        }
        File packageFile = new File(aPkgPath);
        if (!packageFile.canWrite()) {
            Logger.error(packageFile.getAbsolutePath() + " cannot be deleted because of its permissions.");
            return false;
        }
        boolean wasDeleted = false;
        if (packageFile.isDirectory()) {
            File[] tempFiles = packageFile.listFiles();
            if (tempFiles != null) {
                for (File aFile : tempFiles) {
                    wasDeleted = this.deletePackageWithPath(aFile.getAbsolutePath());
                    if (wasDeleted) continue;
                    Logger.debug("Cannot delete " + aFile.getAbsolutePath());
                    return false;
                }
            }
            wasDeleted = this.deleteOrMovePackage(packageFile, null);
        } else {
            wasDeleted = this.deleteOrMovePackage(packageFile, null);
        }
        return wasDeleted;
    }
}

