/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.NetworkReachability;
import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.foundation.NotificationObserver;
import com.apple.transporter.log.Logger;

public class NetworkReachabilityMonitor
implements NotificationObserver {
    public static final String NOTIFICATION_NAME = "NetworkReachabilityStatus";
    private static final NetworkReachabilityMonitor SharedInstance = new NetworkReachabilityMonitor();
    private NetworkReachability reachability = NetworkReachability.REACHABLE;
    private boolean observing = false;

    private NetworkReachabilityMonitor() {
    }

    @Override
    public synchronized void handleNotification(Notification notification) {
        Object obj = notification.getObject();
        if (obj == null) {
            Logger.error("Notification's object cannot be null");
            return;
        }
        if (obj instanceof String) {
            try {
                String value = (String)obj;
                NetworkReachability newValue = NetworkReachability.valueOf(value);
                if (newValue != this.reachability) {
                    this.reachability = newValue;
                    this.notifyAll();
                }
            }
            catch (IllegalArgumentException iax) {
                Logger.error(iax.getMessage());
            }
        } else {
            Logger.error("Notification's object should be a string");
        }
    }

    private synchronized void startObserving() {
        if (!this.observing) {
            NotificationCenter.defaultCenter().addObserver(this, NOTIFICATION_NAME, null);
            this.observing = true;
        }
    }

    private synchronized void stopObserving() {
        if (this.observing) {
            NotificationCenter.defaultCenter().removeObserver(this, NOTIFICATION_NAME, null);
            this.observing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkReachability reachability() {
        NetworkReachabilityMonitor networkReachabilityMonitor = SharedInstance;
        synchronized (networkReachabilityMonitor) {
            return NetworkReachabilityMonitor.SharedInstance.reachability;
        }
    }

    public static void start() {
        SharedInstance.startObserving();
    }

    public static void stop() {
        SharedInstance.stopObserving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaitResult waitForReachabilityWithTimeout(int sleepTimeMS) {
        NetworkReachabilityMonitor networkReachabilityMonitor = SharedInstance;
        synchronized (networkReachabilityMonitor) {
            NetworkReachability value = NetworkReachabilityMonitor.SharedInstance.reachability;
            if (value.isReachable()) {
                NetworkReachabilityMonitor networkReachabilityMonitor2 = SharedInstance;
                networkReachabilityMonitor2.getClass();
                return networkReachabilityMonitor2.new WaitResult(value, false);
            }
            try {
                SharedInstance.wait(sleepTimeMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            NetworkReachabilityMonitor networkReachabilityMonitor3 = SharedInstance;
            networkReachabilityMonitor3.getClass();
            return networkReachabilityMonitor3.new WaitResult(NetworkReachabilityMonitor.SharedInstance.reachability, true);
        }
    }

    public class WaitResult {
        public final NetworkReachability reachability;
        public final boolean didWait;

        private WaitResult(NetworkReachability reachability, boolean didWait) {
            this.reachability = reachability;
            this.didWait = didWait;
        }
    }
}

