/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.WebService;
import com.apple.transporter.log.Logger;
import com.apple.transporter.streaming.StreamingUtil;
import com.apple.transporter.streaming.api.StreamableContent;
import com.apple.transporter.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JSONService
extends WebService {
    private static final String MZEncodingHouseServiceAddress = "https://contentdelivery.itunes.apple.com/WebObjects/MZLabelService.woa/json/MZEncodingHouseService";
    private static final String MZITunesProducerServiceAddress = "https://contentdelivery.itunes.apple.com/WebObjects/MZLabelService.woa/json/MZITunesProducerService";
    private final CloseableHttpClient httpClient;
    private static final SimpleDateFormat IdDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public JSONService() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().useSystemProperties().disableCookieManagement();
        Integer readTimeout = Integer.getInteger("com.apple.transporter.httpReadTimeout");
        if (readTimeout != null && readTimeout >= 0) {
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(readTimeout.intValue()).build();
            clientBuilder.setDefaultSocketConfig(socketConfig);
        }
        clientBuilder.disableAutomaticRetries();
        this.httpClient = clientBuilder.build();
    }

    @Override
    protected String getDefaultMZEncodingHouseServiceAddress() {
        return MZEncodingHouseServiceAddress;
    }

    @Override
    protected String getDefaultMZITunesProducerServiceAddress() {
        return MZITunesProducerServiceAddress;
    }

    @Override
    protected Map<String, Object> mzEncodingHouseServiceCall(String operationName, Map<String, Object> parameters) {
        return this.invokeJson(this.getMZEncodingHouseServiceAddress(), operationName, parameters);
    }

    @Override
    protected Map<String, Object> mzITunesProducerServiceCall(String operationName, Map<String, Object> parameters) {
        return this.invokeJson(this.getMZITunesProducerServiceAddress(), operationName, parameters);
    }

    @Override
    protected boolean testServiceAddress(String serviceAddress) {
        String responseString;
        CloseableHttpResponse response;
        HttpGet get;
        if (serviceAddress == null || serviceAddress.length() == 0) {
            Logger.error("service address is null or empty");
            return false;
        }
        Logger.extreme("  Testing the web service: " + serviceAddress);
        try {
            get = new HttpGet(serviceAddress);
            get.addHeader("x-tx-correlation-key", WebService.TXCorrelationKeyHeaderValue);
        }
        catch (RuntimeException t) {
            Logger.error("An error occurred while creating a URL object for the web service " + serviceAddress, t);
            return false;
        }
        try {
            response = this.httpClient.execute((HttpUriRequest)get);
        }
        catch (ClientProtocolException e1) {
            Logger.error("An error occurred while connecting to the web servce " + serviceAddress, e1);
            return false;
        }
        catch (IOException e1) {
            Logger.error("An error occurred while connecting to the web servce " + serviceAddress, e1);
            return false;
        }
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity.getContentLength() <= 0L) {
            Logger.error("Web Service response is empty");
            return false;
        }
        ContentType contentType = ContentType.get((HttpEntity)responseEntity);
        if (!"application/schema+json".equalsIgnoreCase(contentType.getMimeType())) {
            Logger.error("Web Service content-type is not application/schema+json");
            return false;
        }
        try {
            responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
        }
        catch (ParseException e1) {
            Logger.error("An error occurred while reading the response from the web servce " + serviceAddress, e1);
            return false;
        }
        catch (IOException e1) {
            Logger.error("An error occurred while reading the response from the web servce " + serviceAddress, e1);
            return false;
        }
        try {
            this.javaObjectFromJSONString(responseString);
        }
        catch (Exception e) {
            Logger.error("Web Service returned an invalid response");
            return false;
        }
        return true;
    }

    private Map<String, Object> invokeJson(String address, String operationName, Map<String, Object> parameters) {
        String id = IdDateFormat.format(new Date());
        id = String.format("%s-%03d", id, (int)(Math.random() * 1000.0));
        Logger.info("id = " + id);
        try {
            List streamableList;
            Map<String, String> otherTxHeaders;
            HashMap<String, Object> jsonObj = new HashMap<String, Object>();
            jsonObj.put("id", id);
            jsonObj.put("jsonrpc", "2.0");
            jsonObj.put("method", operationName);
            jsonObj.put("params", parameters);
            byte[] jsonBytes = null;
            byte[] checksum = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                 DigestOutputStream dos = new DigestOutputStream(baos, MessageDigest.getInstance("md5"));
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)dos, StandardCharsets.UTF_8.name());){
                JSONObject.writeJSONString(jsonObj, (Writer)writer);
                writer.flush();
                jsonBytes = baos.toByteArray();
                checksum = dos.getMessageDigest().digest();
            }
            System.setProperty("sun.net.http.retryPost", "false");
            HttpPost post = new HttpPost(address);
            post.addHeader("x-tx-correlation-key", TXCorrelationKeyHeaderValue);
            post.addHeader("x-tx-method", operationName);
            if (null != TXVersionNumberString) {
                post.addHeader("x-tx-version", TXVersionNumberString);
            }
            if (null != (otherTxHeaders = this.getTransporterHeaders())) {
                otherTxHeaders.forEach((key, value) -> {
                    if (null == value) {
                        return;
                    }
                    String headerName = key.toLowerCase().startsWith("x-tx-") ? key : "x-tx-" + key;
                    post.addHeader(headerName, value);
                });
            }
            if (null == (streamableList = (List)parameters.get("StreamingInfoList")) || streamableList.isEmpty()) {
                post.setEntity((HttpEntity)new ByteArrayEntity(jsonBytes, ContentType.APPLICATION_JSON));
            } else {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.STRICT).addBinaryBody("jsonrpc", jsonBytes, ContentType.APPLICATION_JSON, null);
                for (StreamableContent streamable : streamableList) {
                    ContentType contentType = ContentType.parse((String)streamable.getContentType());
                    String serverFileName = StreamingUtil.getServerFile(streamable).toString();
                    FormBodyPartBuilder bodyPartBuilder = FormBodyPartBuilder.create().setName(streamable.getFileName());
                    File file = new File(streamable.getFilePath());
                    if (file.exists()) {
                        bodyPartBuilder.setBody((ContentBody)new FileBody(file, contentType));
                    } else {
                        bodyPartBuilder.setBody((ContentBody)new InputStreamBody(streamable.getInputStream(), contentType, serverFileName));
                    }
                    builder.addPart(bodyPartBuilder.build());
                }
                post.setEntity(builder.build());
            }
            String acceptLanguage = this.getLocaleString();
            if (acceptLanguage != null) {
                post.setHeader("Accept-Language", acceptLanguage);
            }
            if (this.computeNextRequestChecksum) {
                this.requestChecksum = checksum;
            }
            if (this.sessionId() != null && !this.sessionId().isEmpty() && this.sharedSecret() != null && !this.sharedSecret().isEmpty()) {
                MessageDigest messageDigest = MessageDigest.getInstance(JSONService.messageDigestMethod());
                messageDigest.update(this.sessionId().getBytes("UTF-8"));
                messageDigest.update(checksum);
                messageDigest.update(id.getBytes("UTF-8"));
                messageDigest.update(this.sharedSecret().getBytes("UTF-8"));
                post.setHeader("x-session-version", "2");
                byte[] mdhash = messageDigest.digest();
                String digestString = StringUtil.byteArrayToHexString(mdhash);
                post.setHeader(JSONService.sessionDigestHeader(), digestString);
                post.setHeader(JSONService.sessionIdHeader(), this.sessionId());
                post.setHeader(JSONService.requestIdHeader(), id);
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            HttpEntity responseEntity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            ContentType contentType = ContentType.get((HttpEntity)responseEntity);
            if (contentType != null && ContentType.APPLICATION_JSON.getMimeType().equalsIgnoreCase(contentType.getMimeType())) {
                if (responseString.length() > 0) {
                    Map txHeaders;
                    Map jsonResponse = (Map)this.javaObjectFromJSONString(responseString);
                    Map result = (Map)jsonResponse.get("result");
                    if (null != result && null != (txHeaders = (Map)result.get("TxHeaders"))) {
                        HashMap<String, String> convertedHeaders = new HashMap<String, String>();
                        txHeaders.forEach((key, value) -> {
                            if (null == value) {
                                return;
                            }
                            String headerName = key.toLowerCase().startsWith("x-tx-") ? key : "x-tx-" + key;
                            convertedHeaders.put(headerName, value.toString());
                        });
                        this.setTransporterHeaders(convertedHeaders);
                    }
                    return result;
                }
            } else {
                if (null != contentType) {
                    if (statusLine.getStatusCode() <= 400) {
                        Logger.error("Web service receieved content-type: [" + contentType.getMimeType() + "] expected: [" + ContentType.APPLICATION_JSON.getMimeType() + "]");
                    }
                } else {
                    Logger.error("Web service received an unknown content-type, expected: [" + ContentType.APPLICATION_JSON.getMimeType() + "]");
                }
                Logger.warn("Web service received a server status of: " + statusLine);
                Logger.warn("Web service response received: " + responseString);
                throw new ServerResponseException("Communication error. Please use diagnostic mode to check connectivity.");
            }
            Logger.error("Web service received an empty response with a status of: " + statusLine);
        }
        catch (MalformedURLException mue) {
            Logger.error("Malformed URL: " + address, mue);
        }
        catch (InterruptedIOException timedout) {
            Logger.error("Communication error. Please try again later.", timedout);
        }
        catch (ServerResponseException sre) {
            HashMap<String, Object> result = new HashMap<String, Object>(1);
            result.put("$SERVER_EXCEPTION$", sre);
            return result;
        }
        catch (IOException ioe) {
            Logger.error("Communication error. Please use diagnostic mode to check connectivity. You need to have outbound access to TCP port 443.", ioe);
        }
        catch (Exception pe) {
            Logger.error("Communication error. Please use diagnostic mode to check connectivity.", pe);
        }
        return null;
    }

    private String getLocaleString() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (language.length() != 2) {
            return null;
        }
        if (country.length() != 2) {
            return language;
        }
        return language + '-' + country;
    }

    private Object javaObjectFromJSONString(String s) throws Exception {
        Object o = JSONValue.parseWithException((String)s);
        if (o instanceof JSONArray) {
            return this._listFor((JSONArray)o);
        }
        return this._mapFor((JSONObject)o);
    }

    private Object[] _listFor(JSONArray jsonArray) {
        Object[] array = new Object[jsonArray.size()];
        Iterator iter = jsonArray.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            array[i] = obj instanceof JSONArray ? this._listFor((JSONArray)obj) : (obj instanceof JSONObject ? this._mapFor((JSONObject)obj) : obj);
            ++i;
        }
        return array;
    }

    private Map<String, Object> _mapFor(JSONObject jsonDict) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        if (jsonDict == null) {
            return new HashMap<String, Object>();
        }
        for (Map.Entry entry : jsonDict.entrySet()) {
            Object entryValue = entry.getValue();
            String entryKey = (String)entry.getKey();
            if (entryValue instanceof JSONArray) {
                dict.put(entryKey, this._listFor((JSONArray)entryValue));
                continue;
            }
            if (entryValue instanceof JSONObject) {
                dict.put(entryKey, this._mapFor((JSONObject)entryValue));
                continue;
            }
            dict.put(entryKey, entryValue);
        }
        return dict;
    }

    private class ServerResponseException
    extends IOException {
        private static final long serialVersionUID = 7765806030488005533L;

        public ServerResponseException(String message) {
            super(message);
        }
    }
}

