/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErrorMessageCollector {
    private static ErrorMessageCollector sharedInstance;
    private Map<String, List<String>> packageErrorInfo = new HashMap<String, List<String>>();
    private Map<String, List<String>> packageWarnInfo = new HashMap<String, List<String>>();
    private Map<String, List<String>> packageInfoMessages = new HashMap<String, List<String>>();
    private String currentPackageName;
    private List<String> nonPackageErrorInfo = new ArrayList<String>();
    private List<String> nonPackageWarnInfo = new ArrayList<String>();
    private List<String> nonPackageInfoMessages = new ArrayList<String>();
    private boolean _registeredForNonPackageNotifications = false;
    private boolean _registeredForPackageNotifications = false;

    public static ErrorMessageCollector sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ErrorMessageCollector();
        }
        return sharedInstance;
    }

    public void setupToCollectErrorMessagesForNonPackageBasedModes() {
        if (this._registeredForNonPackageNotifications) {
            return;
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessage", "ErrorMessageLogged", null);
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessage", "WarnMessageLogged", null);
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessage", "InfoMessageLogged", null);
        this._registeredForNonPackageNotifications = true;
    }

    public void setupToCollectErrorMessagesForPackages() {
        if (this._registeredForPackageNotifications) {
            return;
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessageToPackageSummary", "ErrorMessageLogged", null);
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessageToPackageSummary", "WarnMessageLogged", null);
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "addErrorMessageToPackageSummary", "InfoMessageLogged", null);
        defaultCenter.addObserver(ErrorMessageCollector.sharedInstance(), "processingNewPackage", "PackageProcessingWillStart", null);
        this._registeredForPackageNotifications = true;
    }

    private ErrorMessageCollector() {
    }

    public List<String> infoMessagesForPackageNamed(String pkgName) {
        if (pkgName == null || pkgName.length() == 0) {
            return null;
        }
        if (this.packageInfoMessages == null) {
            return null;
        }
        return this.packageInfoMessages.get(pkgName);
    }

    public List<String> warningMessagesForPackageNamed(String pkgName) {
        if (pkgName == null || pkgName.length() == 0) {
            return null;
        }
        if (this.packageWarnInfo == null) {
            return null;
        }
        return this.packageWarnInfo.get(pkgName);
    }

    public List<String> errorMessagesForPackageNamed(String pkgName) {
        if (pkgName == null || pkgName.length() == 0) {
            return null;
        }
        if (this.packageErrorInfo == null) {
            return null;
        }
        return this.packageErrorInfo.get(pkgName);
    }

    public void addErrorMessageToPackageSummary(Notification aNotification) {
        String errorMessage;
        Object o;
        if (aNotification == null || this.currentPackageName == null || this.currentPackageName.length() == 0 || this.packageErrorInfo == null) {
            return;
        }
        Map<String, Object> userInfo = aNotification.getUserInfo();
        Logger.Level logLevel = Logger.Level.Error;
        if (userInfo != null && (o = userInfo.get("logLevel")) != null) {
            logLevel = (Logger.Level)((Object)o);
        }
        if ((errorMessage = (String)aNotification.getObject()) == null) {
            return;
        }
        List<String> errorArray = null;
        if (logLevel == Logger.Level.Error) {
            errorArray = this.packageErrorInfo.get(this.currentPackageName);
            if (errorArray == null) {
                errorArray = new ArrayList<String>();
                this.packageErrorInfo.put(this.currentPackageName, errorArray);
            }
        } else if (logLevel == Logger.Level.Warn) {
            errorArray = this.packageWarnInfo.get(this.currentPackageName);
            if (errorArray == null) {
                errorArray = new ArrayList<String>();
                this.packageWarnInfo.put(this.currentPackageName, errorArray);
            }
        } else if (logLevel == Logger.Level.Info && (errorArray = this.packageInfoMessages.get(this.currentPackageName)) == null) {
            errorArray = new ArrayList<String>();
            this.packageInfoMessages.put(this.currentPackageName, errorArray);
        }
        if (!errorArray.contains(errorMessage)) {
            errorArray.add(errorMessage);
        }
    }

    public void processingNewPackage(Notification aNotification) {
        if (aNotification == null) {
            return;
        }
        File aPkgFile = (File)aNotification.getObject();
        this.currentPackageName = aPkgFile == null ? null : aPkgFile.getPath();
    }

    public void addErrorMessage(Notification aNotification) {
        String errorMessage;
        Object o;
        if (aNotification == null || this.nonPackageErrorInfo == null) {
            return;
        }
        Map<String, Object> userInfo = aNotification.getUserInfo();
        Logger.Level logLevel = Logger.Level.Error;
        if (userInfo != null && (o = userInfo.get("logLevel")) != null) {
            logLevel = (Logger.Level)((Object)o);
        }
        if ((errorMessage = (String)aNotification.getObject()) == null) {
            return;
        }
        if (logLevel == Logger.Level.Error) {
            if (!this.nonPackageErrorInfo.contains(errorMessage)) {
                this.nonPackageErrorInfo.add(errorMessage);
            }
        } else if (logLevel == Logger.Level.Warn) {
            if (!this.nonPackageWarnInfo.contains(errorMessage)) {
                this.nonPackageWarnInfo.add(errorMessage);
            }
        } else if (logLevel == Logger.Level.Info && !this.nonPackageInfoMessages.contains(errorMessage)) {
            this.nonPackageInfoMessages.add(errorMessage);
        }
    }

    public List<String> nonPackageErrorInfo() {
        return this.nonPackageErrorInfo;
    }
}

