/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter;

import com.apple.transporter.WebService;
import com.apple.transporter.factory.OperationFactory;
import com.apple.transporter.factory.WebServiceFactory;
import com.apple.transporter.log.Logger;
import com.apple.transporter.operation.Operation;
import com.apple.transporter.operation.option.AuthSessionIdOption;
import com.apple.transporter.operation.option.AuthSharedSecretOption;
import com.apple.transporter.operation.option.BaseOption;
import com.apple.transporter.operation.option.ConnectionServiceAuthTokenOption;
import com.apple.transporter.operation.option.ConnectionServicePoolSizeOption;
import com.apple.transporter.operation.option.ConnectionServicePortOption;
import com.apple.transporter.operation.option.EnumeratedValueOption;
import com.apple.transporter.operation.option.ExtendedOptions;
import com.apple.transporter.operation.option.LogPasswordOption;
import com.apple.transporter.operation.option.MaxHeapOption;
import com.apple.transporter.operation.option.OptionValidationException;
import com.apple.transporter.operation.option.Validatable;
import com.apple.transporter.operation.option.WONoPauseOption;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;

public class CommandLineOptionProcessor {
    private static final String HELP = "help";
    private static final String VERSION = "version";
    private static final String INFO = "info";
    private static final String MODE = "m";
    private static final String VERBOSITY = "v";
    private static final String OUTPUT = "o";
    private static final String PROPERTY = "D";
    private static final int DEFAULT_HELP_TEXT_WIDTH = 86;

    private Options makeGlobalOptions(boolean includeHidden) {
        Options options = new Options();
        Option helpOption = new Option(HELP, true, "Show this help.  If a mode value is specified, show help specific to that mode.");
        helpOption.setOptionalArg(true);
        OptionGroup group = new OptionGroup();
        group.addOption(helpOption);
        group.addOption(new Option(VERSION, false, "The -version option should be used by itself and returns the version of the tool."));
        group.addOption(new Option(INFO, false, "The -info option should be used by itself and returns the copyright notice and acknowledgements."));
        group.addOption(new Option(MODE, true, "The -m option specifies the tool's mode.  The valid values are: verify, upload, provider, diagnostic, lookupMetadata, createArtist, lookupArtist, status, statusAll, createMetadataTicket, queryTickets, generateSchema, transferTest, downloadMetadataGuides, iTunesExtraQCDownload, iTunesLPQCDownload, listReports, requestReport"));
        options.addOptionGroup(group);
        options.addOption((Option)new EnumeratedValueOption(VERBOSITY, new String[]{"off", "detailed", "informational", "critical", "eXtreme"}, "The -v option specifies the level of logging.  The five values are: off, detailed, informational, critical, eXtreme."));
        options.addOption((Option)new BaseOption(OUTPUT, true, "The -o option specifies the directory and filename you want to use to log output information.  By default, Transporter logs output information to standard out. If you specify a filename, Transporter logs the output to the specified file, as well as to standard out."));
        options.addOption((Option)new MaxHeapOption(this.xmMemory()));
        options.addOption((Option)new WONoPauseOption());
        if (includeHidden) {
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withValueSeparator();
            Option property = OptionBuilder.create((String)PROPERTY);
            options.addOption(property);
            options.addOption((Option)new LogPasswordOption());
            options.addOption((Option)new BaseOption("serviceAddress", true));
            options.addOption((Option)new BaseOption("iTPServiceAddress", true));
            options.addOption((Option)new BaseOption("encodingHouseServiceAddress", true));
            options.addOption((Option)new BaseOption("WebServiceClass", true));
            options.addOption((Option)new EnumeratedValueOption("simpleLogDefaultLog", new String[]{"trace", "debug", INFO, "warn", "error", "fatal"}));
            options.addOption((Option)new BaseOption("callerPWD", true));
            options.addOption((Option)new AuthSessionIdOption());
            options.addOption((Option)new AuthSharedSecretOption());
            options.addOption((Option)new ConnectionServiceAuthTokenOption());
            options.addOption((Option)new ConnectionServicePoolSizeOption());
            options.addOption((Option)new ConnectionServicePortOption());
            options.addOption((Option)new BaseOption("dumpStats", true, true));
            options.addOption((Option)new BaseOption("dumpVersions", true, true));
        }
        return options;
    }

    private long xmMemory() {
        long memorySize = 0L;
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String next : arguments) {
            int length;
            if (!next.startsWith("-Xmx") || (length = next.length()) <= 4) continue;
            String value = next.substring(4);
            memorySize = TransportUtil.sizeSpecToLong(value);
        }
        return memorySize;
    }

    public int parse(String[] argv) {
        try {
            TransporterParser parser = new TransporterParser(null);
            Options globalOptions = this.makeGlobalOptions(true);
            CommandLine line = parser.parse(globalOptions, argv, false);
            for (Option option : line.getOptions()) {
                if (!option.getOpt().equals(PROPERTY)) continue;
                String propName = option.getValue(0);
                String propValue = option.getValue(1);
                System.setProperty(propName, propValue);
            }
            for (Object obj : globalOptions.getOptions()) {
                Option option = (Option)obj;
                if (!(option instanceof BaseOption)) continue;
                ((BaseOption)option).process(line);
            }
            if (line.getOptions().length == 0 || line.hasOption(HELP)) {
                this.showHelp(line);
                return 0;
            }
            if (line.hasOption(VERSION)) {
                this.showVersion();
                return 0;
            }
            if (line.hasOption(INFO)) {
                this.showInfo();
                return 0;
            }
            if (line.hasOption(MODE)) {
                String mode = line.getOptionValue(MODE);
                return this.parseMode(argv, mode, globalOptions);
            }
        }
        catch (AlreadySelectedException e) {
            this.logExclusiveOptionError(e);
            this.showHelp(null);
            return 1;
        }
        catch (MissingOptionException e) {
            this.logMissingOptions(e);
            return 1;
        }
        catch (MissingArgumentException e) {
            Logger.error(e.getMessage());
            this.showHelp(null);
            return 1;
        }
        catch (IllegalArgumentException e) {
            Logger.error(e.getMessage());
            return 1;
        }
        catch (Exception exp) {
            Logger.error("Failed to process command-line arguments", exp);
            return 1;
        }
        return 0;
    }

    private void logMissingOptions(MissingOptionException e) {
        for (Object o : e.getMissingOptions()) {
            if (o instanceof Option) {
                Option option = (Option)o;
                Logger.error("Please specify a value for required option: " + option.getOpt());
                continue;
            }
            if (o instanceof String) {
                Logger.error("Please specify a value for required option: " + o);
                continue;
            }
            if (!(o instanceof OptionGroup)) continue;
            OptionGroup group = (OptionGroup)o;
            StringBuilder buf = new StringBuilder();
            for (Object o1 : group.getOptions()) {
                Option opt = (Option)o1;
                if (opt instanceof BaseOption && ((BaseOption)opt).isHidden()) continue;
                buf.append(opt.getOpt()).append(", ");
            }
            Logger.error("Please specify a value for one of required options: " + buf.toString().substring(0, buf.toString().length() - 2));
        }
    }

    private void logExclusiveOptionError(AlreadySelectedException e) {
        StringBuilder buf = new StringBuilder();
        for (Object o : e.getOptionGroup().getOptions()) {
            Option option = (Option)o;
            buf.append(option.getOpt()).append(", ");
        }
        Logger.error("More than one of the following options was specified: " + buf.toString().substring(0, buf.toString().length() - 2));
    }

    private void logUnknownValues(List<String> values, Consumer<String> loggingFunc) {
        for (String value : values) {
            loggingFunc.accept("The following value was specified but is not recognized as an option value: " + value + ". It may need to be in quotes.");
        }
    }

    private void logUnsupportedOptions(List<String> options, Consumer<String> loggingFunc) {
        for (String option : options) {
            loggingFunc.accept("The following option was specified but is not recognized: " + option);
        }
    }

    private boolean disallowedOptionsFoundAndLogged(String mode, Operation op, List<String> options) {
        for (String option : options) {
            if (!op.unsupportedOptionIsDisallowed(option, mode)) continue;
            Logger.error("The following option was specified but is not allowed: " + option);
            return true;
        }
        return false;
    }

    private boolean helpShowsHiddenOptions() {
        return Boolean.getBoolean("com.apple.transporter.showHiddenOptions");
    }

    private void showHelp(CommandLine line) {
        if (line != null && line.getOptionValue(HELP) != null) {
            String mode = line.getOptionValue(HELP);
            WebService service = WebServiceFactory.instance().createWebService();
            Operation op = OperationFactory.defaultFactory().operationForMode(mode, service);
            if (op != null) {
                String footer;
                Options modeOptions = op.getOptions(this.helpShowsHiddenOptions(), mode);
                String header = modeOptions instanceof ExtendedOptions ? ((ExtendedOptions)modeOptions).getHelpTextHeader() : "";
                String string = footer = modeOptions instanceof ExtendedOptions ? ((ExtendedOptions)modeOptions).getHelpTextFooter() : "";
                if (modeOptions != null) {
                    HelpFormatter helpFormatter = new HelpFormatter();
                    helpFormatter.printHelp(86, "iTMSTransporter -m " + mode, header, modeOptions, footer, true);
                }
            } else {
                Logger.error("Unknown mode: " + mode);
            }
        } else {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp(86, System.getProperty("projectName"), System.getProperty("projectName") + " : iTunes Store Transporter " + System.getProperty("versionNumber"), this.makeGlobalOptions(this.helpShowsHiddenOptions()), " ", true);
        }
    }

    private void showVersion() {
        System.out.println(" ");
        System.out.println(System.getProperty("projectName") + ", version " + System.getProperty("versionNumber"));
        System.out.println(" ");
    }

    private void showInfo() {
        System.out.println();
        System.out.println(System.getProperty("projectName") + ", version " + System.getProperty("versionNumber"));
        System.out.println(System.getProperty("com.apple.transporter.copyright"));
        System.out.println();
        try {
            String info = StreamUtil.getResourceAsString("Acknowledgements");
            System.out.println(info);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseMode(String[] argv, String mode, Options globalOptions) throws ParseException {
        System.setProperty(MODE, mode);
        WebService service = WebServiceFactory.instance().createWebService();
        Operation op = OperationFactory.defaultFactory().operationForMode(mode, service);
        if (op != null) {
            try {
                Options modeOptions = op.getOptions(true, mode);
                if (modeOptions == null) return -1;
                TransporterParser modeParser = new TransporterParser(globalOptions);
                CommandLine commandLine = modeParser.parse(modeOptions, argv, false);
                boolean exitBecauseOfInvalidOptionOrLeftoverArguments = false;
                if (!modeParser.getUnsupportedOptions().isEmpty()) {
                    if (this.disallowedOptionsFoundAndLogged(mode, op, modeParser.getUnsupportedOptions())) {
                        return 1;
                    }
                    if (op.shouldExitIfUnsupportedOptionFound()) {
                        this.logUnsupportedOptions(modeParser.getUnsupportedOptions(), Logger::error);
                        exitBecauseOfInvalidOptionOrLeftoverArguments = true;
                    } else {
                        this.logUnsupportedOptions(modeParser.getUnsupportedOptions(), Logger::warn);
                    }
                }
                if (!modeParser.getLeftoverArguments().isEmpty()) {
                    if (op.shouldExitIfLeftoverArgumentsExist()) {
                        this.logUnknownValues(modeParser.getLeftoverArguments(), Logger::error);
                        return 1;
                    }
                    this.logUnknownValues(modeParser.getLeftoverArguments(), Logger::warn);
                }
                if (exitBecauseOfInvalidOptionOrLeftoverArguments) {
                    return 1;
                }
                ArrayList<Option> commandLineOptions = new ArrayList<Option>(Arrays.asList(commandLine.getOptions()));
                for (Object obj : modeOptions.getOptions()) {
                    Option option = (Option)obj;
                    if (!(option instanceof BaseOption)) continue;
                    BaseOption baseOption = (BaseOption)option;
                    baseOption.process(commandLine);
                    if (!baseOption.shouldValidateMissingOption(commandLine)) continue;
                    commandLineOptions.add(baseOption);
                }
                ArrayList<String> failures = new ArrayList<String>();
                for (Option option : commandLineOptions) {
                    if (!(option instanceof Validatable)) continue;
                    Validatable validatable = (Validatable)option;
                    try {
                        validatable.validate(commandLine);
                    }
                    catch (OptionValidationException e) {
                        String message = e.getMessage();
                        if (failures.contains(message)) continue;
                        Logger.error(message);
                        failures.add(message);
                    }
                }
                if (failures.size() <= 0) return -1;
                return 1;
            }
            catch (MissingOptionException e) {
                this.logMissingOptions(e);
                return 1;
            }
            catch (AlreadySelectedException e) {
                this.logExclusiveOptionError(e);
                return 1;
            }
            catch (MissingArgumentException e) {
                Logger.error(e.getMessage());
                return 1;
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
                return 1;
            }
        }
        Logger.error("Unknown mode: " + mode);
        return -1;
    }

    private static class TransporterParser
    extends Parser {
        Options globalOptions;
        List<String> unsupportedOptions = new ArrayList<String>();

        TransporterParser(Options globalOptions) {
            this.globalOptions = globalOptions;
        }

        protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
            ArrayList<String> tokens = new ArrayList<String>();
            boolean eatTheRest = false;
            boolean skipNextArg = false;
            boolean skipUntilHyphen = false;
            for (int i = 0; i < arguments.length; ++i) {
                String arg = arguments[i];
                if ("--".equals(arg)) {
                    eatTheRest = true;
                    skipUntilHyphen = false;
                    tokens.add("--");
                } else if ("-".equals(arg)) {
                    skipUntilHyphen = false;
                    tokens.add("-");
                } else if (arg.startsWith("-")) {
                    skipUntilHyphen = false;
                    String opt = arg;
                    if (arg.startsWith("--")) {
                        opt = arg.substring(2, arg.length());
                    } else if (arg.startsWith("-")) {
                        opt = arg.substring(1, arg.length());
                    }
                    opt = this.findCaseInsensitiveOption(options, opt);
                    if (options.hasOption(opt)) {
                        if (arg.startsWith("--")) {
                            opt = "--" + opt;
                        } else if (arg.startsWith("-")) {
                            opt = "-" + opt;
                        }
                        tokens.add(opt);
                    } else if (this.globalOptions != null && this.globalOptions.hasOption(opt)) {
                        if (this.globalOptions.getOption(opt).hasArg()) {
                            skipNextArg = true;
                        }
                    } else if (opt.indexOf(61) != -1 && options.hasOption(opt.substring(0, opt.indexOf(61)))) {
                        tokens.add(arg.substring(0, arg.indexOf(61)));
                        tokens.add(arg.substring(arg.indexOf(61) + 1));
                    } else if (this.globalOptions == null || opt.indexOf(61) == -1 || !this.globalOptions.hasOption(opt.substring(0, opt.indexOf(61)))) {
                        if (options.hasOption(arg.substring(0, 2)) && arg.substring(0, 2).equals("-D")) {
                            tokens.add(arg.substring(0, 2));
                            tokens.add(arg.substring(2));
                        } else if (this.globalOptions == null || !this.globalOptions.hasOption(arg.substring(0, 2))) {
                            eatTheRest = stopAtNonOption;
                            skipUntilHyphen = true;
                            this.unsupportedOptions.add(arg);
                        }
                    }
                } else if (!skipNextArg) {
                    if (!skipUntilHyphen) {
                        tokens.add(arg);
                    }
                } else {
                    skipNextArg = false;
                }
                if (!eatTheRest) continue;
                ++i;
                while (i < arguments.length) {
                    tokens.add(arguments[i]);
                    ++i;
                }
            }
            return tokens.toArray(new String[tokens.size()]);
        }

        private String findCaseInsensitiveOption(Options options, String opt) {
            if (options == null || this.globalOptions == null || options.hasOption(opt)) {
                return opt;
            }
            Collection opts = options.getOptions();
            if (opts != null) {
                for (Option option : opts) {
                    if (!opt.equalsIgnoreCase(option.getOpt()) && !opt.equalsIgnoreCase(option.getLongOpt())) continue;
                    return option.getOpt();
                }
            }
            return opt;
        }

        public List<String> getLeftoverArguments() {
            String[] args = this.cmd.getArgs();
            return null == args ? Collections.emptyList() : Arrays.asList(args);
        }

        public List<String> getUnsupportedOptions() {
            return this.unsupportedOptions;
        }
    }
}

